<?php

namespace MEC_GSB\Core;
// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 * Loader.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class Loader
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_GSB
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::preLoad();
        self::setHooks();
        self::registerAutoloadFiles();
        self::loadInits();
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        self::$dir     = MECGSBDIR . 'core';
    }

    /**
     * Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks()
    {
        add_action('admin_init', function () {
            \MEC_GSB\Autoloader::load('MEC_GSB\Core\checkLicense\GutenbergSingleBuilderAddonUpdateActivation');
        });
    }

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        include_once self::$dir . DS . 'autoloader' . DS . 'autoloader.php';
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public static function registerAutoloadFiles()
    {
        if (!class_exists('\MEC_GSB\Autoloader')) {
            return;
        }

        \MEC_GSB\Autoloader::addClasses(
            [
                'MEC_GSB\\Core\\base\\GSBBase' => self::$dir . '/base/base.php',
                'MEC_GSB\\Core\\Gutenberg\\Gutenberg' => self::$dir . '/gutenberg/Gutenberg.php',
                'MEC_GSB\\Core\\Gutenberg\\SingleBlocks' => self::$dir . '/gutenberg/SingleBlocks.php',
                'MEC_GSB\\Core\\Gutenberg\\StyleManagerBase' => self::$dir . '/gutenberg/StyleManagerBase.php',
                'MEC_GSB\\Core\\Gutenberg\\StyleManagerControls' => self::$dir . '/gutenberg/StyleManagerControls.php',

                // Licensing
                'MEC_GSB\\Core\\checkLicense\\GutenbergSingleBuilderAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',
            ]
        );
    }

    /**
     * Load Init
     *
     * @since     1.0.0
     */
    public static function loadInits()
    {
        \MEC_GSB\Autoloader::load('MEC_GSB\Core\base\GSBBase');
        \MEC_GSB\Autoloader::load('MEC_GSB\Core\Gutenberg\Gutenberg');
        \MEC_GSB\Autoloader::load('MEC_GSB\Core\Gutenberg\SingleBlocks');
        \MEC_GSB\Autoloader::load('MEC_GSB\Core\Gutenberg\StyleManagerBase');
        \MEC_GSB\Autoloader::load('MEC_GSB\Core\Gutenberg\StyleManagerControls');
    }
} //Loader

Loader::instance();
