<?php

namespace MEC_GSB\Core\base;

use MEC;
use MEC\Base;
use MEC\SingleBuilder\Widgets\EventSocialShare\EventSocialShare;
use MEC_kses;
use WP_Query;
use WP_REST_Response;
use MEC\Settings\Settings;
use MEC_feature_occurrences;
use MEC_GSB\Core\Gutenberg\StyleManagerControls;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class GSBBase
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_GSB
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @return  object
     * @since   1.0.0
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
        $mec_options = get_option('mec_options', array());
        $settings = isset($mec_options['settings']) ? $mec_options['settings'] : array();
        if (isset($settings['single_single_style']) && $settings['single_single_style'] == 'gsb-builder') {
            self::define_public_hooks();
        }

    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('init', array($This, 'mec_gsb_post_type'));
//        add_action('wp_ajax_gsb_custom_event_for_editor', array($This, 'gsb_custom_event') );
        add_action('rest_api_init', [$This, 'routes_api_gsb']);

        add_action('wp_enqueue_scripts', [$This, 'enqueue_styles']);
        add_action('wp_enqueue_scripts', [$This, 'enqueue_scripts']);
        add_action('admin_enqueue_scripts', [$This, 'enqueue_styles']);
        add_action('admin_enqueue_scripts', [$This, 'enqueue_scripts']);

        add_action('mec_single_style_setting_after', array($This, 'add_gsb_settings'));
        add_filter('single_template', array($This, 'gsb_single_template'));
        add_action('gsb_single_template', array($This, 'gsb_single'));
        add_action('save_post_mec-events', array($This, 'save_event'), 10, 1);
        add_action('add_meta_boxes', array($This, 'sb_metabox'));
        add_action('admin_menu', array($This, 'menus'), 20);
        add_filter('admin_body_class', array($This, 'gsb_admin_body_class'));
        add_action('enqueue_block_editor_assets', function () {
            if (isset($_REQUEST['post'])) {
                if (get_post($_REQUEST['post'])->post_type === "mec_gsb") {
                    //Add Style Single Event Mec
                    wp_enqueue_script(
                        'mec-gutenberg-single-builder-js',
                        MECGSBDASSETS . 'js/mec-gsb.js',
                        array(),
                        MECGSBVERSION,
                        true
                    );

                    wp_enqueue_style(
                        'style_single_event_mec',
                        '/wp-content/plugins/modern-events-calendar/assets/css/frontend.min.css',
                        array(),
                        MECGSBVERSION,
                        'all'
                    );

                    wp_enqueue_script(
                        'js_single_event_mec',
                        '/wp-content/plugins/modern-events-calendar/assets/js/frontend.js',
                        array(),
                        MECGSBVERSION,
                        true
                    );
                }
            }
        }, 20);

    }

    function gsb_admin_body_class($classes)
    {
        if (isset($_REQUEST['post'])) {
            if (get_post($_REQUEST['post'])->post_type === "mec_gsb") {
                return "$classes mec-single-event";
            } else {
                return "$classes";
            }
        } else {
            return "$classes";
        }
    }

    /**
     * Register the stylesheets for the admin area.
     *
     * @since    1.0.0
     */
    public static function enqueue_styles()
    {
        if ((isset($_REQUEST['post_type']) && $_REQUEST['post_type'] === "mec_gsb")
            || (isset($_REQUEST['action']) && $_REQUEST['action'] === "edit")) {
                wp_enqueue_style(MECGSBSLUG."-admin", MECGSBDASSETS . 'css/mec-gutenberg-single-builder-admin.css', array(), MECGSBVERSION, 'all');
        }

        //Add Style Font Icon
        wp_enqueue_style('mec-gsb-elementor-font-icon', MECGSBDASSETS . 'css/icon-fonts-elementor.css', array(), MECGSBVERSION, 'all');
        wp_enqueue_style('mec-gsb-font-icon', MECGSBDASSETS . 'css/icon-fonts-mec.css', array(), MECGSBVERSION, 'all');
    }


    /**
     * Register the JavaScript for the admin area.
     *
     * @since    1.0.0
     */
    public static function enqueue_scripts()
    {
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {

    }

    /**
     * Add menus mec_gsb
     *
     * @since    1.0.0
     */
    public function menus()
    {
        add_submenu_page(
            'mec-intro',
            __('MEC Gutenberg Single Builder', 'mec-gsb'),
            __('Gutenberg Single Builder', 'mec-gsb'),
            'edit_posts',
            'edit.php?post_type=mec_gsb'
        );
    }


    /**
     * Register mec_gsb post type and Control Style
     *
     * @since    1.0.0
     */
    function mec_gsb_post_type()
    {


        $labels = array(
            'name' => _x('Events Gutenberg Single Builder', 'Post Type General Name', 'mec-gsb'),
            'singular_name' => _x('Events Gutenberg Single Page', 'Post Type Singular Name', 'mec-gsb'),
            'menu_name' => __('Events Gutenberg Single Builder', 'mec-gsb'),
            'parent_item_colon' => __('Parent Gutenberg Single Builder', 'mec-gsb'),
            'all_items' => __('Events Gutenberg Single Builder', 'mec-gsb'),
            'view_item' => __('View Gutenberg Single Builder', 'mec-gsb'),
            'add_new_item' => __('Design new event gutenberg single page', 'mec-gsb'),
            'add_new' => __('Add New', 'mec-gsb'),
            'edit_item' => __('Edit Gutenberg Single Builder', 'mec-gsb'),
            'update_item' => __('Update Gutenberg Single Builder', 'mec-gsb'),
            'search_items' => __('Search Gutenberg Single Builder', 'mec-gsb'),
            'not_found' => __('Not Found', 'mec-gsb'),
            'not_found_in_trash' => __('Not found in Trash', 'mec-gsb'),
        );

        $args = array(
            'label' => __('Events Gutenberg Single Page Builder', 'mec-gsb'),
            'description' => __('Gutenberg Single Builder news and reviews', 'mec-gsb'),
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'show_in_menu' => false,
            'query_var' => true,
            'has_archive' => false,
            'hierarchical' => false,
            'menu_position' => 49,
            'rewrite' => ['slug' => 'mec_gsb'],
            'show_in_rest' => true,
            'supports' => array('title', 'editor', 'custom-fields'),
            'labels' => $labels,
            'exclude_from_search' => true
        );

        register_post_type('mec_gsb', $args);

        //Add Control for Style Block
        if (!function_exists('webnus_sm_register_style_for_block')) {
            return;
        }

        //Add Style Controls for GSB Blocks
        $this->add_style_manager('.event-title-gsb', 'mec-gsb/event-title', 'Event Title', 'title');
        $this->add_style_manager('.event-image-gsb', 'mec-gsb/event-featured-image', 'Event Image', 'image');
        $this->add_style_manager('.event-gallery-gsb', 'mec-gsb/event-gallery', 'Event Gallery', 'event_gallery');
        $this->add_style_manager('.event-content-gsb', 'mec-gsb/event-content', 'Event Content', 'content');
        $this->add_style_manager('.event-tags-gsb', 'mec-gsb/event-tags', 'Event Tags', 'tags');
        $this->add_style_manager('.event-count-down-gsb', 'mec-gsb/event-count-down', 'Event Count Down', 'count_down');
        $this->add_style_manager('.event-local-time-gsb', 'mec-gsb/event-local-time', 'Event Local Time', 'local_time');
        $this->add_style_manager('.event-category-gsb', 'mec-gsb/event-category', 'Event Category', 'category');
        $this->add_style_manager('.event-date-module-gsb', 'mec-gsb/event-date-module', 'Event Date Module', 'date_module');
        $this->add_style_manager('.event-time-module-gsb', 'mec-gsb/event-time-module', 'Event Time Module', 'time_module');
        $this->add_style_manager('.event-banner-gsb', 'mec-gsb/event-banner', 'Event Banner', 'banner');
        $this->add_style_manager('.event-cost-gsb', 'mec-gsb/event-cost', 'Event Cost', 'cost');
        $this->add_style_manager('.event-labels-gsb', 'mec-gsb/event-labels', 'Event Labels', 'labels');
        $this->add_style_manager('.event-more-info-gsb', 'mec-gsb/event-more-info', 'Event More Info', 'more_info');
        $this->add_style_manager('.event-organizers-gsb', 'mec-gsb/event-organizers', 'Event Organizers', 'organizers');
        $this->add_style_manager('.event-speakers-gsb', 'mec-gsb/event-speakers', 'Event Speakers', 'speakers');
        $this->add_style_manager('.event-social-share-gsb', 'mec-gsb/event-social-share', 'Event Social Share', 'social_share');
        $this->add_style_manager('.event-qr-code-gsb', 'mec-gsb/event-qr-code', 'Event Qr Code', 'qr_code');
        $this->add_style_manager('.event-next-gsb', 'mec-gsb/event-next', 'Event Next', 'next');
        $this->add_style_manager('.event-hourly-schedule-gsb', 'mec-gsb/event-hourly-schedule', 'Event Hourly Schedule', 'hourly_schedule');
        $this->add_style_manager('.event-attendees-gsb', 'mec-gsb/event-attendees', 'Event Attendees', 'attendees');
        $this->add_style_manager('.event-booking-gsb', 'mec-gsb/event-booking', 'Event Booking', 'booking');
        $this->add_style_manager('.event-breadcrumbs-gsb', 'mec-gsb/event-breadcrumbs', 'Event Breadcrumbs', 'breadcrumbs');
        $this->add_style_manager('.event-cancellation-gsb', 'mec-gsb/event-cancellation', 'Event Cancellation', 'cancellation');
        $this->add_style_manager('.event-data-gsb', 'mec-gsb/event-data', 'Event Data', 'data');
        $this->add_style_manager('.event-map-gsb', 'mec-gsb/event-map', 'Event Map', 'map');
        $this->add_style_manager('.event-next-previous-gsb', 'mec-gsb/event-next-previous', 'Event Next/Previous', 'next_Previous');
        $this->add_style_manager('.event-public-download-gsb', 'mec-gsb/event-public-download', 'Event Public Download', 'public_download');
        $this->add_style_manager('.event-register-button-gsb', 'mec-gsb/event-register-button', 'Event Register Button', 'register_button');
        $this->add_style_manager('.event-related-gsb', 'mec-gsb/event-related', 'Event Related', 'related');
        $this->add_style_manager('.event-weather-gsb', 'mec-gsb/event-weather', 'Event Weather', 'weather');
        $this->add_style_manager('.event-export-gsb', 'mec-gsb/event-export', 'Event Export', 'export');
        $this->add_style_manager('.event-faq-gsb', 'mec-gsb/event-faq', 'Event FAQ', 'faq');
        $this->add_style_manager('.event-locations-gsb', 'mec-gsb/event-locations', 'Event Locations', 'locations');
        $this->add_style_manager('.event-sponsors-gsb', 'mec-gsb/event-sponsors', 'Event Sponsors', 'sponsors');
        $this->add_style_manager('.event-trailer-url-gsb', 'mec-gsb/event-trailer-url', 'Event Trailer Url', 'trailer_url');
        $this->add_style_manager('.event-rsvp-gsb', 'mec-gsb/event-rsvp', 'Event RSVP', 'rsvp');

        //for Load Single Page MEC GSB
        flush_rewrite_rules();
    }


    /**
     * Add Style Manager Controls for Blocks
     *
     * @since     1.0.0
     */
    public function add_style_manager($selector, $block_name, $title_control, $type = '')
    {
        switch ($type) {
            case 'title':
                $advanced_heading_selector = $selector . ' .mec-single-title';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->text($advanced_heading_selector, 'Text ' . $title_control, '');
                $advanced_heading_styles->padding_margin($advanced_heading_selector, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector, 'Shadow Box/Text ' . $title_control, '-');
                break;
            case 'image':
                $advanced_heading_selector_img = $selector . ' img';
                $advanced_heading_selector = $selector;
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector, 'Background ' . $title_control, '-');
                $advanced_heading_styles->size($advanced_heading_selector_img, 'Size ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_img, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_img, 'Shadow Box/Text ' . $title_control, '-');
                break;
            case 'event_gallery':

                $advanced_heading_selector = $selector;
                $gallery_image_list_box = $selector . ' .mec-event-gallery-image-list-wrapper';
                $gallery_image_list = $gallery_image_list_box . ' img';
                $gallery_image_box = $selector . ' .mec-event-gallery-image';
                $gallery_image = $gallery_image_box . ' img';


                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector, 'Background ' . $title_control, '-');
                $advanced_heading_styles->size($advanced_heading_selector, 'Size ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector, 'Shadow Box/Text ' . $title_control, '-');

                // $advanced_heading_styles->background($gallery_image_list_box, 'Background i' . $title_control, '-');
                // $advanced_heading_styles->size($gallery_image_list, 'Size ' . $title_control, '-');
                // $advanced_heading_styles->padding_margin($gallery_image_list, 'Padding/Margin ' . $title_control, '-');
                // $advanced_heading_styles->border($gallery_image_list, 'Border ' . $title_control, '-');
                // $advanced_heading_styles->shadow($gallery_image_list, 'Shadow Box/Text ' . $title_control, '-');

                // $advanced_heading_styles->background($gallery_image_box, 'Background b' . $title_control, '-');
                // $advanced_heading_styles->size($gallery_image, 'Size ' . $title_control, '-');
                // $advanced_heading_styles->padding_margin($gallery_image, 'Padding/Margin ' . $title_control, '-');
                // $advanced_heading_styles->border($gallery_image, 'Border ' . $title_control, '-');
                // $advanced_heading_styles->shadow($gallery_image, 'Shadow Box/Text ' . $title_control, '-');
                break;


            case 'content':
                $advanced_heading_selector_p = $selector . ' .mec-events-content p';
                $advanced_heading_selector_div = $selector . ' .mec-events-content';
                $advanced_heading_selector = $selector;
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->text($advanced_heading_selector_div . ',' . $advanced_heading_selector_p, 'Text ' . $title_control, '');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                break;
            case 'tags':
                $advanced_heading_selector_div = $selector . ' .mec-events-meta-group-tags';
                $advanced_heading_selector_a = $selector . ' .mec-events-meta-group-tags a';
                $advanced_heading_selector = $selector;
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_a, 'Text Link ' . $title_control, 'Link');
                $advanced_heading_styles->background($advanced_heading_selector_a, 'Background Link ' . $title_control, 'Link');
                $advanced_heading_styles->border($advanced_heading_selector_a, 'Border Link ' . $title_control, 'Link');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_a, 'Padding/Margin Link ' . $title_control, 'Link');
                break;
            case 'count_down':
                $advanced_heading_selector_div = $selector . ' .mec-events-meta-group-countdown';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-events-meta-group-countdown .countdown-w span, ' . $selector . ' .countdown-w .block-w, ' . $selector . ' .flip-clock-wrapper ul li a div.up div.inn, ' . $selector . ' .flip-clock-wrapper ul li a div.down div.inn', 'Text Counter ' . $title_control, 'Counter');
                $advanced_heading_styles->background($selector . ' .countdown-w .block-w, ' . $selector . ' .flip-clock-wrapper ul li a div.up div.inn, ' . $selector . ' .flip-clock-wrapper ul li a div.down div.inn', 'Background Counter ' . $title_control, 'Counter');
                $advanced_heading_styles->padding_margin($selector . ' .countdown-w .block-w', 'Padding/Margin Counter ' . $title_control, 'Counter');
                $advanced_heading_styles->text($selector . ' .countdown-w .clockdiv li p, ' . $selector . ' .flip-clock-divider .flip-clock-label, ' . $selector . ' .countdown-w .clockdiv li p, ' . $selector . ' .flip-clock-divider .flip-clock-label', 'Text Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .countdown-w .clockdiv li p, ' . $selector . ' .flip-clock-divider .flip-clock-label', 'Padding/Margin Label ' . $title_control, 'Label');
                $advanced_heading_styles->text($selector . ' .mec-events-meta-group-countdown h3', 'Text Message ' . $title_control, 'Message');
                break;
            case 'local_time':
                $advanced_heading_selector_div = $selector . ' .mec-local-time-details';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-event-more-info', 'Text Widget ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-local-time-details .mec-local-time', 'Text Typography ' . $title_control, 'Typography');
                $advanced_heading_styles->padding_margin($selector . ' .mec-local-time-details .mec-local-time', 'Padding/Margin Typography' . $title_control, 'Typography');
                $advanced_heading_styles->text($selector . ' .mec-local-time-details i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-local-time-details li', 'Text Label ' . $title_control, 'Label');
                break;
            case 'category':
                $advanced_heading_selector_div = $selector . ' .mec-single-event-category';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-single-event-category dt', 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-category dt', 'Padding/Margin Title ' . $title_control, 'Title');
                $advanced_heading_styles->text($selector . ' .mec-single-event-category i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-events-event-categories a', 'Text Link ' . $title_control, 'Link');
                $advanced_heading_styles->text($selector . ' .mec-events-event-categories a', 'Text Link Icon ' . $title_control, 'LinkIcon');
                $advanced_heading_styles->text($selector . ' .mec-single-event-category dd a:hover i:before', 'Text Hover Link Icon ' . $title_control, 'HoverLinkIcon');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-category dd', 'Padding/Margin Label ' . $title_control, 'Label');
                break;
            case 'date_module':
                $advanced_heading_selector_div = $selector . ' .mec-single-event-date';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-single-event-date .mec-date', 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->text($selector . ' .mec-single-event-date i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-single-event-date span', 'Text Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-date .mec-events-abbr', 'Padding/Margin Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-date dd', 'Padding/Margin Label Box ' . $title_control, 'LabelBox');
                $advanced_heading_styles->text($selector . ' .mec-single-event-date .mec-holding-status-ongoing', 'Text Ongoing ' . $title_control, 'Ongoing');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-date .mec-holding-status-ongoing', 'Padding/Margin Ongoing ' . $title_control, 'Ongoing');
                $advanced_heading_styles->text($selector . ' .mec-single-event-date .mec-holding-status-expired', 'Text Expired Label ' . $title_control, 'ExpiredLabel');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-date .mec-holding-status-expired', 'Padding/Margin Expired Label ' . $title_control, 'ExpiredLabel');
                break;
            case 'time_module':
                $advanced_heading_selector_div = $selector . ' .mec-single-event-time';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-single-event-time .mec-time', 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-time .mec-time', 'Padding/Margin Title ' . $title_control, 'Title');
                $advanced_heading_styles->text($selector . ' .mec-single-event-time i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-single-event-time .mec-events-abbr', 'Text Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-time .mec-events-abbr', 'Padding/Margin Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-time dd', 'Padding/Margin Label Box ' . $title_control, 'LabelBox');
                break;
            case 'cost':
                $advanced_heading_selector_div = $selector . ' .mec-event-cost';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-event-cost .mec-cost', 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-cost .mec-cost', 'Padding/Margin Title ' . $title_control, 'Title');
                $advanced_heading_styles->text($selector . ' .mec-event-cost i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-event-cost .mec-events-event-cost', 'Text Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-cost .mec-events-event-cost', 'Padding/Margin Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-cost dd', 'Padding/Margin Label Box ' . $title_control, 'LabelBox');
                break;
                case 'banner':
                $advanced_heading_selector_div = $selector . ' .mec-event-banner';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                break;
            case 'labels':
                $advanced_heading_selector_div = $selector . ' .mec-single-event-label';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-single-event-label .mec-cost', 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-label .mec-cost', 'Padding/Margin Title' . $title_control, 'Title');
                $advanced_heading_styles->text($selector . ' .mec-single-event-label i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-single-event-label dd', 'Text Box Label ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-label dd', 'Padding/Margin Box Label ' . $title_control, 'BoxLabel');
                break;
            case 'more_info':
                $advanced_heading_selector_div = $selector . ' .mec-event-more-info';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-event-more-info .mec-cost', 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-more-info .mec-cost', 'Padding/Margin Title ' . $title_control, 'Title');
                $advanced_heading_styles->text($selector . ' .mec-event-more-info i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-event-more-info .mec-more-info-button', 'Text Link ' . $title_control, 'Link');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-more-info .mec-more-info-button', 'Padding/Margin Link ' . $title_control, 'Link');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-more-info dd', 'Padding/Margin Box Label ' . $title_control, 'BoxLabel');
                break;
            case 'organizers':
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->text($selector . ' .mec-single-event-organizer .mec-events-single-section-title', 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-organizer .mec-events-single-section-title', 'Padding/Margin Title ' . $title_control, 'Title');
                $advanced_heading_styles->text($selector . ' .mec-single-event-organizer dd i:before', 'Text Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-organizer dd i', 'Padding/Margin Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->text($selector . ' .mec-single-event-organizer dd h6', 'Text Label ' . $title_control, 'Label');
                $advanced_heading_styles->text($selector . ' .mec-single-event-organizer dd a', 'Text Link ' . $title_control, 'Link');
                $advanced_heading_styles->text($selector . ' .mec-single-event-organizer dd p', 'Text Description ' . $title_control, 'Description');
                $advanced_heading_styles->display($selector . ' .mec-single-event-organizer  .mec-img-organizer', 'Display Image ' . $title_control, 'Image');
                $advanced_heading_styles->size($selector . ' .mec-single-event-organizer  .mec-img-organizer', 'Size Image ' . $title_control, 'Image');
                $advanced_heading_styles->background($selector . ' .mec-single-event-organizer  .mec-img-organizer', 'Background Image ' . $title_control, 'Image');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-organizer  .mec-img-organizer', 'Padding/Margin Image ' . $title_control, 'Image');
                $advanced_heading_styles->border($selector . ' .mec-single-event-organizer  .mec-img-organizer', 'Border Image ' . $title_control, 'Image');
                $advanced_heading_styles->shadow($selector . ' .mec-single-event-organizer  .mec-img-organizer', 'Shadow Box/Text Image ' . $title_control, 'Image');
                $advanced_heading_styles->background($selector . ' .mec-single-event-organizer', 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-single-event-organizer', 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-organizer', 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($selector . ' .mec-single-event-organizer', 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($selector . ' .mec-single-event-organizer', 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-organizer dd', 'Padding/Margin Box Label ' . $title_control, 'BoxLabel');
                $advanced_heading_styles->text($selector . ' .mec-single-event-additional-organizers dd i:before', 'Text Icon Additional ' . $title_control, 'IconAdditional');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-additional-organizers dd i', 'Padding/Margin Icon Additional ' . $title_control, 'IconAdditional');
                $advanced_heading_styles->text($selector . ' .mec-single-event-additional-organizers dd h6', 'Text Label Typography ' . $title_control, 'LabelTypography');
                $advanced_heading_styles->text($selector . ' .mec-single-event-additional-organizers dd a', 'Text Link Typography ' . $title_control, 'LinkTypography');
                $advanced_heading_styles->text($selector . ' .mec-single-event-additional-organizers dd p', 'Text Description Typography ' . $title_control, 'DescriptionTypography');
                $advanced_heading_styles->text($selector . ' .mec-single-event-additional-organizers  .mec-img-organizer', 'Text Other Image ' . $title_control, 'OtherImage');
                $advanced_heading_styles->display($selector . ' .mec-single-event-additional-organizers  .mec-img-organizer', 'Display Other Image ' . $title_control, 'OtherImage');
                $advanced_heading_styles->size($selector . ' .mec-single-event-additional-organizers  .mec-img-organizer', 'Size Other Image ' . $title_control, 'OtherImage');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-additional-organizers  .mec-img-organizer', 'Padding/Margin Other Image ' . $title_control, 'OtherImage');
                $advanced_heading_styles->border($selector . ' .mec-single-event-additional-organizers  .mec-img-organizer', 'Border Other Image ' . $title_control, 'OtherImage');
                $advanced_heading_styles->shadow($selector . ' .mec-single-event-additional-organizers  .mec-img-organizer', 'Shadow Box/Text Other Image ' . $title_control, 'OtherImage');
                $advanced_heading_styles->background($selector . ' .mec-single-event-additional-organizers .mec-single-event-additional-organizer', 'Background Other Box ' . $title_control, 'OtherBox');
                $advanced_heading_styles->text($selector . ' .mec-single-event-additional-organizers', 'Text Other Box ' . $title_control, 'OtherBox');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-additional-organizers .mec-single-event-additional-organizer', 'Padding/Margin Other Box ' . $title_control, 'OtherBox');
                $advanced_heading_styles->border($selector . ' .mec-single-event-additional-organizers .mec-single-event-additional-organizer', 'Border Other Image Additional ' . $title_control, 'OtherImageAdditional');
                $advanced_heading_styles->shadow($selector . ' .mec-single-event-additional-organizers .mec-single-event-additional-organizer', 'Shadow Box/Text Other Box ' . $title_control, 'OtherBox');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-additional-organizers dd', 'Padding/Margin Other Box Label ' . $title_control, 'OtherBoxLabel');
                $advanced_heading_styles->text($selector . ' .mec-single-event-additional-organizers .mec-events-single-section-title', 'Text Title Additional ' . $title_control, 'TitleAdditional');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-additional-organizers .mec-events-single-section-title', 'Padding/Margin Title Additional ' . $title_control, 'TitleAdditional');
                $advanced_heading_styles->padding_margin($selector . ' .mec-single-event-additional-organizers', 'Padding/Margin Additional ' . $title_control, 'Additional');
                $advanced_heading_styles->border($selector . ' .mec-single-event-additional-organizers', 'Border Additional ' . $title_control, 'Additional');
                $advanced_heading_styles->shadow($selector . ' .mec-single-event-additional-organizers', 'Shadow Box/Text Additional ' . $title_control, 'Additional');
                $advanced_heading_styles->background($selector . ' .mec-single-event-additional-organizers', 'Background Additional ' . $title_control, 'Additional');
                break;
            case 'speakers':
                $advanced_heading_selector_div = $selector . ' .mec-speakers';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display Title ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text Title ' . $title_control, 'Title');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background Title ' . $title_control, 'Title');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin Title ' . $title_control, 'Title');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border Title ' . $title_control, 'Title');
                $advanced_heading_styles->background($selector . ' .mec-speakers-details', 'Background Box ' . $title_control, 'Box');
                $advanced_heading_styles->padding_margin($selector . ' .mec-speakers-details', 'Padding/Margin Box ' . $title_control, 'Box');
                $advanced_heading_styles->border($selector . ' .mec-speakers-details', 'Border Box ' . $title_control, 'Box');
                $advanced_heading_styles->shadow($selector . ' .mec-speakers-details', 'Shadow Box/Text Box ' . $title_control, 'Box');
                $advanced_heading_styles->background($selector . ' .mec-speakers-details ul li', 'Background Box List ' . $title_control, 'BoxList');
                $advanced_heading_styles->padding_margin($selector . ' .mec-speakers-details ul li', 'Padding/Margin Box List ' . $title_control, 'BoxList');
                $advanced_heading_styles->border($selector . ' .mec-speakers-details ul li', 'Border Box List ' . $title_control, 'BoxList');
                $advanced_heading_styles->shadow($selector . ' .mec-speakers-details ul li', 'Shadow Box/Text Box List ' . $title_control, 'BoxList');
                $advanced_heading_styles->text($selector . ' .mec-speakers-details ul li .mec-speaker-name', 'Text Name ' . $title_control, 'Name');
                $advanced_heading_styles->padding_margin($selector . ' .mec-speakers-details ul li .mec-speaker-name', 'Padding/Margin Name ' . $title_control, 'Name');
                $advanced_heading_styles->text($selector . ' .mec-speakers-details ul li .mec-speaker-job-title', 'Text Name Hover ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-speakers-details ul li .mec-speaker-job-title', 'Padding/Margin Name Hover ' . $title_control, 'NameHover');
                $advanced_heading_styles->background($selector . ' .mec-speakers-details ul li .mec-speaker-avatar a img', 'Background Image ' . $title_control, 'Image');
                $advanced_heading_styles->padding_margin($selector . ' .mec-speakers-details ul li .mec-speaker-avatar a img', 'Padding/Margin Image ' . $title_control, 'Image');
                $advanced_heading_styles->size($selector . ' .mec-speakers-details ul li .mec-speaker-avatar a img', 'Size Image ' . $title_control, 'Image');
                $advanced_heading_styles->border($selector . ' .mec-speakers-details ul li .mec-speaker-avatar a img', 'Border Image ' . $title_control, 'Image');
                $advanced_heading_styles->shadow($selector . ' .mec-speakers-details ul li .mec-speaker-avatar a img', 'Shadow Box/Text Image ' . $title_control, 'Image');
                $advanced_heading_styles->border($selector . ' .mec-speakers-details ul li .mec-speaker-avatar a:hover img', 'Border Hover Image ' . $title_control, 'HoverImage');
                $advanced_heading_styles->shadow($selector . ' .mec-speakers-details ul li .mec-speaker-avatar a:hover img', 'Shadow Box/Text Hover Image ' . $title_control, 'HoverImage');
                $advanced_heading_styles->background($selector . ' .mec-hourly-schedule-speaker-info', 'Background Hourly ' . $title_control, 'Hourly');
                $advanced_heading_styles->padding_margin($selector . ' .mec-hourly-schedule-speaker-info', 'Padding/Margin Hourly ' . $title_control, 'Hourly');
                $advanced_heading_styles->shadow($selector . ' .mec-hourly-schedule-speaker-info', 'Shadow Box/Text Hourly Name ' . $title_control, 'HourlyName');
                $advanced_heading_styles->text($selector . ' .mec-hourly-schedule-speaker-name', 'Text Hourly ' . $title_control, 'Hourly');
                $advanced_heading_styles->padding_margin($selector . ' .mec-hourly-schedule-speaker-name', 'Padding/Margin Hourly Name ' . $title_control, 'HourlyName');
                $advanced_heading_styles->text($selector . ' .mec-hourly-schedule-speaker-job-title', 'Text Hourly Title ' . $title_control, 'HourlyTitle');
                $advanced_heading_styles->padding_margin($selector . ' .mec-hourly-schedule-speaker-job-title', 'Padding/Margin Hourly Title ' . $title_control, 'HourlyTitle');
                $advanced_heading_styles->text($selector . ' .mec-hourly-schedule-speaker-description', 'Text Hourly Description ' . $title_control, 'HourlyDescription');
                $advanced_heading_styles->padding_margin($selector . ' .mec-hourly-schedule-speaker-description', 'Padding/Margin Hourly Description ' . $title_control, 'HourlyDescription');
                $advanced_heading_styles->text($selector . ' .mec-hourly-schedule-speaker-contact-information a i', 'Text Hourly Icon ' . $title_control, 'HourlyIcon');
                $advanced_heading_styles->background($selector . ' .mec-hourly-schedule-speaker-contact-information a i', 'Background Hourly Icon ' . $title_control, 'HourlyIcon');
                $advanced_heading_styles->border($selector . ' .mec-hourly-schedule-speaker-contact-information a i', 'Border Hover Hourly Icon ' . $title_control, 'HourlyIcon');
                $advanced_heading_styles->size($selector . ' .mec-hourly-schedule-speaker-thumbnail img', 'Size Hourly Thumbnail ' . $title_control, 'HourlyThumbnail');
                $advanced_heading_styles->padding_margin($selector . ' .mec-hourly-schedule-speaker-thumbnail', 'Padding/Margin Hourly Thumbnail ' . $title_control, 'HourlyThumbnail');
                $advanced_heading_styles->border($selector . ' .mec-hourly-schedule-speaker-thumbnail', 'Border Hourly Thumbnail ' . $title_control, 'HourlyThumbnail');
                $advanced_heading_styles->shadow($selector . ' .mec-hourly-schedule-speaker-thumbnail', 'Shadow Box/Text Hourly Thumbnail ' . $title_control, 'HourlyThumbnail');
                break;
            case 'social_share':
                $advanced_heading_selector_div = $selector . ' .mec-social-single';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->display($selector . ' .mec-social-single:before', 'Display Border ' . $title_control, 'Border');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-event-social', 'Background Social ' . $title_control, 'Social');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-social', 'Padding/Margin Social ' . $title_control, 'Social');
                $advanced_heading_styles->border($selector . ' .mec-event-social', 'Border Social ' . $title_control, 'Social');
                $advanced_heading_styles->shadow($selector . ' .mec-event-social', 'Shadow Box/Text Social ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-event-social li.mec-event-social-icon a', 'Text Icon' . $title_control, 'Icon');
                $advanced_heading_styles->size($selector . ' .mec-event-social li.mec-event-social-icon a svg', 'Size Icon Svg ' . $title_control, 'IconSvg');
                $advanced_heading_styles->border($selector . ' .mec-event-social li.mec-event-social-icon a', 'Border Icon ' . $title_control, 'Icon');
                $advanced_heading_styles->size($selector . ' .mec-event-social li.mec-event-social-icon a', 'Size Icon ' . $title_control, 'Icon');
                break;
            case 'qr_code':
                $advanced_heading_selector_div = $selector . ' .mec-qrcode-details';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                break;
            case 'next':
                $advanced_heading_selector_div = $selector . ' .mec-frontbox-title';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->position($selector . ' .mec-frontbox-title:before', 'Position ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-next-event-details', 'Background Details ' . $title_control, 'Details');
                $advanced_heading_styles->padding_margin($selector . ' .mec-next-event-details', 'Padding/Margin Details ' . $title_control, 'Details');
                $advanced_heading_styles->border($selector . ' .mec-next-event-details', 'Border Details ' . $title_control, 'Details');
                $advanced_heading_styles->shadow($selector . ' .mec-next-event-details', 'Shadow Box/Text Details ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-next-event-details a', 'Text Button ' . $title_control, 'Button');
                $advanced_heading_styles->background($selector . ' .mec-next-event-details a', 'Background Button ' . $title_control, 'Button');
                $advanced_heading_styles->padding_margin($selector . ' .mec-next-event-details a', 'Padding/Margin Button ' . $title_control, 'Button');
                $advanced_heading_styles->border($selector . ' .mec-next-event-details a', 'Border Button ' . $title_control, 'Button');
                $advanced_heading_styles->text($selector . ' .mec-next-occurrence h6', 'Text Date & Time Title ' . $title_control, 'DateTimeTitle');
                $advanced_heading_styles->padding_margin($selector . ' .mec-next-occurrence h6', 'Padding/Margin Date & Time Title  ' . $title_control, 'DateTimeTitle');
                $advanced_heading_styles->padding_margin($selector . ' .mec-next-occurrence ul', 'Padding/Margin Date & Time Box ' . $title_control, 'DateTimeBox');
                $advanced_heading_styles->text($selector . ' .mec-next-occurrence i:before', 'Text Date & Time Icon ' . $title_control, 'DateTimeIcon');
                $advanced_heading_styles->text($selector . ' .mec-next-occurrence dd abbr', 'Text Date & Time Label ' . $title_control, 'DateTimeLabel');
                $advanced_heading_styles->padding_margin($selector . ' .mec-next-occurrence ul', 'Padding/Margin Date & Time Label ' . $title_control, 'DateTimeLabel');
                break;
            case 'hourly_schedule':
                $advanced_heading_selector_div = $selector . ' .mec-frontbox-title';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->border($selector . ' .mec-frontbox-title:before', 'Border Title Shape ' . $title_control, 'TitleShape');
                $advanced_heading_styles->position($selector . ' .mec-frontbox-title:before', 'Position Title Shape ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-frontbox', 'Background Box ' . $title_control, 'Box');
                $advanced_heading_styles->padding_margin($selector . ' .mec-frontbox', 'Padding/Margin Box ' . $title_control, 'Box');
                $advanced_heading_styles->border($selector . ' .mec-frontbox', 'Border Box ' . $title_control, 'Box');
                $advanced_heading_styles->shadow($selector . ' .mec-frontbox', 'Shadow Box/Text Box ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-schedule-part', 'Text Part' . $title_control, 'Part');
                $advanced_heading_styles->padding_margin($selector . ' .mec-schedule-part', 'Padding/Margin Part ' . $title_control, 'Part');
                $advanced_heading_styles->text($selector . ' .mec-schedule-start-time, ' . $selector . ' .mec-schedule-end-time', 'Text Time' . $title_control, 'Time');
                $advanced_heading_styles->padding_margin($selector . ' .mec-schedule-start-time, ' . $selector . ' .mec-schedule-end-time', 'Padding/Margin Time ' . $title_control, 'Time');
                $advanced_heading_styles->text($selector . ' .mec-schedule-title', 'Text Schedule Title ' . $title_control, 'ScheduleTitle');
                $advanced_heading_styles->padding_margin($selector . ' .mec-schedule-title', 'Padding/Margin Schedule Title ' . $title_control, 'ScheduleTitle');
                $advanced_heading_styles->text($selector . ' .mec-schedule-description', 'Text Schedule Description ' . $title_control, 'ScheduleDescription');
                $advanced_heading_styles->padding_margin($selector . ' .mec-schedule-description', 'Padding/Margin Schedule Description ' . $title_control, 'ScheduleDescription');
                $advanced_heading_styles->border($selector . ' .mec-event-schedule-content, ' . $selector . ' .mec-event-schedule-content dl:before', 'Border Schedule Content ' . $title_control, 'ScheduleContent');
                break;
            case 'attendees':
                $advanced_heading_selector_div = $selector . ' .mec-frontbox-title';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->border($selector . ' .mec-frontbox-title:before', 'Border Title Shape ' . $title_control, 'TitleShape');
                $advanced_heading_styles->position($selector . ' .mec-frontbox-title:before', 'Position Title Shape ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-attendees-list-details', 'Background Details ' . $title_control, 'Details');
                $advanced_heading_styles->padding_margin($selector . ' .mec-attendees-list-details', 'Padding/Margin Details ' . $title_control, 'Details');
                $advanced_heading_styles->border($selector . ' .mec-attendees-list-details', 'Border Details ' . $title_control, 'Details');
                $advanced_heading_styles->shadow($selector . ' .mec-attendees-list-details', 'Shadow Box/Text Details ' . $title_control, 'Details');
                $advanced_heading_styles->text($selector . ' .mec-attendees-list-details .mec-attendee-profile-link a', 'Text Link ' . $title_control, 'Link');
                $advanced_heading_styles->padding_margin($selector . ' .mec-attendees-list-details .mec-attendee-profile-link a', 'Padding/Margin Link ' . $title_control, 'Link');
                $advanced_heading_styles->text($selector . ' .mec-attendees-list-details .mec-attendee-profile-link span', 'Text Link Title ' . $title_control, 'LinkTitle');
                $advanced_heading_styles->padding_margin($selector . ' .mec-attendees-list-details .mec-attendee-profile-link span', 'Padding/Margin Link Title ' . $title_control, 'LinkTitle');
                $advanced_heading_styles->size($selector . ' .mec-attendees-list-details .mec-attendee-avatar img', 'Size Avatar ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-attendees-list-details .mec-attendee-avatar img', 'Padding/Margin Avatar ' . $title_control, 'Avatar');
                $advanced_heading_styles->background($selector . ' .mec-attendees-list-details .mec-attendee-avatar img', 'Background Avatar ' . $title_control, 'Avatar');
                $advanced_heading_styles->border($selector . ' .mec-attendees-list-details .mec-attendee-avatar img', 'Border Avatar ' . $title_control, 'Avatar');
                $advanced_heading_styles->shadow($selector . ' .mec-attendees-list-details .mec-attendee-avatar img', 'Shadow Box/Text Avatar ' . $title_control, 'Avatar');
                break;
            case 'booking':
                $advanced_heading_selector_div = $selector . ' .mec-event-cost';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display('.mec-events-meta-group-booking .mec-booking h4, ' . $selector . ' .mec-events-meta-group-booking form>h4', 'Display ' . $title_control, '-');
                $advanced_heading_styles->text('.mec-events-meta-group-booking .mec-booking h4, ' . $selector . ' .mec-events-meta-group-booking form>h4', 'Text ' . $title_control, '-');
                $advanced_heading_styles->border('.mec-events-meta-group-booking .mec-booking h4, ' . $selector . ' .mec-events-meta-group-booking form>h4', 'Border ' . $title_control, '-');
                $advanced_heading_styles->border('.mec-events-meta-group-booking .mec-booking h4:before, ' . $selector . ' .mec-events-meta-group-booking form>h4:before', 'Border Title Shape ' . $title_control, 'TitleShape');
                $advanced_heading_styles->position('.mec-events-meta-group-booking .mec-booking h4:before, ' . $selector . ' .mec-events-meta-group-booking form>h4:before', 'Position Title Shape ' . $title_control, 'TitleShape');
                $advanced_heading_styles->padding_margin('.mec-events-meta-group-booking .mec-booking h4, ' . $selector . ' .mec-events-meta-group-booking form>h4', 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->background('.mec-events-meta-group-booking .mec-booking h4, ' . $selector . ' .mec-events-meta-group-booking form>h4', 'Background ' . $title_control, '-');
                $advanced_heading_styles->background('.lity-content .mec-events-meta-group-booking, ' . $selector . ' mec-events-meta-group-booking', 'Background Box ' . $title_control, 'Box');
                $advanced_heading_styles->padding_margin('.lity-content .mec-events-meta-group-booking, ' . $selector . ' mec-events-meta-group-booking', 'Padding/Margin Box ' . $title_control, 'Box');
                $advanced_heading_styles->border('.lity-content .mec-events-meta-group-booking, ' . $selector . ' mec-events-meta-group-booking', 'Border Box ' . $title_control, 'Box');
                $advanced_heading_styles->shadow('.lity-content .mec-events-meta-group-booking, ' . $selector . ' mec-events-meta-group-booking', 'Shadow Box/Text Box ' . $title_control, 'Box');
                $advanced_heading_styles->size('.mec-single-event .lity-content .mec-events-meta-group-booking input[type=date],
					 .mec-single-event .lity-content .mec-events-meta-group-booking input[type=email],
					 .mec-single-event .lity-content .mec-events-meta-group-booking input[type=number],
					 .mec-single-event .lity-content .mec-events-meta-group-booking input[type=password],
					 .mec-single-event .lity-content .mec-events-meta-group-booking input[type=tel],
					 .mec-single-event .lity-content .mec-events-meta-group-booking input[type=text],
					 .mec-single-event .lity-content .mec-events-meta-group-booking select,
					 .mec-single-event .lity-content .mec-events-meta-group-booking textarea,
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking input[type=date],
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking input[type=email],
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking input[type=number],
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking input[type=password],
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking input[type=tel],
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking input[type=text],
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking select,
					 .mec-single-event ' . $selector . ' .mec-events-meta-group-booking textarea', 'Size Fields ' . $title_control, 'Fields');
                $advanced_heading_styles->text('.lity-content .mec-book-first label,
								.lity-content .mec-event-ticket-description,
								.lity-content .mec-book-ticket-variation span,
								.lity-content .mec-events-meta-group-booking label,
								' . $selector . ' .mec-book-first label,
								' . $selector . ' .mec-event-ticket-description,
								' . $selector . ' .mec-book-ticket-variation span,
								' . $selector . ' .mec-events-meta-group-booking label', 'Text Label ' . $title_control, 'Label');
                $advanced_heading_styles->text('.lity-content .mec-event-ticket-name,
								' . $selector . ' .mec-event-ticket-name', 'Text Ticket Name ' . $title_control, 'TicketName');
                $advanced_heading_styles->text('.lity-content .mec-event-ticket-price,
								' . $selector . ' .mec-event-ticket-price', 'Text Ticket Price ' . $title_control, 'TicketPrice');
                $advanced_heading_styles->text('.lity-content .mec-event-ticket-available,
								' . $selector . ' .mec-event-ticket-available', 'Text Ticket Available ' . $title_control, 'TicketAvailable');
                $advanced_heading_styles->text('.lity-content .mec-event-ticket-available span,
								' . $selector . ' .mec-event-ticket-available span', 'Text Ticket Available Number ' . $title_control, 'TicketAvailableNumber');
                $advanced_heading_styles->text('.lity-conent .info-msg,
				 				' . $selector . ' .info-msg', 'Text Message ' . $title_control, 'Message');
                $advanced_heading_styles->background('.lity-conent .info-msg,
				 				' . $selector . ' .info-msg', 'Background Message ' . $title_control, 'Message');
                $advanced_heading_styles->padding_margin('.lity-content input[type="text"],
					.lity-content input[type="date"],
					.lity-content input[type="number"],
					.lity-content input[type="email"],
					.lity-content input[type="password"],
					.lity-content input[type="tel"],
					.lity-content textarea,
					.lity-content select,
					' . $selector . ' .mec-events-meta-group-booking input[type="text"],
					' . $selector . ' .mec-events-meta-group-booking input[type="date"],
					' . $selector . ' .mec-events-meta-group-booking input[type="number"],
					' . $selector . ' .mec-events-meta-group-booking input[type="email"],
					' . $selector . ' .mec-events-meta-group-booking input[type="password"],
					' . $selector . ' .mec-events-meta-group-booking input[type="tel"],
					' . $selector . ' .mec-events-meta-group-booking textarea,
					' . $selector . ' .mec-events-meta-group-booking select', 'Padding/Margin Fields ' . $title_control, 'Fields');
                $advanced_heading_styles->border('.lity-content input[type="text"],
					.lity-content input[type="date"],
					.lity-content input[type="number"],
					.lity-content input[type="email"],
					.lity-content input[type="password"],
					.lity-content input[type="tel"],
					.lity-content textarea,
					.lity-content select,
					' . $selector . ' .mec-events-meta-group-booking input[type="text"],
					' . $selector . ' .mec-events-meta-group-booking input[type="date"],
					' . $selector . ' .mec-events-meta-group-booking input[type="number"],
					' . $selector . ' .mec-events-meta-group-booking input[type="email"],
					' . $selector . ' .mec-events-meta-group-booking input[type="password"],
					' . $selector . ' .mec-events-meta-group-booking input[type="tel"],
					' . $selector . ' .mec-events-meta-group-booking textarea,
					' . $selector . ' .mec-events-meta-group-booking select', 'Border Fields ' . $title_control, 'Fields');
                $advanced_heading_styles->shadow('.lity-content input[type="text"],
					.lity-content input[type="date"],
					.lity-content input[type="number"],
					.lity-content input[type="email"],
					.lity-content input[type="password"],
					.lity-content input[type="tel"],
					.lity-content textarea,
					.lity-content select,
					' . $selector . ' .mec-events-meta-group-booking input[type="text"],
					' . $selector . ' .mec-events-meta-group-booking input[type="date"],
					' . $selector . ' .mec-events-meta-group-booking input[type="number"],
					' . $selector . ' .mec-events-meta-group-booking input[type="email"],
					' . $selector . ' .mec-events-meta-group-booking input[type="password"],
					' . $selector . ' .mec-events-meta-group-booking input[type="tel"],
					' . $selector . ' .mec-events-meta-group-booking textarea,
					' . $selector . ' .mec-events-meta-group-booking select', 'Shadow Box/Text Fields ' . $title_control, 'Fields');
                $advanced_heading_styles->text('.lity-content .mec-events-meta-group-booking button, ' . $selector . ' .mec-events-meta-group-booking button', 'Text Button ' . $title_control, 'Button');
                $advanced_heading_styles->padding_margin('.lity-content .mec-events-meta-group-booking button, ' . $selector . ' .mec-events-meta-group-booking button', 'Padding/Margin Button ' . $title_control, 'Button');
                $advanced_heading_styles->size('.lity-content .mec-events-meta-group-booking button, ' . $selector . ' .mec-events-meta-group-booking button', 'Size Button ' . $title_control, 'Button');
                $advanced_heading_styles->background('.lity-content .mec-events-meta-group-booking button, ' . $selector . ' .mec-events-meta-group-booking button', 'Background Button ' . $title_control, 'Button');
                $advanced_heading_styles->shadow('.lity-content .mec-events-meta-group-booking button, ' . $selector . ' .mec-events-meta-group-booking button', 'Shadow Button ' . $title_control, 'Button');
                $advanced_heading_styles->border('.lity-content .mec-events-meta-group-booking button, ' . $selector . ' .mec-events-meta-group-booking button', 'Border Button ' . $title_control, 'Button');
                $advanced_heading_styles->border('.lity-content .mec-events-meta-group-booking .mec-booking button[type=submit], ' . $selector . ' .mec-events-meta-group-booking .mec-booking button[type=submit]', 'Border Button Submit ' . $title_control, 'ButtonSubmit');
                $advanced_heading_styles->text('.lity-content .mec-book-form-back-button, ' . $selector . ' .mec-events-meta-group-booking .mec-book-form-back-button', 'Text Button Back ' . $title_control, 'ButtonBack');
                $advanced_heading_styles->padding_margin('.lity-content .mec-book-form-back-button, ' . $selector . ' .mec-events-meta-group-booking .mec-book-form-back-button', 'Padding/Margin Button Back ' . $title_control, 'ButtonBack');
                $advanced_heading_styles->size('.lity-content .mec-book-form-back-button, ' . $selector . ' .mec-events-meta-group-booking .mec-book-form-back-button', 'Size Button Back ' . $title_control, 'ButtonBack');
                $advanced_heading_styles->shadow('.lity-content .mec-book-form-back-button, ' . $selector . ' .mec-events-meta-group-booking .mec-book-form-back-button', 'Background Button Back ' . $title_control, 'ButtonBack');
                $advanced_heading_styles->border('.lity-content .mec-book-form-back-button, ' . $selector . ' .mec-events-meta-group-booking .mec-booking  .mec-book-form-btn-wrap .mec-book-form-back-button', 'Border Button Back ' . $title_control, 'ButtonBack');
                $advanced_heading_styles->text('.mec-events-meta-group-booking ul.mec-book-price-details .mec-book-price-detail-description', 'Text Price Description ' . $title_control, 'PriceDescription');
                $advanced_heading_styles->text('.mec-events-meta-group-booking ul.mec-book-price-details li span.mec-book-price-detail-amount', 'Text Price Amount ' . $title_control, 'PriceAmount');
                $advanced_heading_styles->text('.mec-single-event .mec-events-meta-group-booking .mec-book-price-total', 'Text Price Total ' . $title_control, 'PriceTotal');
                $advanced_heading_styles->text('.mec-wrap .mec-wrap-checkout .mec-book-form-gateways .mec-book-form-gateway-label label', 'Text Gateway Label ' . $title_control, 'GatewayLabel');
                $advanced_heading_styles->text('.lity-content .mec-events-meta-group .mec-error, ' . $selector . ' .mec-events-meta-group .mec-error', 'Text Messages Error ' . $title_control, 'MessagesError');
                $advanced_heading_styles->background('.lity-content .mec-events-meta-group .mec-error, ' . $selector . ' .mec-events-meta-group .mec-error', 'background Messages Error ' . $title_control, 'MessagesError');
                $advanced_heading_styles->padding_margin('.lity-content .mec-events-meta-group .mec-error, ' . $selector . ' .mec-events-meta-group .mec-error', 'Padding/Margin Messages Error ' . $title_control, 'MessagesError');
                $advanced_heading_styles->shadow('.lity-content .mec-events-meta-group .mec-error, ' . $selector . ' .mec-events-meta-group .mec-error', 'Shadow Messages Error ' . $title_control, 'MessagesError');
                $advanced_heading_styles->border('.lity-content .mec-events-meta-group .mec-error, ' . $selector . ' .mec-events-meta-group .mec-error', 'Border Messages Error ' . $title_control, 'MessagesError');
                $advanced_heading_styles->text('.lity-content .mec-events-meta-group .mec-success, ' . $selector . ' .mec-events-meta-group .mec-success', 'Text Messages Success ' . $title_control, 'MessagesSuccess');
                $advanced_heading_styles->background('.lity-content .mec-events-meta-group .mec-success, ' . $selector . ' .mec-events-meta-group .mec-success', 'background Messages Success ' . $title_control, 'MessagesSuccess');
                $advanced_heading_styles->padding_margin('.lity-content .mec-events-meta-group .mec-success, ' . $selector . ' .mec-events-meta-group .mec-success', 'Padding/Margin Messages Success ' . $title_control, 'MessagesSuccess');
                $advanced_heading_styles->shadow('.lity-content .mec-events-meta-group .mec-success, ' . $selector . ' .mec-events-meta-group .mec-success', 'Shadow Messages Success ' . $title_control, 'MessagesSuccess');
                $advanced_heading_styles->border('.lity-content .mec-events-meta-group .mec-success, ' . $selector . ' .mec-events-meta-group .mec-success', 'Border Messages Success ' . $title_control, 'MessagesSuccess');
                $advanced_heading_styles->text('.lity-content .mec-events-meta-group .info-msg, ' . $selector . ' .mec-events-meta-group .info-msg', 'Text Messages Info ' . $title_control, 'MessagesInfo');
                $advanced_heading_styles->background('.lity-content .mec-events-meta-group .info-msg, ' . $selector . ' .mec-events-meta-group .info-msg', 'background Messages Info ' . $title_control, 'MessagesInfo');
                $advanced_heading_styles->padding_margin('.lity-content .mec-events-meta-group .info-msg, ' . $selector . ' .mec-events-meta-group .info-msg', 'Padding/Margin Messages Info ' . $title_control, 'MessagesInfo');
                $advanced_heading_styles->shadow('.lity-content .mec-events-meta-group .info-msg, ' . $selector . ' .mec-events-meta-group .info-msg', 'Shadow Messages Info ' . $title_control, 'MessagesInfo');
                $advanced_heading_styles->border('.lity-content .mec-events-meta-group .info-msg, ' . $selector . ' .mec-events-meta-group .info-msg', 'Border Messages Info ' . $title_control, 'MessagesInfo');
                break;
            case 'breadcrumbs':
                $advanced_heading_selector_div = $selector . ' .mec-breadcrumbs';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-breadcrumbs .mec-address a', 'Text Link ' . $title_control, 'Link');
                $advanced_heading_styles->padding_margin($selector . ' .mec-breadcrumbs .mec-address a', 'Padding/Margin Link ' . $title_control, 'Link');
                $advanced_heading_styles->text($selector . ' .mec-breadcrumbs .mec-current', 'Text Current ' . $title_control, 'Current');
                $advanced_heading_styles->padding_margin($selector . ' .mec-breadcrumbs .mec-current', 'Padding/Margin Current ' . $title_control, 'Current');
                $advanced_heading_styles->text($selector . ' .mec-breadcrumbs .mec-address i:before', 'Text Arrow ' . $title_control, 'Arrow');
                break;
            case 'cancellation':
                $advanced_heading_selector_div = $selector . ' .mec-event-cost';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($selector . '.mec-cancellation-reason span', 'Background ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-cancellation-reason', 'Text ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . '.mec-cancellation-reason span', 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($selector . '.mec-cancellation-reason span', 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($selector . '.mec-cancellation-reason span', 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-cancellation-reason span', 'Text Typography ' . $title_control, 'Typography');
                break;
            case 'data':
                $advanced_heading_selector_div = $selector . ' .mec-event-data-fields.mec-frontbox';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-event-data-fields .mec-event-data-field-item .mec-event-data-field-name', 'Text Name ' . $title_control, 'Name');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-data-fields .mec-event-data-field-item .mec-event-data-field-name', 'Padding/Margin Name ' . $title_control, 'Name');
                $advanced_heading_styles->text($selector . ' .mec-event-data-fields .mec-event-data-field-item .mec-event-data-field-value', 'Text Value  ' . $title_control, 'Value');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-data-fields .mec-event-data-field-item .mec-event-data-field-value', 'Padding/Margin Value ' . $title_control, 'Value');
                $advanced_heading_styles->text($selector . ' .mec-event-data-fields .mec-event-data-field-item .mec-event-data-field-value a', 'Text Link ' . $title_control, 'Link');
                $advanced_heading_styles->size($selector . ' .mec-event-data-fields .mec-event-data-field-item', 'Size Item ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-event-data-fields .mec-event-data-field-item', 'Background Item ' . $title_control, 'Item');
                $advanced_heading_styles->padding_margin($selector . ' .mec-event-data-fields .mec-event-data-field-item', 'Padding/Margin Item ' . $title_control, 'Item');
                $advanced_heading_styles->border($selector . ' .mec-event-data-fields .mec-event-data-field-item', 'Border Item ' . $title_control, 'Item');
                $advanced_heading_styles->shadow($selector . ' .mec-event-data-fields .mec-event-data-field-item', 'Shadow Item ' . $title_control, 'Item');
                break;
            case 'map':
                $advanced_heading_selector_div = $selector . ' .mec-events-meta-group';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-map-get-direction-btn-cnt input[type="submit"]', 'Text Button ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-map-get-direction-btn-cnt input[type="submit"]', 'Padding/Margin Button ' . $title_control, 'Button');
                $advanced_heading_styles->size($selector . ' .mec-map-get-direction-btn-cnt input[type="submit"]', 'Size Button ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-map-get-direction-btn-cnt input[type="submit"]', 'Background Button ' . $title_control, 'Button');
                $advanced_heading_styles->border($selector . ' .mec-map-get-direction-btn-cnt input[type="submit"]', 'Border Button ' . $title_control, 'Button');
                $advanced_heading_styles->shadow($selector . ' .mec-map-get-direction-btn-cnt input[type="submit"]', 'Shadow Button ' . $title_control, 'Button');
                break;
            case 'next_Previous':
                $advanced_heading_selector_div = $selector . ' .mec-next-previous-events';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-next-event a, ' . $selector . ' .mec-previous-event a', 'Text Button ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-next-event a, ' . $selector . ' .mec-previous-event a', 'Padding/Margin Button ' . $title_control, 'Button');
                $advanced_heading_styles->background($selector . ' .mec-next-event a, ' . $selector . ' .mec-previous-event a', 'Background Button ' . $title_control, 'Button');
                $advanced_heading_styles->border($selector . ' .mec-next-event a, ' . $selector . ' .mec-previous-event a', 'Border Button ' . $title_control, 'Button');
                $advanced_heading_styles->display($selector . ' .mec-next-previous-events ul li', 'Display List ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-next-previous-events ul li', 'Padding/Margin List ' . $title_control, 'List');
                $advanced_heading_styles->text($selector . ' .mec-next-previous-events ul li', 'Text List ' . $title_control, 'List');
                break;
            case 'public_download':
                $advanced_heading_selector_div = $selector . ' .mec-public-download-details';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->size($advanced_heading_selector_div, 'Size ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-public-download-details p', 'Text Button ' . $title_control, 'Button');
                $advanced_heading_styles->padding_margin($selector . ' .mec-public-download-details p', 'Padding/Margin Button ' . $title_control, 'Button');
                $advanced_heading_styles->size($selector . ' .mec-public-download-details p', 'Size Button ' . $title_control, 'Button');
                $advanced_heading_styles->background($selector . ' .mec-public-download-details p', 'Background Button ' . $title_control, 'Button');
                $advanced_heading_styles->border($selector . ' .mec-public-download-details p', 'Border Button ' . $title_control, 'Button');
                $advanced_heading_styles->shadow($selector . ' .mec-public-download-details p', 'Shadow Button ' . $title_control, 'Button');
                $advanced_heading_styles->text($selector . ' .mec-public-download-details .button', 'Text Button Title ' . $title_control, 'ButtonTitle');
                $advanced_heading_styles->padding_margin($selector . ' .mec-public-download-details .button', 'Padding/Margin Button Title ' . $title_control, 'ButtonTitle');
                $advanced_heading_styles->size($selector . ' .mec-public-download-details .button', 'Size Button Title ' . $title_control, 'ButtonTitle');
                $advanced_heading_styles->background($selector . ' .mec-public-download-details .button', 'Background Button Title ' . $title_control, 'ButtonTitle');
                $advanced_heading_styles->border($selector . ' .mec-public-download-details .button', 'Border Button Title ' . $title_control, 'ButtonTitle');
                $advanced_heading_styles->shadow($selector . ' .mec-public-download-details .button', 'Shadow Button Title ' . $title_control, 'ButtonTitle');
                break;
            case 'register_button':
                $advanced_heading_selector_div = $selector . ' .mec-reg-btn.mec-frontbox';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->text($selector . ' .mec-reg-btn.mec-frontbox .mec-booking-button', 'Text Button ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($selector . ' .mec-reg-btn.mec-frontbox .mec-booking-button', 'Padding/Margin Button ' . $title_control, 'Button');
                $advanced_heading_styles->size($selector . ' .mec-reg-btn.mec-frontbox .mec-booking-button', 'Size Button ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-reg-btn.mec-frontbox .mec-booking-button', 'Background Button ' . $title_control, 'Button');
                $advanced_heading_styles->border($selector . ' .mec-reg-btn.mec-frontbox .mec-booking-button', 'Border Button ' . $title_control, 'Button');
                $advanced_heading_styles->shadow($selector . ' .mec-reg-btn.mec-frontbox .mec-booking-button', 'Shadow Button ' . $title_control, 'Button');
                break;
            case 'related':
                $advanced_heading_selector_div = $selector . ' .mec-related-events-wrap .mec-rec-events-title';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div . ':before', 'Background Title Shape ' . $title_control, 'TitleShape');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->position($advanced_heading_selector_div . ':before', 'Position Title Shape ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-related-events-wrap article', 'Background Item ' . $title_control, 'Item');
                $advanced_heading_styles->padding_margin($selector . ' .mec-related-events-wrap .mec-related-event-post', 'Padding/Margin Wrapper Post ' . $title_control, 'WrapperPost');
                $advanced_heading_styles->background($selector . ' .mec-related-events-wrap', 'Background Wrapper ' . $title_control, 'Wrapper');
                $advanced_heading_styles->padding_margin($selector . ' .mec-related-events-wrap', 'Padding/Margin Wrapper ' . $title_control, 'Wrapper');
                $advanced_heading_styles->border($selector . ' .mec-related-events-wrap', 'Border Wrapper ' . $title_control, 'Wrapper');
                $advanced_heading_styles->shadow($selector . ' .mec-related-events-wrap', 'Shadow Content ' . $title_control, 'Content');
                $advanced_heading_styles->background($selector . ' .mec-related-events-wrap .mec-related-event-post .mec-related-event-content', 'Background Content ' . $title_control, 'Content');
                $advanced_heading_styles->padding_margin($selector . ' .mec-related-events-wrap .mec-related-event-post .mec-related-event-content', 'Padding/Margin Content ' . $title_control, 'Content');
                $advanced_heading_styles->border($selector . ' .mec-related-events-wrap .mec-related-event-post .mec-related-event-content', 'Border Content ' . $title_control, 'Content');
                $advanced_heading_styles->shadow($selector . ' .mec-related-events-wrap .mec-related-event-post .mec-related-event-content', 'Shadow Content ' . $title_control, 'Content');
                $advanced_heading_styles->border($selector . ' .mec-related-events-wrap .mec-related-event-post img', 'Border Content Image' . $title_control, 'ContentImage');
                $advanced_heading_styles->shadow($selector . ' .mec-related-events-wrap .mec-related-event-post img', 'Shadow Content Image ' . $title_control, 'ContentImage');
                $advanced_heading_styles->text($selector . ' .mec-related-events-wrap .mec-related-event-post .mec-related-event-content span', 'Text Date ' . $title_control, 'Date');
                $advanced_heading_styles->text($selector . ' .mec-related-events-wrap .mec-related-event-post .mec-related-event-content h5 a', 'Text Date Title ' . $title_control, 'DateTitle');
                break;
            case 'weather':
                $advanced_heading_selector_div = $selector . ' .mec-frontbox-title';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div . ':before', 'Border Title Shape ' . $title_control, 'TitleShape');
                $advanced_heading_styles->position($advanced_heading_selector_div . ':before', 'Position Title Shape ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->background($selector . ' .mec-weather-details', 'Background Details ' . $title_control, 'Details');
                $advanced_heading_styles->padding_margin($selector . ' .mec-weather-details', 'Padding/Margin Details ' . $title_control, 'Details');
                $advanced_heading_styles->border($selector . ' .mec-weather-details', 'Border Details ' . $title_control, 'Details');
                $advanced_heading_styles->shadow($selector . ' .mec-weather-details', 'Shadow Details ' . $title_control, 'Details');
                $advanced_heading_styles->background($selector . ' .mec-weather-head', 'Background Weather ' . $title_control, 'Weather');
                $advanced_heading_styles->padding_margin($selector . ' .mec-weather-head', 'Padding/Margin Weather ' . $title_control, 'Weather');
                $advanced_heading_styles->border($selector . ' .mec-weather-head', 'Border Weather ' . $title_control, 'Weather');
                $advanced_heading_styles->shadow($selector . ' .mec-weather-head', 'Shadow Weather ' . $title_control, 'Weather');
                $advanced_heading_styles->text($selector . ' .mec-weather-summary-report', 'Text Condition ' . $title_control, 'Condition');
                $advanced_heading_styles->text($selector . ' .mec-weather-summary-temp', 'Text Temp ' . $title_control, 'Temp');
                $advanced_heading_styles->text($selector . ' .mec-weather-extras', 'Text More Details ' . $title_control, 'MoreDetails');
                $advanced_heading_styles->text($selector . ' .mec-weather-extras span', 'Text More Details Span ' . $title_control, 'MoreDetailsSpan');
                break;
            case 'export':
                $advanced_heading_selector_div = $selector . ' .mec-frontbox';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow ' . $title_control, '-');
                break;
            case 'faq':
                $advanced_heading_selector_div = $selector . ' .mec-single-faq .mec-event-data-fields';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow ' . $title_control, '-');
                break;
            case 'locations':
                $advanced_heading_selector_div = $selector . ' .mec-single-event-location';
                $advanced_heading_selector_additional = $selector . ' .mec-single-event-additional-locations';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->text($advanced_heading_selector_div.' .mec-location', 'Title Typograph ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div.' .mec-location', 'Title Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div.' i:before', 'Icon Typograph ' . $title_control, 'Icon');
                $advanced_heading_styles->text($advanced_heading_selector_div.' dd, '.$advanced_heading_selector_div.' dd h6', 'Label Typography ' . $title_control, 'Label');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div.' dd, '.$advanced_heading_selector_div.' dd h6', 'Label Padding/Margin ' . $title_control, 'Label');
                $advanced_heading_styles->text($advanced_heading_selector_div.' dd .mec-events-address', 'Label Address ' . $title_control, 'LabelAddress');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div.' dd .mec-events-address', 'Label Address Padding/Margin ' . $title_control, 'LabelAddress');
                $advanced_heading_styles->size($advanced_heading_selector_div . ' .mec-img-location', 'Size Image ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div. ' .mec-img-location', 'Background Image' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div.' .mec-img-location', 'Image Padding/Margin ' . $title_control, 'Image');
                $advanced_heading_styles->border($advanced_heading_selector_div.' .mec-img-location', 'Border Image  ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div . ' .mec-img-location', 'Box Shadow Image ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div.' dd a', 'Link Typography ' . $title_control, 'Link');
                $advanced_heading_styles->text($advanced_heading_selector_div.' .mec-location-description p', 'Description Typography ' . $title_control, 'Description');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background Box' . $title_control, 'Box');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Box Padding/Margin ' . $title_control, 'Box');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border Box ' . $title_control, 'Box');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Box Shadow ' . $title_control, 'Box');
                $advanced_heading_styles->text($advanced_heading_selector_additional.' .mec-single-event-location .mec-location', 'Other Location Typography ' . $title_control, 'OtherLocation');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_additional.' .mec-single-event-location .mec-location', 'Other Location Padding/Margin ' . $title_control, 'OtherLocation');
                $advanced_heading_styles->text($advanced_heading_selector_additional.' .mec-single-event-location i:before', 'Icon Other Location Typography ' . $title_control, 'IconOtherLocation');
                $advanced_heading_styles->text($advanced_heading_selector_additional.' .mec-single-event-location dd', 'Label Other Location Typography ' . $title_control, 'LabelOtherLocation');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_additional.' .mec-single-event-location dd', 'Label Other Location Padding/Margin ' . $title_control, 'LabelOtherLocation');
                $advanced_heading_styles->text($advanced_heading_selector_additional.' .mec-single-event-location dd .mec-events-address', 'Address Other Location Typography ' . $title_control, 'AddressOtherLocation');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_additional.' .mec-single-event-location dd .mec-events-address', 'Address Other Location Padding/Margin ' . $title_control, 'AddressOtherLocation');
                $advanced_heading_styles->size($advanced_heading_selector_additional . ' .mec-single-event-location .mec-img-location', 'Size Image Other Location ' . $title_control, 'ImageOtherLocation');
                $advanced_heading_styles->background($advanced_heading_selector_additional. ' .mec-single-event-location .mec-img-location', 'Background Image Other Location ' . $title_control, 'ImageOtherLocation');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_additional.' .mec-single-event-location .mec-img-location', 'Image Other Location Padding/Margin ' . $title_control, 'ImageOtherLocation');
                $advanced_heading_styles->border($advanced_heading_selector_additional.' .mec-single-event-location .mec-img-location', 'Border Image Other Location ' . $title_control, 'ImageOtherLocation');
                $advanced_heading_styles->shadow($advanced_heading_selector_additional.' .mec-single-event-location .mec-img-location', 'Box Shadow Image Other Location ' . $title_control, 'ImageOtherLocation');
                $advanced_heading_styles->text($advanced_heading_selector_additional.' .mec-location-description a', 'Link Other Location Typography ' . $title_control, 'LinkOtherLocation');
                $advanced_heading_styles->text($advanced_heading_selector_additional.' .mec-location-description p', 'Description Other Location Typography ' . $title_control, 'DescriptionOtherLocation');
                $advanced_heading_styles->display($advanced_heading_selector_additional.' .mec-single-event-location', 'Display Box Other Location' . $title_control, 'BoxOtherLocation');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_additional.' .mec-single-event-location', 'Box Other Location Padding/Margin ' . $title_control, 'BoxOtherLocation');
                $advanced_heading_styles->border($advanced_heading_selector_additional.' .mec-single-event-location', 'Border Box Other Location ' . $title_control, 'BoxOtherLocation');
                $advanced_heading_styles->shadow($advanced_heading_selector_additional.' .mec-single-event-location', 'Box Shadow Box Other Location ' . $title_control, 'BoxOtherLocation');
                $advanced_heading_styles->text($advanced_heading_selector_additional.' dd', 'Labels Wrapper Other Location Typography ' . $title_control, 'LabelsWrapperOtherLocation');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_additional, 'Box Additional Other Location Padding/Margin ' . $title_control, 'AdditionalBoxOtherLocation');
                $advanced_heading_styles->border($advanced_heading_selector_additional, 'Border Box Additional Other Location ' . $title_control, 'AdditionalBoxOtherLocation');
                $advanced_heading_styles->shadow($advanced_heading_selector_additional, 'Box Shadow Box Additional Other Location ' . $title_control, 'AdditionalBoxOtherLocation');
                $advanced_heading_styles->background($advanced_heading_selector_additional, 'Background Additional Other Location ' . $title_control, 'AdditionalBoxOtherLocation');
                break;
            case 'sponsors':
                $advanced_heading_selector_div = $selector . ' .mec-events-single-section-title';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow ' . $title_control, '-');
                break;
            case 'trailer_url':
                $advanced_heading_selector_div = $selector . ' .mec-single-trailer-url a';
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow ' . $title_control, '-');
                break;
            case 'rsvp':
                $advanced_heading_selector_div = $selector;
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->display($advanced_heading_selector_div, 'Display ' . $title_control, '-');
                $advanced_heading_styles->text($advanced_heading_selector_div, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector_div, 'Background ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector_div, 'Border ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector_div, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector_div, 'Shadow ' . $title_control, '-');
                break;
            default:
                $advanced_heading_selector = $selector;
                $advanced_heading_styles = new StyleManagerControls($block_name);
                $advanced_heading_styles->text($advanced_heading_selector, 'Text ' . $title_control, '-');
                $advanced_heading_styles->background($advanced_heading_selector, 'Background ' . $title_control, '-');
                $advanced_heading_styles->display($advanced_heading_selector, 'Display ' . $title_control, '-');
                $advanced_heading_styles->size($advanced_heading_selector, 'Size ' . $title_control, '-');
                $advanced_heading_styles->padding_margin($advanced_heading_selector, 'Padding/Margin ' . $title_control, '-');
                $advanced_heading_styles->border($advanced_heading_selector, 'Border ' . $title_control, '-');
                $advanced_heading_styles->shadow($advanced_heading_selector, 'Shadow Box/Text ' . $title_control, '-');
                $advanced_heading_styles->position($advanced_heading_selector, 'Position ' . $title_control, '-');
                break;
        }
    }

    /**
     * Add GSB Settings into Single Event Page Settings Section
     *
     * @since     1.0.0
     */
    public function add_gsb_settings($mec)
    {

        $mainClass = new \MEC_main();
        $set = $mainClass->get_settings();

        $settings = $mec->settings;
        $builders = get_posts([
            'post_type' => 'mec_gsb',
            'posts_per_page' => -1
        ]);

        if (isset($set['single_single_style']) && $set['single_single_style'] == 'gsb-builder') {
            ?>
            <script>
                jQuery('#mec_settings_single_event_single_style').append('<option selected value="gsb-builder">Gutenberg Single Builder</option>');
            </script>
        <?php } else { ?>
            <script>
                jQuery('#mec_settings_single_event_single_style').append('<option value="gsb-builder">Gutenberg Single Builder</option>');
            </script>
        <?php } ?>

        <div class="mec-form-row" id="mec_settings_single_event_single_default_gutenberg_builder_wrap"
             style="display:none;">
            <?php
            if (!$builders) {
                echo __('Please Create New Design for Gutenberg Single Event Page', 'mec-gsb');
                echo ' <a href="' . admin_url('post-new.php?post_type=mec_gsb') . '" class="taxonomy-add-new">' . __('Create new', 'mec-gsb') . '</a>';
            }
            ?>
            <label class="mec-col-3"
                   for="mec_settings_single_event_single_default_gutenberg_builder"><?php _e('Default Gutenberg Builder for Single Event', 'mec-gsb'); ?></label>
            <div class="mec-col-9">
                <select id="mec_settings_single_event_single_default_gutenberg_builder"
                        name="mec[settings][single_single_default_gutenberg_builder]">
                    <?php foreach ($builders as $builder) : ?>
                        <option value="<?php echo $builder->ID ?>" <?php echo (isset($settings['single_single_default_gutenberg_builder']) and $settings['single_single_default_gutenberg_builder'] == $builder->ID) ? 'selected="selected"' : ''; ?>><?php echo esc_html($builder->post_title) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="mec-form-row" id="mec_settings_custom_event_for_gutenberg_builder_wrap" style="display:none;">
            <label class="mec-col-3"
                   for="mec_settings_custom_event_for_gutenberg_builder"><?php _e('Custom Event For Editor Gutenberg Builder', 'mec-gsb'); ?></label>
            <div class="mec-col-9">
                <select id="mec_settings_custom_event_for_gutenberg_builder"
                        name="mec[settings][custom_event_for_gutenberg_builder]">
                    <?php
                    $events = \MEC\Events\EventsQuery::getInstance()->get_events([
                        'posts_per_page' => -1,
                    ]);
                    $v_selected = (int)\MEC\Settings\Settings::getInstance()->get_settings('custom_event_for_gutenberg_builder');
                    foreach ($events as $event) {

                        $event_id = $event->ID;
                        $event_title = $event->post_title;
                        $selected = $event_id == $v_selected ? 'selected="selected"' : '';
                        echo '<option value="' . $event_id . '" ' . $selected . '>' . $event_title . '</option>';
                    }
                    ?>
                </select>
                <span class="mec-tooltip">
					<div class="box left">
						<h5 class="title"><?php _e('Default Single Event Template on Gutenberg', 'mec-gsb'); ?></h5>
						<div class="content"><p><?php esc_attr_e("Choose your event for gutenberg single builder addon.", 'mec-gsb'); ?><a
                                        href="#" target="_blank"><?php _e('Read More', 'mec-gsb'); ?></a></p></div>
					</div>
					<i title="" class="dashicons-before dashicons-editor-help"></i>
				</span>
            </div>
        </div>

        <script>
            jQuery(document).ready(function () {
                if (jQuery('#mec_settings_single_event_single_style').val() == 'gsb-builder') {
                    jQuery('#mec_settings_single_event_single_default_gutenberg_builder_wrap').css('display', 'block');
                    jQuery('#mec_settings_custom_event_for_gutenberg_builder_wrap').css('display', 'block');

                }

                jQuery('#mec_settings_single_event_single_style').on('change', function () {
                    if (jQuery(this).val() == 'gsb-builder') {
                        jQuery('#mec_settings_single_event_single_default_gutenberg_builder_wrap').css('display', 'block');
                        jQuery('#mec_settings_custom_event_for_gutenberg_builder_wrap').css('display', 'block');
                    } else {
                        jQuery('#mec_settings_single_event_single_default_gutenberg_builder_wrap').css('display', 'none');
                        jQuery('#mec_settings_custom_event_for_gutenberg_builder_wrap').css('display', 'none');
                    }
                })
            })
        </script>

        <?php
    }


    /**
     * Single Template mec_gsb
     *
     * @since    1.0.0
     */
    public function gsb_single_template($single)
    {
        global $post;

        if ($post->post_type == 'mec_gsb') {
            if (file_exists(MECGSB_PATH . 'core/views/single-mec_gsb.php')) {
                return MECGSB_PATH . 'core/views/single-mec_gsb.php';
            }
        }
        return $single;
    }

    /**
     * Register API Get Blocks GSB in Gutenberg Editor
     *
     * @since    1.0.0
     */
    public function routes_api_gsb()
    {
        register_rest_route('gsb/v1', '/event', array(
            'methods' => 'Post',
            'callback' => [static::instance(), 'getCustomEventGSB'],
            'permission_callback' => '__return_true',
        ));
    }

    /**
     * API Get Blocks GSB in Gutenberg Editor
     *
     * @since    1.0.0
     */
    function getCustomEventGSB($data)
    {
        $custom_event_id = (int)\MEC\Settings\Settings::getInstance()->get_settings('custom_event_for_gutenberg_builder');
        $event_gsb = null;
        if ($custom_event_id != null && $custom_event_id != 0) {
            $event_gsb = (array)get_post($custom_event_id);
        } else {
            $args = array(
                'numberposts' => '1',
                'orderby' => 'post_date',
                'order' => 'DESC',
                'post_type' => 'mec-events',
                'post_status' => 'publish'
            );
            $recent_posts = wp_get_recent_posts($args);
            foreach ($recent_posts as $recent) {
                $event_gsb = $recent;
            }
        }

        $response = '';
        if (isset($data['type'])) {
            switch ($data['type']) {
                case 'title':
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $event_gsb['post_title']);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'image':
                    $image = get_the_post_thumbnail($custom_event_id, 'single-post-thumbnail');
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $image);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'event_gallery':

                    $gallery_html = static::get_event_gallery_html($custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $gallery_html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'content':
                    $html = '';
                    if (empty($event_gsb['post_content']) && $this->is_editor_mode()) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if event content is set. In order for the widget in this page to be displayed correctly, please set content for your last event.', 'mec') . '</span>'
                            . '</p></div>';
                    } else {

                        $html .= '<div class="mec-single-event-description mec-events-content">'
                            . $event_gsb['post_content'] .
                            '</div>';
                    }
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'category':
                    $events_detail = $this->get_event_detail($custom_event_id);
                    $categories = isset($events_detail->data->categories) ? $events_detail->data->categories : array();

                    $html = '';
                    if ($this->is_editor_mode() && empty($categories)) {
                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if category is set. In order for the widget in this page to be displayed correctly, please set category for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/categories/" target="_blank">' . esc_html__('How to set category', 'mec') . ' </a>'
                            . '</p></div>';
                    } elseif (!empty($categories)) {
                        $html .= '<div class="mec-single-event-category mec-event-meta mec-frontbox">';
                        $html .= '<i class="mec-sl-folder"></i>';
                        $html .= '<dt>' . Base::get_main()->m('taxonomy_categories', esc_html__('Category', 'mec')) . '</dt>';
                        foreach ($categories as $category) {
                            $icon = get_metadata('term', $category['id'], 'mec_cat_icon', true);
                            $icon = isset($icon) && $icon != '' ? '<i class="' . esc_attr($icon) . ' mec-color"></i>' : '<i class="mec-fa-angle-right"></i>';
                            $html .= '<dd class="mec-events-event-categories">
						<a href="' . esc_attr(get_term_link($category['id'], 'mec_category')) . '" class="mec-color-hover" rel="tag">' . $icon . esc_html($category['name']) . '</a></dd>';
                        }
                        $html .= '</div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'dateModule':
                    $event_detail = $this->get_event_detail($custom_event_id);
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();

                    $occurrence = isset($_GET['occurrence']) ? sanitize_text_field($_GET['occurrence']) : '';
                    $start_datetime = !trim($occurrence) && isset($event_detail->date['start']) ? $event_detail->date['start'] : array('date' => $occurrence);
                    $occurrence_end_date = trim($occurrence) ? Base::get_main()->get_end_date_by_occurrence($event_detail->data->ID, $start_datetime['date']) : '';
                    $end_datetime = isset($event_detail->date['end']) ? $event_detail->date['end'] : array('date' => $occurrence_end_date);

                    $date_format = isset($settings['single_date_format1']) ? $settings['single_date_format1'] : get_option('date_format');
                    $date_label = Base::get_main()->date_label($start_datetime, $end_datetime, $date_format);
                    $midnight_event = Base::get_main()->is_midnight_event($event_detail);

                    $html = '';
                    $html .= '<div class="mec-event-meta">' .
                        '<div class="mec-single-event-date">' .
                        '<i class="mec-sl-calendar"></i>' .
                        '<h3 class="mec-date">' . esc_html(translate('Date', 'mec')) . '</h3>' .
                        '<dl>';

                    if ($midnight_event) {
                        $html .= '<dd><abbr class="mec-events-abbr">' . Base::get_main()->dateify($event_detail, $date_format) . '</abbr></dd>';
                    } else {
                        $html .= '<dd><abbr class="mec-events-abbr">' . wp_kses($date_label, array('span' => array('class' => array(), 'itemprop' => array()))) . '</abbr></dd>';
                    }
                    $html .= '</dl>';
                    $html .= Base::get_main()->holding_status($event_detail);
                    $html .= '</div></div>';

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'countDown':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-countdown', $custom_event_id, ['edit_mode' => false]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'localTime':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && (!isset($settings['local_time_module_status']) || !$settings['local_time_module_status'])) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if label is set. In order for the widget in this page to be displayed correctly, please set LocalTime module for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/local-time-module/" target="_blank">' . esc_html__('How to set LocalTime module', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {

                        $html .= '<div class="mec-event-meta mec-local-time-details mec-frontbox">'
                            . Base::get_main()->module('local-time.details', array('event' => $event_detail)) .
                            '</div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'tags':
                    $tags = get_the_tags($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && !$tags) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if tags is set. In order for the widget in this page to be displayed correctly, please set tags for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/tags/" target="_blank">' . esc_html__('How to set tags', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {
                        $html .= '<div class="mec-events-meta-group mec-events-meta-group-tags">';
                        $html .= esc_html__('Tags: ', 'mec');
                        if ($tags) {
                            $html .= implode(', ', array_map(function ($tag) {
                                    return '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . ' </a>';
                                }, $tags
                                )
                            );
                        }
                        $html .= '</div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'timeModule':
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '<div class="mec-event-meta">';
                    $html .= '<style>.mec-single-event-time h3{display:inline;}</style>';
                    // Event Time
                    if (isset($event_detail->data->meta['mec_date']['start']) and !empty($event_detail->data->meta['mec_date']['start'])) {
                        if (isset($event_detail->data->meta['mec_hide_time']) and $event_detail->data->meta['mec_hide_time'] == '0') {
                            $time_comment = isset($event_detail->data->meta['mec_comment']) ? $event_detail->data->meta['mec_comment'] : '';
                            $allday = isset($event_detail->data->meta['mec_allday']) ? $event_detail->data->meta['mec_allday'] : 0;
                            $html .= '<div class="mec-single-event-time">';
                            $html .= '<i class="mec-sl-clock"></i>';
                            $html .= '<h3 class="mec-time">' . esc_html(translate('Time', 'mec')) . '</h3>';
                            $html .= '<i class="mec-time-comment">' . (isset($time_comment) ? esc_html(translate($time_comment)) : '') . '</i>';
                            $html .= '<dl>';
                            if ($allday == '0' and isset($event_detail->data->time) and trim($event_detail->data->time['start'])) {
                                $html .= '<dd><abbr class="mec-events-abbr">' . esc_html(translate($event_detail->data->time['start'])) . (trim($event_detail->data->time['end']) ? esc_html(translate(' - ' . $event_detail->data->time['end'])) : '') . '</abbr></dd>';
                            } else {
                                $html .= '<dd><abbr class="mec-events-abbr">' . esc_html(\MEC\Base::get_main()->m('all_day', esc_html__('All Day', 'mec'))) . '</abbr></dd>';
                            }
                            $html .= '</dl></div>';
                        }
                    }
                    $html .= '</div>';

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'cost':
                    $events_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && !(isset($events_detail->data->meta['mec_cost']) && $events_detail->data->meta['mec_cost'] != '')) {
                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if cost is set. In order for the widget in this page to be displayed correctly, please set cost for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/add-event/" target="_blank">' . esc_html__('How to set cost', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {

                        if ($events_detail->data->meta['mec_cost'] != '') {
                            $html .= '<div class="mec-event-meta">';
                            $html .= '<div class="mec-event-cost">';
                            $html .= '<i class="mec-sl-wallet"></i>';
                            $html .= '<h3 class="mec-cost">' . Base::get_main()->m('cost', esc_html__('Cost', 'mec')) . '</h3>';
                            $html .= '<dd class="mec-events-event-cost">' . (is_numeric($events_detail->data->meta['mec_cost']) ? Base::get_main()->render_price($events_detail->data->meta['mec_cost'], $events_detail) : $events_detail->data->meta['mec_cost']) . '</dd>';
                            $html .= '</div></div>';
                        }
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'banner':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-banner', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'labels':
                    $event_detail = $this->get_event_detail($custom_event_id);
                    $labels = isset($event_detail->data->labels) ? $event_detail->data->labels : array();

                    $html = '';
                    if (empty($labels) && $this->is_editor_mode()) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if label is set. In order for the widget in this page to be displayed correctly, please set label for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/label/" target="_blank">' . esc_html__('How to set label', 'mec') . ' </a>'
                            . '</p></div>';
                    } elseif (!empty($labels)) {

                        $html .= '<div class="mec-event-meta">';
                        $mec_items = count($labels);
                        $mec_i = 0;
                        $html .= '<div class="mec-single-event-label">';
                        $html .= '<i class="mec-fa-bookmark-o"></i>';
                        $html .= '<h3 class="mec-cost">' . Base::get_main()->m('taxonomy_labels', esc_html__('Labels', 'mec')) . '</h3>';
                        foreach ($labels as $k => $label) {
                            $seperator = (++$mec_i === $mec_items) ? '' : ',';
                            $html .= '<dd style="color:' . esc_attr($label['color']) . '">' . esc_html(translate($label["name"] . $seperator)) . '</dd>';
                        }
                        $html .= '</div>';
                        $html .= '</div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'moreInfo':
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && (!(isset($event_detail->data->meta['mec_more_info']) && $event_detail->data->meta['mec_more_info'] != ''))) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if read more is set. In order for the widget in this page to be displayed correctly, please set read more for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/add-event/" target="_blank">' . esc_html__('How to set read more', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {
                        $html .= '<style>.mec-event-more-info h3{display:inline;}</style>';
                        $html .= '<div class="mec-event-meta">';
                        $html .= '<div class="mec-event-more-info">';
                        $html .= '<i class="mec-sl-info"></i>';
                        $html .= '<h3 class="mec-more-info-label">' . Base::get_main()->m('more_info_link', esc_html__('More Info', 'mec')) . '</h3>';
                        $html .= '<dd class="mec-events-event-more-info"><a class="mec-more-info-button a mec-color-hover" target="' . (isset($event_detail->data->meta['mec_more_info_target']) ? esc_attr($event_detail->data->meta['mec_more_info_target']) : '_self') . '" href="' . esc_attr($event_detail->data->meta['mec_more_info']) . '">' . ((isset($event_detail->data->meta['mec_more_info_title']) && trim($event_detail->data->meta['mec_more_info_title'])) ? esc_html($event_detail->data->meta['mec_more_info_title']) : esc_html__('Read More', 'mec')) . '</a></dd>';
                        $html .= '</div>';
                        $html .= '</div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'organizers':
                    $html = '';
                    $html .= '<style>
                                     .single-mec_esb.mec-single-event .mec-organizer-tel a {
                                                                          display: block;
                                                                          padding-left: 41px;
                                                                          color: #8d8d8d;
                                                                             }
                             </style>';

                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);
                    $organizers = isset($event_detail->data->organizers) ? $event_detail->data->organizers : array();
                    $primary_organizer_id = isset($event_detail->data->meta['mec_organizer_id']) ? $event_detail->data->meta['mec_organizer_id'] : '';

                    $html = '';
                    if ($this->is_editor_mode() && (empty($organizers) || !isset($organizers[$primary_organizer_id]))) {
                        $html = '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if organizer is set. In order for the widget in this page to be displayed correctly, please set organizer for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/organizer-and-other-organizer/" target="_blank">' . esc_html__('How to set organizer', 'mec') . ' </a>'
                            . '</p></div>';
                    } elseif (!empty($organizers) && isset($organizers[$primary_organizer_id]) && !empty($organizers[$primary_organizer_id])) {

                        $organizer = $organizers[$primary_organizer_id];

                        $html .= '<div class="mec-event-meta">';
                        $html .= '<div class="mec-single-event-organizer">';
                        if (isset($organizer['thumbnail']) and trim($organizer['thumbnail'])) {
                            $html .= '<img class="mec-img-organizer" src="' . esc_url($organizer['thumbnail']) . '" alt="' . (isset($organizer['name']) ? esc_attr($organizer['name']) : '') . '">';
                        }
                        $html .= '<h3 class="mec-events-single-section-title">' . Base::get_main()->m('taxonomy_organizer', esc_html__('Organizer', 'mec')) . '</h3>';
                        if (isset($organizer['thumbnail'])) {
                            $html .= '<dd class="mec-organizer">';
                            $html .= '<i class="mec-sl-home"></i>';
                            $html .= '<h6>' . (isset($organizer['name']) ? esc_html(translate($organizer['name'])) : '') . '</h6>';
                            $html .= '</dd>';
                        }
                        if (isset($organizer['tel']) && !empty($organizer['tel'])) {
                            $html .= '<dd class="mec-organizer-tel">';
                            $html .= '<i class="mec-sl-phone"></i>';
                            $html .= '<h6>' . esc_html(translate('Phone', 'mec')) . '</h6>';
                            $html .= '<a href="tel:' . esc_attr($organizer['tel']) . '">' . esc_html(translate($organizer['tel'])) . '</a>';
                            $html .= '</dd>';
                        }
                        if (isset($organizer['email']) && !empty($organizer['email'])) {
                            $html .= '<dd class="mec-organizer-email">';
                            $html .= '<i class="mec-sl-envelope"></i>';
                            $html .= '<h6>' . esc_html(translate('Email', 'mec')) . '</h6>';
                            $html .= '<a href="mailto:' . esc_attr($organizer['email']) . '">' . esc_html(translate($organizer['email'])) . '</a>';
                            $html .= '</dd>';
                        }
                        if (isset($organizer['url']) && !empty($organizer['url']) and $organizer['url'] != 'http://') {
                            $html .= '<dd class="mec-organizer-url">';
                            $html .= '<i class="mec-sl-sitemap"></i>';
                            $html .= '<h6>' . esc_html(translate('Website', 'mec')) . '</h6>';
                            $html .= '<span><a href="' . esc_url($organizer['url']) . '" class="mec-color-hover" target="_blank">' . esc_url($organizer['url']) . '</a></span>';
                            $html .= '</dd>';
                        }
                        $organizer_description_setting = isset($settings['organizer_description']) ? $settings['organizer_description'] : '';
                        $organizer_terms = get_the_terms($event_detail->data, 'mec_organizer');
                        if ($organizer_description_setting == '1') {
                            foreach ($organizer_terms as $organizer_term) {
                                if ($organizer_term->term_id == $organizer['id']) {
                                    if (isset($organizer_term->description) && !empty($organizer_term->description)) {
                                        $html .= '<dd class="mec-organizer-description">';
                                        $html .= '<p>' . esc_html(translate($organizer_term->description)) . '</p>';
                                        $html .= '</dd>';
                                    }
                                }
                            }
                        }
                        $html .= '</div>';
                        $html .= $this->show_other_organizers($event_detail); // Show Additional Organizers
                        $html .= '</div>';
                    }
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'speakers':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-speakers', $custom_event_id, ['edit_mode' => false]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'attendees':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $events_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if (isset($settings['bp_status']) && $settings['bp_status']) {
                        $html .= Base::get_main()->module('attendees-list.details', array('event' => $events_detail));
                    }

                    if ($this->is_editor_mode() && empty($html)) {
                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if buddypress is set. In order for the widget in this page to be displayed correctly, please set buddypress for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/buddypress/" target="_blank">' . esc_html__('How to set buddypress', 'mec') . ' </a>'
                            . '</p></div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'hourlySchedule':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-hourly-schedule', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'next':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-next-occurrences', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'qrCode':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && (!isset($settings['qrcode_module_status']) || !$settings['qrcode_module_status'])) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if QR Code is set. In order for the widget in this page to be displayed correctly, please set QR code module for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/qr-code-module/" target="_blank">' . esc_html__('How to set QR code module', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {
                        $html .= Base::get_main()->module('qrcode.details', array('event' => $event_detail));
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'socialShare':
                    $main = MEC::getInstance('app.libraries.main');
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && (!isset($settings['social_network_status']) || !$settings['social_network_status'])) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if social networks is set. In order for the widget in this page to be displayed correctly, please set label for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/social-networks/" target="_blank">' . esc_html__('How to set social networks', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {

                        $url = isset($event_detail->data->permalink) ? $event_detail->data->permalink : '';
                        if (trim($url) == '') {
                            $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                            $response = new WP_REST_Response($data_response);
                            break;
                        }

                        $socials = Base::get_main()->get_social_networks();
                        $html .= '<div class="mec-event-social mec-frontbox">';
                        $html .= '<h3 class="mec-social-single mec-frontbox-title">' . esc_html(translate('Share this event', 'mec')) . '</h3>';
                        $html .= '<div class="mec-event-sharing">';
                        $html .= '<div class="mec-links-details">';
                        $html .= '<ul>';
                        $social_networks = isset($settings['sn']) && is_array($settings['sn']) ? $settings['sn'] : array();
                        foreach ($socials as $key => $social) {
                            if ($key != "email") {
                                $social_id = $social['id'];
                                $is_enabled = isset($social_networks[$social_id]) && !$social_networks[$social_id];
                                if ($is_enabled) {
                                    continue;
                                }

                                if (is_callable($social['function'])) {
                                    $html .= call_user_func($social['function'], $url, $event_detail);
                                }
                            }
                        }

                        $html .= '</ul>';
                        $html .= '</div>';
                        $html .= '</div>';
                        $html .= '</div>';
//                        $html =  EventSocialShare::getInstance()->output( $custom_event_id );
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case
                'booking':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail(get_the_ID());
                    $html = '';

                    if ($this->is_editor_mode() && (!isset($settings['booking_status']) || !$settings['booking_status'])) {
                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>'
                            . esc_html__('This widget is displayed if label is set. In order for the widget in this page to be displayed correctly, please set Booking module for your last event.', 'mec')
                            . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/booking/" target="_blank">' . esc_html__('How to set booking module', 'mec') . ' </a>'
                            . '</p>'
                            . '</div>';
                    } else {

                        $html .= $this->get_display_booking_form(get_the_ID());

                        if ($this->is_editor_mode() && \MEC\Base::get_main()->can_show_booking_module($event_detail) && isset($settings['single_booking_style']) && $settings['single_booking_style'] == 'modal') {

                            $html .= '<style>
					.lity-container {
						max-width: 480px;
						width: 480px;
					}
				</style>';
                            $html .= '<div class="mec-content-notification"><p><span>'
                                . __('It seems that you have set "Booking" to modal from Single Event MEC Settings. You need to know that for this mode to work you must add Register Button Widget to this page, then in the front-end by clicking the Register button in your events you can then see the modal mode of the Booking.', 'mec')
                                . '</span></p></div>';
                        } elseif ($this->is_editor_mode() && empty($html)) {

                            $html .= '<div class="mec-content-notification"><p>'
                                . '<span>'
                                . esc_html__('This widget is displayed if Booking is set. In order for the widget in this page to be displayed correctly, please set Booking module for your last event.', 'mec')
                                . '</span>'
                                . '<a href="https://webnus.net/dox/modern-events-calendar/add-a-booking-system/" target="_blank">' . esc_html__('How to set Booking module', 'mec') . ' </a>'
                                . '</p></div>';
                        } elseif ($this->is_editor_mode()) {

                            $html .= '<script>jQuery("#mec-book-form-btn-step-1").prop("disabled",true);</script>';
                        }
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'breadcrumbs':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $html = '';
                    if ($this->is_editor_mode() && (!isset($settings['breadcrumbs']) || !$settings['breadcrumbs'])) {

                        $html = '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if breadcrumbs is set. In order for the widget in this page to be displayed correctly, please set breadcrumbs for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/event-detailssingle-event-page/" target="_blank">' . esc_html__('How to set breadcrumbs', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {

                        $html .= '<div class="mec-breadcrumbs">';
                        $html .= $this->display_breadcrumb_widget($custom_event_id);
                        $html .= '</div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'cancellation':
                    $display_reason = get_post_meta($custom_event_id, 'mec_display_cancellation_reason_in_single_page', true);
                    $html = '';
                    if (!$display_reason && $this->is_editor_mode()) {

                        $html = '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if cancellation reason is set. In order for the widget in this page to be displayed correctly, please set cancellation reason for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/add-event/#SEO_SchemaEvent_Status" target="_blank">' . esc_html__('Cancellation Reason', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {

                        $events_detail = $this->get_event_detail($custom_event_id);

                        $display_reason = get_post_meta($custom_event_id, 'mec_display_cancellation_reason_in_single_page', true);
                        if ($display_reason) {
                            $html = Base::get_main()->display_cancellation_reason($events_detail, $display_reason);
                        }
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'data':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);
                    $data = (isset($event_detail->data->meta['mec_fields']) and is_array($event_detail->data->meta['mec_fields'])) ? $event_detail->data->meta['mec_fields'] : get_post_meta($event_detail->ID, 'mec_fields', true);


                    $html = '';
                    if (!empty($data) && (isset($settings['display_event_fields']) && $settings['display_event_fields'])) {
                        $html = $this->display_data_fields($event_detail);
                    }

                    if ($this->is_editor_mode() && empty($html)) {

                        $html = '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if event data is set. In order for the widget in this page to be displayed correctly, please set event data for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/custom-fields/" target="_blank">' . esc_html__('How to set Custom Fields', 'mec') . ' </a>'
                            . '</p></div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'map':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);
                    $primary_location_id = isset($event_detail->data->meta['mec_location_id']) ? $event_detail->data->meta['mec_location_id'] : '';
                    $have_location = $primary_location_id && $primary_location_id > 1 ? true : false;

                    $html = '';
                    if (isset($settings['google_maps_status']) && $settings['google_maps_status'] && $have_location) {

                        $html = Base::get_main()->module('googlemap.details', array('event' => [$event_detail]));
                        if ($html) {

                            $html = '<div class="mec-events-meta-group mec-events-meta-group-gmap">'
                                . $html .
                                '</div>';
                        }
                    }

                    if ($this->is_editor_mode() && (!isset($settings['google_maps_status']) || !$settings['google_maps_status'])) {

                        $html = '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This option is disabled. In order for the widget in this page to be displayed correctly, please turn on  Google Maps Options and set the API for it there.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/google-maps-options/" target="_blank">' . esc_html__('How to set Google Map', 'mec') . ' </a>'
                            . '</p></div>';
                    } elseif ($this->is_editor_mode() && empty($html)) {

                        $html = '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if Google Map is set. In order for the widget in this page to be displayed correctly, please set Google Map for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/google-maps-options/" target="_blank">' . esc_html__('How to set Google Map', 'mec') . ' </a>'
                            . '</p></div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'nextPrevious':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && (!isset($settings['next_previous_events']) || !$settings['next_previous_events'])) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if related events is set. In order for the widget in this page to be displayed correctly, please set Related Event for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/next-previous-events/" target="_blank">' . esc_html__('How to set Next/Previous Events', 'mec') . ' </a>'
                            . '</p></div>';
                    }
                    else {
                        $event = $event_detail;
                        if (!isset($settings['next_previous_events'])) {
                            $html = '';
                        } else {
                            if (isset($settings['next_previous_events']) && $settings['next_previous_events'] != '1') {
                                $html = '';
                            } else {
                                if (is_numeric($event)) {
                                    $event_id = $event;
                                } else if (is_object($event) and isset($event->ID)) {
                                    $event_id = $event->ID;
                                } else {
                                    $content_render = '<div><div class="event-next-gsb">' . $html . '</div></div>';
                                    return $content_render;
                                }

                                $main = MEC::getInstance('app.libraries.main');
                                $db = MEC::getInstance('app.libraries.db');
                                $p_exclude = array($event_id);
                                $n_exclude = array($event_id);

                                $pskip = (isset($_REQUEST['pskip']) and is_numeric($_REQUEST['pskip']) and $_REQUEST['pskip'] > 0) ? sanitize_text_field($_REQUEST['pskip']) : NULL;
                                if ($pskip) $p_exclude[] = $pskip;

                                $nskip = (isset($_REQUEST['nskip']) and is_numeric($_REQUEST['nskip']) and $_REQUEST['nskip'] > 0) ? sanitize_text_field($_REQUEST['nskip']) : NULL;
                                if ($nskip) $n_exclude[] = $nskip;

                                $date = $event->date;
                                $timestamp = (isset($date['start']) and isset($date['start']['timestamp'])) ? $date['start']['timestamp'] : NULL;

                                $args = array(
                                    'post_type' => $main->get_main_post_type(),
                                    'posts_per_page' => -1,
                                    'post_status' => 'publish',
                                    'orderby' => 'ASC',
                                    'tax_query' => array(),
                                );

                                if (isset($settings['next_previous_events_category']) && $settings['next_previous_events_category'] == 1) {
                                    $post_terms = wp_get_object_terms($event_id, 'mec_category', array('fields' => 'slugs'));
                                    $args['tax_query'][] = array(
                                        'taxonomy' => 'mec_category',
                                        'field' => 'slug',
                                        'terms' => $post_terms
                                    );
                                }

                                if (isset($settings['next_previous_events_organizer']) && $settings['next_previous_events_organizer'] == 1) {
                                    $post_terms = wp_get_object_terms($event_id, 'mec_organizer', array('fields' => 'slugs'));
                                    $args['tax_query'][] = array(
                                        'taxonomy' => 'mec_organizer',
                                        'field' => 'slug',
                                        'terms' => $post_terms
                                    );
                                }

                                if (isset($settings['next_previous_events_location']) && $settings['next_previous_events_location'] == 1) {
                                    $post_terms = wp_get_object_terms($event_id, 'mec_location', array('fields' => 'slugs'));
                                    $args['tax_query'][] = array(
                                        'taxonomy' => 'mec_location',
                                        'field' => 'slug',
                                        'terms' => $post_terms
                                    );
                                }

                                if (isset($settings['next_previous_events_speaker']) && $settings['next_previous_events_speaker'] == 1) {
                                    $post_terms = wp_get_object_terms($event_id, 'mec_speaker', array('fields' => 'slugs'));
                                    $args['tax_query'][] = array(
                                        'taxonomy' => 'mec_speaker',
                                        'field' => 'slug',
                                        'terms' => $post_terms
                                    );
                                }

                                if (isset($settings['next_previous_events_label']) && $settings['next_previous_events_label'] == 1) {
                                    $post_terms = wp_get_object_terms($event_id, 'mec_label', array('fields' => 'slugs'));
                                    $args['tax_query'][] = array(
                                        'taxonomy' => 'mec_label',
                                        'field' => 'slug',
                                        'terms' => $post_terms
                                    );
                                }

                                if (isset($settings['next_previous_events_tag']) && $settings['next_previous_events_tag'] == 1) {
                                    $post_terms = wp_get_object_terms($event_id, apply_filters('mec_taxonomy_tag', ''), array('fields' => 'slugs'));
                                    $args['tax_query'][] = array(
                                        'taxonomy' => apply_filters('mec_taxonomy_tag', ''),
                                        'field' => 'slug',
                                        'terms' => $post_terms
                                    );
                                }

                                $args['tax_query']['relation'] = 'OR';

                                $p_args = array_merge($args, array('post__not_in' => $p_exclude));
                                $n_args = array_merge($args, array('post__not_in' => $n_exclude));

                                $p_args = apply_filters('mec_next_previous_query', $p_args, $event_id);
                                $n_args = apply_filters('mec_next_previous_query', $n_args, $event_id);

                                $p_IDs = array();
                                $n_IDs = array();

                                $query = new WP_Query($p_args);
                                if ($query->have_posts()) {
                                    while ($query->have_posts()) {
                                        $query->the_post();
                                        $p_IDs[] = get_the_ID();
                                    }
                                }

                                wp_reset_postdata();

                                if ($p_args === $n_args) $n_IDs = $p_IDs;
                                else {
                                    $query = new WP_Query($n_args);
                                    if ($query->have_posts()) {
                                        while ($query->have_posts()) {
                                            $query->the_post();
                                            $n_IDs[] = get_the_ID();
                                        }
                                    }

                                    wp_reset_postdata();
                                }

                                // No Event Found!
                                if (!count($p_IDs) and !count($n_IDs)) {
                                    $content_render = '<div><div class="event-next-gsb">' . $html . '</div></div>';
                                    return $content_render;
                                }

                                $p = $db->select("SELECT `post_id`, `tstart` FROM `#__mec_dates` WHERE `tstart`<='" . $timestamp . "' AND `post_id` IN (" . implode(',', $p_IDs) . ") ORDER BY `tstart` DESC LIMIT 1", 'loadAssoc');
                                $n = $db->select("SELECT `post_id`, `tstart` FROM `#__mec_dates` WHERE `tstart`>='" . $timestamp . "' AND `post_id` IN (" . implode(',', $n_IDs) . ") ORDER BY `tstart` ASC LIMIT 1", 'loadAssoc');

                                // No Event Found!
                                if (!isset($p['post_id']) and !isset($n['post_id'])) {
                                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                                    $response = new WP_REST_Response($data_response);
                                    break;
                                }

                                $html .= '<ul class="mec-next-previous-events">';

                                if (is_array($p) and isset($p['post_id'])) {
                                    $p_url = $main->get_event_date_permalink(get_permalink($p['post_id']), date('Y-m-d', $p['tstart']));
                                    $p_url = $main->add_qs_var('pskip', $event_id, $p_url);

                                    $html .= '<li class="mec-previous-event"><a class="mec-color mec-bg-color-hover mec-border-color" href="' . esc_url($p_url) . '"><i class="mec-fa-long-arrow-left"></i>' . esc_html__('PRV Event', 'mec') . '</a></li>';
                                }

                                if (is_array($n) and isset($n['post_id'])) {
                                    $n_url = $main->get_event_date_permalink(get_permalink($n['post_id']), date('Y-m-d', $n['tstart']));
                                    $n_url = $main->add_qs_var('nskip', $event_id, $n_url);

                                    $html .= '<li class="mec-next-event"><a class="mec-color mec-bg-color-hover mec-border-color" href="' . esc_html($n_url) . '">' . esc_html__('NXT Event', 'mec') . '<i class="mec-fa-long-arrow-right"></i></a></li>';
                                }

                                $html .= '</ul>';

                            }
                        }

                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'publicDownload':
                    $events_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    $single = new \MEC_skin_single();
                    $html .= $single->display_public_download_module($events_detail);

                    if (empty($html) && $this->is_editor_mode()) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if event Public Download is set. In order for the widget in this page to be displayed correctly, please set Public Download for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/single-event-page-settings/#Public_Download_Module" target="_blank">' . esc_html__('How to set Public Download', 'mec') . ' </a>'
                            . '</p></div>';

                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'registerButton':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '';
                    if ($this->is_editor_mode() && (!isset($settings['single_booking_style']) || !$settings['single_booking_style'])) {
                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if register button is set. In order for the widget in this page to be displayed correctly, please set register button for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/booking/" target="_blank">' . esc_html__('How to set register button', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {

                        $single = new \MEC_skin_single();

                        $mec_more_info = isset($event_detail->data->meta['mec_more_info']) && trim($event_detail->data->meta['mec_more_info']) && $event_detail->data->meta['mec_more_info'] != 'http://';
                        $mec_more_info_target = isset($event_detail->data->meta['mec_more_info_target']) ? $event_detail->data->meta['mec_more_info_target'] : '_self';
                        if (isset($event_detail->data->meta['mec_more_info_title']) && trim($event_detail->data->meta['mec_more_info_title'])) {
                            $button_text = trim($event_detail->data->meta['mec_more_info_title']);
                        } else {
                            $button_text = Base::get_main()->m('register_button', esc_html__('REGISTER', 'mec'));
                        }

                        $classes = '';
                        if (isset($settings['single_booking_style']) && $settings['single_booking_style'] != 'modal') {
                            $classes = 'simple-booking';
                        }
                        $html .= '<!-- Register Booking Button -->';
                        $html .= '<div class="mec-reg-btn mec-frontbox">';
                        if (Base::get_main()->can_show_booking_module($event_detail)) {

                            $data_lity = '';
                            if (isset($settings['single_booking_style']) && $settings['single_booking_style'] == 'modal') {
                                $data_lity = 'data-lity';
                                $classes .= ' mec-booking-data-lity';
                            }
                            $html .= '<a class="mec-booking-button mec-bg-color ' . esc_attr($classes) . '" href="#mec-events-meta-group-booking-' . esc_attr($single->uniqueid) . '" ' . esc_attr($data_lity) . '>' . esc_html__($button_text, 'mec') . '</a>';
                            $html .= '<script>
                                    // Fix modal booking in some themes
                                    if( \'undefined\' === typeof mec_booking_lity_init){

                                        function mec_booking_lity_init(e){

                                            e.preventDefault();
                                            var book_id =  jQuery(this).attr(\'href\');
                                            lity(book_id);

                                            return false;
                                        }
                                        jQuery( ".mec-booking-button.mec-booking-data-lity" ).on(\'click\',mec_booking_lity_init);
                                    }
                                </script>';
                        } elseif ($mec_more_info) {
                            $html .= '<a target="' . esc_attr($mec_more_info_target) . '" class="mec-booking-button mec-bg-color" href="' . esc_url($event_detail->data->meta['mec_more_info']) . '">';
                            $html .= esc_html__($button_text, 'mec');
                            $html .= '</a>';
                        }
                        $html .= '</div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'related':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $html = '';
                    if ($this->is_editor_mode() && (!isset($settings['related_events']) || !$settings['related_events'])) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if related events is set. In order for the widget in this page to be displayed correctly, please set Related Event for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/related-events/" target="_blank">' . esc_html__('How to set related events', 'mec') . ' </a>'
                            . '</p></div>';
                    } else {
                        $html .= $this->display_related_posts_widget($custom_event_id);
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'weather':
                    $settings = \MEC\Settings\Settings::getInstance()->get_settings();
                    $event_detail = $this->get_event_detail($custom_event_id);

                    $html = '';

                    if (isset($settings['weather_module_status']) && $settings['weather_module_status']) {
                        $html .= Base::get_main()->module('weather.details', array('event' => $event_detail));
                    }

                    if ($this->is_editor_mode() && empty($html)) {

                        $html .= '<div class="mec-content-notification"><p>'
                            . '<span>' . esc_html__('This widget is displayed if weather is set. In order for the widget in this page to be displayed correctly, please set location for your last event.', 'mec') . '</span>'
                            . '<a href="https://webnus.net/dox/modern-events-calendar/weather-module/" target="_blank">' . esc_html__('How to set weather', 'mec') . ' </a>'
                            . '</p></div>';
                    }

                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'export':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-export', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'faq':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-faq', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'locations':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-locations', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'sponsors':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-sponsors', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'trailerUrl':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-trailer-url', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                case 'rsvp':
                    $html = \MEC\SingleBuilder\SingleBuilder::getInstance()->output('rsvp-form', $custom_event_id, ['edit_mode' => true]);
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => $html);
                    $response = new WP_REST_Response($data_response);
                    break;
                default:
                    $data_response = array('status' => 200, 'msg' => "Successful", 'data' => 'Not Found!');
                    $response = new WP_REST_Response($data_response);
                    break;
            }
        } else {
            $data_response = array('status' => 200, 'msg' => "Successful", 'data' => 'Not Found!');
            $response = new WP_REST_Response($data_response);
        }

        $response->set_status(200);
        return $response;
    }

    /**
     * @param int|WP_Post $event
     *
     * @return Object
     */
    public
    function get_event_detail($event_id)
    {
        $event = new \MEC\Events\Event($event_id);
        return $event->get_detail();
    }


    public
    function display_breadcrumb_widget($page_id)
    {
        $settings = \MEC\Settings\Settings::getInstance()->get_settings();
        $main = MEC::getInstance('app.libraries.main');
        $html = '';
        /**
         * Home Page
         */
        $homeURL = esc_url(home_url('/'));
        $html .= '<div class="mec-address"><a href="' . esc_url($homeURL) . '"> ' . esc_html__('Home', 'mec') . ' </a> <i class="mec-color mec-sl-arrow-right"></i> ';

        $archive_title = $main->get_archive_title();
        $archive_link = $main->get_archive_url();

        $referer_url = wp_get_referer();
        if (trim($referer_url)) {
            $referer_page_id = url_to_postid($referer_url);
            if ($referer_page_id and strpos(get_post_field('post_content', $referer_page_id), '[MEC') !== false) {
                $archive_link = $referer_url;
                $archive_title = get_the_title($referer_page_id);
            }
        }

        /**
         * Archive Page
         */
        if ($archive_link) $html .= '<a href="' . esc_url($archive_link) . '">' . esc_html($archive_title) . '</a> <i class="mec-color mec-sl-arrow-right"></i> ';

        /**
         * Categories Page
         */
        if (!isset($settings['breadcrumbs_category']) or (isset($settings['breadcrumbs_category']) and $settings['breadcrumbs_category'])) {
            $categories = wp_get_post_terms($page_id, 'mec_category');
            if (!is_array($categories)) $categories = array();

            foreach ($categories as $category) $html .= '<a href="' . esc_url(get_term_link($category)) . '">' . esc_html($category->name) . '</a> <i class="mec-color mec-sl-arrow-right"></i> ';
        }

        /**
         * Current Event
         */
        $html .= '<span class="mec-current">' . get_the_title($page_id) . '</span></div>';

        return $html;
    }

    public
    function get_display_booking_form($event_id)
    {
        ob_start();
        \MEC\Books\BookingForm::getInstance()->display_form($event_id);
        return ob_get_clean();
    }

    public
    function display_data_fields($event, $sidebar = false, $shortcode = false)
    {
        $settings = \MEC\Settings\Settings::getInstance()->get_settings();
        $main = MEC::getInstance('app.libraries.main');

        $html = '';

        $display = isset($settings['display_event_fields']) ? (boolean)$settings['display_event_fields'] : true;
        if (!$display and !$sidebar and !$shortcode) return;

        $fields = $main->get_event_fields();
        if (!is_array($fields) or (is_array($fields) and !count($fields))) return;

        // Start Timestamp
        $start_timestamp = (isset($event->date) and isset($event->date['start']) and isset($event->date['start']['timestamp'])) ? $event->date['start']['timestamp'] : NULL;

        $data = (isset($event->data) and isset($event->data->meta) and isset($event->data->meta['mec_fields']) and is_array($event->data->meta['mec_fields'])) ? $event->data->meta['mec_fields'] : get_post_meta($event->ID, 'mec_fields', true);
        if ($start_timestamp) $data = MEC_feature_occurrences::param($event->ID, $start_timestamp, 'fields', $data);

        if (!is_array($data) or (is_array($data) and !count($data))) return;

        foreach ($fields as $n => $item) {
            // n meaning number
            if (!is_numeric($n)) continue;

            $result = isset($data[$n]) ? $data[$n] : NULL;
            if ((!is_array($result) and trim($result) == '') or (is_array($result) and !count($result))) continue;

            $content = isset($item['type']) ? $item['type'] : 'text';
            if ($content === 'checkbox') {
                $cleaned = array();
                foreach ($result as $k => $v) {
                    if (trim($v) !== '') $cleaned[] = $v;
                }

                $value = $cleaned;
                if (!count($value)) {
                    $content = NULL;
                    continue;
                }
            }
        }

        if (isset($content) && $content != NULL && (isset($settings['display_event_fields_backend']) and $settings['display_event_fields_backend'] == 1) or !isset($settings['display_event_fields_backend'])) {
            $date_format = get_option('date_format');

            $html .= '<div class="mec-event-data-fields mec-frontbox ' . ($sidebar ? 'mec-data-fields-sidebar' : '') . ' ' . ($shortcode ? 'mec-data-fields-shortcode mec-util-hidden' : '') . '">';
            $html .= '<div class="mec-data-fields-tooltip">';
            $html .= '<div class="mec-data-fields-tooltip-box">';
            $html .= '<ul class="mec-event-data-field-items">';
            foreach ($fields as $f => $field) {
                if (!is_numeric($f)) continue;
                $value = isset($data[$f]) ? $data[$f] : NULL;
                if ((!is_array($value) and trim($value) == '') or (is_array($value) and !count($value))) continue;

                $type = isset($field['type']) ? $field['type'] : 'text';
                if ($type === 'checkbox') {
                    $cleaned = array();
                    foreach ($value as $k => $v) {
                        if (trim($v) !== '') $cleaned[] = $v;
                    }

                    $value = $cleaned;
                    if (!count($value)) continue;
                }

                $html .= '<li class="mec-event-data-field-item mec-field-item-' . esc_attr($type) . '">';
                if (isset($field['label'])) {
                    $html .= '<span class="mec-event-data-field-name">' . esc_html(translate(stripslashes($field['label']), 'mec')) . ': </span>';
                }

                if ($type === 'email') {
                    $html .= '<span class="mec-event-data-field-value"><a href="mailto:' . esc_attr($value) . '">' . esc_html($value) . '</a></span>';
                } elseif ($type === 'tel') {
                    $html .= '<span class="mec-event-data-field-value"><a href="tel:' . esc_attr($value) . '">' . esc_html($value) . '</a></span>';
                } elseif ($type === 'url') {
                    $html .= '<span class="mec-event-data-field-value"><a href="' . esc_url($value) . '" target="_blank">' . esc_html($value) . '</a></span>';
                } elseif ($type === 'date') {
                    $value = $main->to_standard_date($value);
                    $html .= '<span class="mec-event-data-field-value">' . esc_html($main->date_i18n($date_format, strtotime($value))) . '</span>';
                } elseif ($type === 'textarea') {
                    $html .= '<span class="mec-event-data-field-value">' . wpautop(stripslashes($value)) . '</span>';
                } else {
                    $html .= '<span class="mec-event-data-field-value">' . (is_array($value) ? esc_html(stripslashes(implode(', ', $value))) : esc_html(stripslashes($value))) . '</span>';
                }
                $html .= '</li>';
            }
            $html .= '</ul>';
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</div>';

        }

        return $html;
    }

    public
    function show_other_organizers($event)
    {
        $settings = \MEC\Settings\Settings::getInstance()->get_settings();
        $main = MEC::getInstance('app.libraries.main');

        $additional_organizers_status = (!isset($settings['additional_organizers']) or (isset($settings['additional_organizers']) and $settings['additional_organizers'])) ? true : false;
        if (!$additional_organizers_status) return;

        $organizer_id = $main->get_master_organizer_id($event);

        $organizers = array();
        $html = '';
        if (isset($event->data->organizers) && !empty($event->data->organizers)) {
            foreach ($event->data->organizers as $o)
                if ($o['id'] != $organizer_id)
                    $organizers[$o['id']] = $o;

            if (!count($organizers)) return;

            $organizer_ids = get_post_meta($event->ID, 'mec_additional_organizer_ids', true);
            if (!is_array($organizer_ids)) $organizer_ids = array();
            $organizer_ids = array_unique($organizer_ids);
            $html .= '<div class="mec-single-event-additional-organizers">';
            $html .= ' <h3 class="mec-events-single-section-title">' . esc_html($main->m('other_organizers', esc_html__('Other Organizers', 'mec'))) . '</h3>';
            foreach ($organizer_ids as $o_id) {
                $o_id = apply_filters('wpml_object_id', $o_id, 'mec_organizer', true);
                if ($o_id == $organizer_id) continue;
                $organizer = (isset($organizers[$o_id]) ? $organizers[$o_id] : NULL);
                if (!$organizer) continue;

                $html .= '<div class="mec-single-event-additional-organizer">';
                if (isset($organizer['thumbnail']) and trim($organizer['thumbnail'])) {
                    if (class_exists('MEC_Fluent\Core\pluginBase\MecFluent') && (isset($settings['single_single_style']) and $settings['single_single_style'] == 'fluent')) {
                        $html .= '<img class="mec-img-organizer" src="' . esc_url(MEC_Fluent\Core\pluginBase\MecFluent::generateCustomThumbnailURL($organizer['thumbnail'], 83, 83, true)) . '" alt="' . (isset($organizer['name']) ? esc_attr($organizer['name']) : '') . '">';
                    } else {
                        $html .= '<img class="mec-img-organizer" src="' . esc_url($organizer['thumbnail']) . '" alt="' . (isset($organizer['name']) ? esc_attr($organizer['name']) : '') . '">';
                    }
                }
                $html .= '<dl>';
                if (isset($organizer['thumbnail'])) {
                    $html .= ' <dd class="mec-organizer">';
                    $html .= '<i class="mec-sl-home"></i>';
                    $html .= '<h6>' . (isset($organizer['name']) ? esc_html($organizer['name']) : '') . '</h6>';
                    $html .= '</dd>';
                }
                if (isset($organizer['tel']) && !empty($organizer['tel'])) {
                    $html .= '<dd class="mec-organizer-tel">';
                    $html .= '<i class="mec-sl-phone"></i>';
                    $html .= '<h6>' . esc_html_e('Phone', 'mec') . '</h6>';
                    $html .= '<a href="tel:' . esc_attr($organizer['tel']) . '">' . esc_html($organizer['tel']) . '</a>';
                    $html .= '</dd>';
                }
                if (isset($organizer['email']) && !empty($organizer['email'])) {
                    $html .= '<dd class="mec-organizer-email">';
                    $html .= '<i class="mec-sl-envelope"></i>';
                    $html .= '<h6>' . esc_html_e('Email', 'mec') . '</h6>';
                    $html .= '<a href="mailto:' . esc_attr($organizer['email']) . '">' . esc_html($organizer['email']) . '</a>';
                    $html .= '</dd>';
                }
                if (isset($organizer['url']) && !empty($organizer['url']) and $organizer['url'] != 'http://') {
                    $html .= '<dd class="mec-organizer-url">';
                    $html .= '<i class="mec-sl-sitemap"></i>';
                    $html .= '<h6>' . esc_html_e('Website', 'mec') . '</h6>';
                    $html .= '<span><a href="' . esc_url($organizer['url']) . '" class="mec-color-hover" target="_blank">' . esc_html($organizer['url']) . '</a></span>';
                    $html .= '</dd>';
                }
                $organizer_description_setting = isset($settings['addintional_organizers_description']) ? $settings['addintional_organizers_description'] : '';
                $organizer_terms = get_the_terms($event->data, 'mec_organizer');
                if ($organizer_description_setting == '1') {
                    foreach ($organizer_terms as $organizer_term) {
                        if ($organizer_term->term_id == $organizer['id']) {
                            if (isset($organizer_term->description) && !empty($organizer_term->description)) {
                                $html .= '<dd class="mec-organizer-description">';
                                $html .= '<p>' . esc_html($organizer_term->description) . '</p>';
                                $html .= '</dd>';
                            }
                        }
                    }
                }
                $html .= '</dl>';
                $html .= '</div>';
            }
            $html .= '</div>';
        }

        return $html;
    }

    public
    function display_related_posts_widget($event)
    {
        $settings = \MEC\Settings\Settings::getInstance()->get_settings();
        $main = MEC::getInstance('app.libraries.main');

        $html = '';
        if (!isset($settings['related_events'])) return;
        if (isset($settings['related_events']) && $settings['related_events'] != '1') return;

        if (is_numeric($event)) $event_id = $event;
        else return;

        $limit = (isset($settings['related_events_limit']) and trim($settings['related_events_limit'])) ? $settings['related_events_limit'] : 30;

        $related_args = array(
            'post_type' => $main->get_main_post_type(),
            'posts_per_page' => max($limit, 20),
            'post_status' => 'publish',
            'post__not_in' => array($event_id),
            'tax_query' => array(),
            'meta_query' => array(
                'mec_start_date' => array(
                    'key' => 'mec_start_date',
                ),
                'mec_start_day_seconds' => array(
                    'key' => 'mec_start_day_seconds',
                ),
            ),
            'orderby' => array(
                'mec_start_date' => 'ASC',
                'mec_start_day_seconds' => 'ASC',
            ),
        );

        if (isset($settings['related_events_basedon_category']) && $settings['related_events_basedon_category'] == 1) {
            $post_terms = wp_get_object_terms($event_id, 'mec_category', array('fields' => 'slugs'));
            $related_args['tax_query'][] = array(
                'taxonomy' => 'mec_category',
                'field' => 'slug',
                'terms' => $post_terms
            );
        }

        if (isset($settings['related_events_basedon_organizer']) && $settings['related_events_basedon_organizer'] == 1) {
            $post_terms = wp_get_object_terms($event_id, 'mec_organizer', array('fields' => 'slugs'));
            $related_args['tax_query'][] = array(
                'taxonomy' => 'mec_organizer',
                'field' => 'slug',
                'terms' => $post_terms
            );
        }

        if (isset($settings['related_events_basedon_location']) && $settings['related_events_basedon_location'] == 1) {
            $post_terms = wp_get_object_terms($event_id, 'mec_location', array('fields' => 'slugs'));
            $related_args['tax_query'][] = array(
                'taxonomy' => 'mec_location',
                'field' => 'slug',
                'terms' => $post_terms
            );
        }

        if (isset($settings['related_events_basedon_speaker']) && $settings['related_events_basedon_speaker'] == 1) {
            $post_terms = wp_get_object_terms($event_id, 'mec_speaker', array('fields' => 'slugs'));
            $related_args['tax_query'][] = array(
                'taxonomy' => 'mec_speaker',
                'field' => 'slug',
                'terms' => $post_terms
            );
        }

        if (isset($settings['related_events_basedon_label']) && $settings['related_events_basedon_label'] == 1) {
            $post_terms = wp_get_object_terms($event_id, 'mec_label', array('fields' => 'slugs'));
            $related_args['tax_query'][] = array(
                'taxonomy' => 'mec_label',
                'field' => 'slug',
                'terms' => $post_terms
            );
        }

        if (isset($settings['related_events_basedon_tag']) && $settings['related_events_basedon_tag'] == 1) {
            $post_terms = wp_get_object_terms($event_id, apply_filters('mec_taxonomy_tag', ''), array('fields' => 'slugs'));
            $related_args['tax_query'][] = array(
                'taxonomy' => apply_filters('mec_taxonomy_tag', ''),
                'field' => 'slug',
                'terms' => $post_terms
            );
        }

        // Display Expired Events
        $display_expired_events = (isset($settings['related_events_display_expireds']) && $settings['related_events_display_expireds']);

        $related_args['tax_query']['relation'] = 'OR';
        $related_args = apply_filters('mec_add_to_related_post_query', $related_args, $event_id);

        $now = current_time('timestamp');
        $printed = 0;

        $query = new WP_Query($related_args);
        if ($query->have_posts()) {
            $html .= '<div class="row mec-related-events-wrap">';
            $html .= '<h3 class="mec-rec-events-title">' . esc_html__('Related Events', 'mec') . '</h3>';
            $html .= '<div class="mec-related-events">';
            while ($query->have_posts()) {
                if ($printed >= min($limit, 4)) break;
                $query->the_post();
                // Event Repeat Type
                $repeat_type = get_post_meta(get_the_ID(), 'mec_repeat_type', true);

                $occurrence = date('Y-m-d');
                if (!in_array($repeat_type, array('certain_weekdays', 'custom_days', 'weekday', 'weekend', 'advanced'))) $occurrence = date('Y-m-d', strtotime($occurrence));
                $new_occurrence = date('Y-m-d', strtotime('-1 day', strtotime($occurrence)));
                if (in_array($repeat_type, array('monthly')) and date('m', strtotime($new_occurrence)) != date('m', strtotime($occurrence))) $new_occurrence = date('Y-m-d', strtotime($occurrence));

                $occurrence = $new_occurrence;

                $main = new \MEC_Main();
                $render = $main->getRender();

                $dates = $render->dates(get_the_ID(), NULL, 1, $occurrence);
                $d = (isset($dates[0]) ? $dates[0] : array());

                // Don't show Expired Events
                $timestamp = (isset($d['start']) and isset($d['start']['timestamp'])) ? $d['start']['timestamp'] : 0;
                if ($display_expired_events or $timestamp <= 0 or $timestamp > $now) {

                    $printed += 1;
                    $mec_date = (isset($d['start']) and isset($d['start']['date'])) ? $d['start']['date'] : get_post_meta(get_the_ID(), 'mec_start_date', true);
                    $date = $main->date_i18n(get_option('date_format'), strtotime($mec_date));

                    $event_link = $main->get_event_date_permalink(get_the_permalink(), $mec_date);

                    // Custom Link
                    $read_more = get_post_meta(get_the_ID(), 'mec_read_more', true);
                    $read_more_occ_url = MEC_feature_occurrences::param(get_the_ID(), $timestamp, 'read_more', $read_more);

                    if ($read_more_occ_url and filter_var($read_more_occ_url, FILTER_VALIDATE_URL)) $event_link = $read_more_occ_url;

                    $html .= '<article class="mec-related-event-post col-md-3 col-sm-3">';
                    $html .= '<figure>';
                    $html .= '<a href="' . esc_url($event_link) . '">';
                    if (get_the_post_thumbnail(get_the_ID(), 'thumblist')) $html .= get_the_post_thumbnail(get_the_ID(), 'thumblist');
                    else $html .= '<img src="' . esc_url($main->asset('img/no-image.png')) . '" />';
                    $html .= '</a>';
                    $html .= '</figure>';
                    $html .= '<div class="mec-related-event-content">';
                    $html .= '<span>' . esc_html($date) . '</span>';
                    $html .= '<h5>';
                    $html .= '<a class="mec-color-hover" href="' . esc_url($event_link) . '">' . get_the_title() . '</a>';
                    if ($display_expired_events && $timestamp && $timestamp < $now) {
                        $html .= '<span class="mec-holding-status mec-holding-status-expired">' . esc_html(translate('Expired!', 'mec')) . '</span>';
                    }
                    $html .= '</h5>';
                    $html .= '</div>';
                    $html .= '</article>';
                }
            }
            $html .= '</div>';
            $html .= '</div>';
        }

        wp_reset_postdata();

        return $html;
    }

    /**
     * Is editor mode
     *
     * @return boolean
     */
    public
    function is_editor_mode()
    {
        if (strstr($_SERVER['REQUEST_URI'], '/wp-json/gsb/v1/event')) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Load Template MEC GSB and Styles Blocks
     *
     * @since    1.0.0
     */
    public
    function gsb_single($id)
    {
        //get mec-gsb
        $mainClass = new \MEC_main();
        $set = $mainClass->get_settings();
        $single_template_gsb = null;

        $single_view_post = get_post_meta($id, 'single_gsb_design_page', true);

        if (isset($single_view_post) && $single_view_post != "-1" && $single_view_post != "") {
            $post_id = $single_view_post;
        } else {
            $post_id = (isset($set['single_single_default_gutenberg_builder']) && $set['single_single_default_gutenberg_builder']) ? $set['single_single_default_gutenberg_builder'] : 0;
        }

        if ($post_id != null && $post_id != 0) {
            $single_template_gsb = (array)get_post($post_id);
        } else {
            $args = array(
                'numberposts' => '1',
                'orderby' => 'post_date',
                'order' => 'DESC',
                'post_type' => 'mec_gsb',
                'post_status' => 'publish'
            );
            $recent_posts = wp_get_recent_posts($args);
            foreach ($recent_posts as $recent) {
                $single_template_gsb = $recent;
            }
        }

        //Styles Blocks GSB
        $styles = get_metadata(
            'post',
            $single_template_gsb["ID"],
            '_webnus_sm_ready_style',
            false
        );

        if (count($styles) > 0) {
            echo '<style>' . $styles[0] . '</style>';
        }

        //Load Data Event into mec-gsb
        if ($single_template_gsb != null) {
            //Get Content Rendering
            //echo apply_filters('the_content', $single_template_gsb["post_content"]);
            echo do_shortcode(do_blocks($single_template_gsb["post_content"]));
        } else {
            echo '<div>Not Found MEC Gutenberg Single Builder</div> ';
        }

    }

    /**
     * Render Event Description MetaBox
     * @param object $post
     */
    public
    function sb_metabox($post)
    {
        $mainClass = new \MEC_main();
        $set = $mainClass->get_settings();
        if (isset($set['single_single_style']) and $set['single_single_style'] != 'gsb-builder') {
            return;
        }
        add_meta_box(
            'mec_sb_choose_single_page',
            'Gutenberg Single',
            [$this, 'renderEventDescriptionMetaBox'],
            'mec-events',
            'side',
            'default'
        );
    }

    /**
     * Render Event Description MetaBox
     * @param object $post
     */
    public
    function renderEventDescriptionMetaBox($post)
    {
        $mainClass = new \MEC_main();
        $set = $mainClass->get_settings();
        $builders = get_posts([
            'post_type' => 'mec_gsb',
            'posts_per_page' => -1
        ]);
        ?>
        <?php if (isset($set['single_single_style']) and $set['single_single_style'] != 'gsb-builder') : ?>
        <label class="other-type-of-builder-title"><?php _e($set['single_single_style'] . ' Style', 'mec-gsb'); ?></label>
    <?php else : ?>
        <label class="post-attributes-label"><?php _e('Event single view', 'mec-gsb'); ?></label>
        <div class="mec-form-row" id="mec_organizer_gateways_form_container">
            <select name="mec[single_gsb_design_page]" id="single_gsb_design_page">
                <option value="-1"><?php echo __('Select'); ?></option>
                <?php
                $selected_view = get_post_meta($post->ID, 'single_gsb_design_page', true);
                foreach ($builders as $builder) {
                    $selected = $builder->ID == $selected_view ? ' selected="selected"' : '';
                    echo '<option value="' . $builder->ID . '"' . $selected . '>' . $builder->post_title . '</option>';
                }
                ?>
            </select>
        </div>
    <?php endif; ?>
        <div class="mec-gsb-metabox-footer">
            <a href="<?php echo admin_url('admin.php?page=MEC-settings&tab=MEC-single'); ?>" target="_blank"
               class="button mec-settings-btn"><?php echo __('Settings', 'mec-gsb'); ?></a>
            <?php if (isset($set['single_single_style']) and $set['single_single_style'] == 'gsb-builder') : ?>
                <a href="<?php echo admin_url('post-new.php?post_type=mec_gsb'); ?>"
                   class="taxonomy-add-new">+ <?php echo __('Build new Single Design', 'mec-gsb'); ?></a>
            <?php endif; ?>
        </div>
        <?php
    }

    /**
     * Return event gallery html
     *
     * @param int $event_id
     * @param array $atts
     *
     * @return string
     */
    public
    static function get_event_gallery_html($event_id, $atts = array())
    {

        return \MEC\SingleBuilder\SingleBuilder::getInstance()->output('event-gallery', $event_id, $atts);
    }

    /**
     * Save event data
     *
     * @param int $post_id
     * @return void
     * @author Webnus <info@webnus.biz>
     */
    public
    static function save_event($post_id)
    {

        // Check if our nonce is set.
        if (!isset($_POST['mec_event_nonce'])) {
            return;
        }

        // Verify that the nonce is valid.
        if (!wp_verify_nonce($_POST['mec_event_nonce'], 'mec_event_data')) {
            return;
        }
        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if (defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) {
            return;
        }

        $_mec = isset($_POST['mec']) ? $_POST['mec'] : array();
        if (!$_mec) {
            return;
        }

        if (isset($_mec['single_gsb_design_page'])) {
            update_post_meta($post_id, 'single_gsb_design_page', $_mec['single_gsb_design_page']);
        }
    }

    /**
     * Register all of the hooks related to the public-facing functionality
     * of the plugin.
     *
     * @access    private
     */
    private
    static function define_public_hooks()
    {
        include_once(ABSPATH . 'wp-admin/includes/plugin.php');

        if (is_plugin_active('modern-events-calendar/mec.php') || is_plugin_active('modern-events-calendar-lite/modern-events-calendar-lite.php')) {
            add_filter('template_include', function ($original) {
                $mainClass = new \MEC_main();
                $set = $mainClass->get_settings();
                if (isset($set['single_single_style']) && $set['single_single_style'] == 'gsb-builder') {
                    $PT = $mainClass->get_main_post_type();
                    $baseClass = new \MEC_parser();
                    $file = $baseClass->getFile();

                    if (is_single() and get_post_type() == $PT) {
                        $template = locate_template('single-' . $PT . '.php');
                        if ($template == '') {
                            $wp_template = get_template();
                            $wp_stylesheet = get_stylesheet();

                            $wp_template_file = MECGSBABSPATH . DS . 'templates' . DS . 'themes' . DS . $wp_template . DS . 'single-mec-events.php';
                            $wp_stylesheet_file = MECGSBABSPATH . DS . 'templates' . DS . 'themes' . DS . $wp_template . DS . 'childs' . DS . $wp_stylesheet . DS . 'single-mec-events.php';

                            if ($file->exists($wp_stylesheet_file)) $template = $wp_stylesheet_file;
                            elseif ($file->exists($wp_template_file)) $template = $wp_template_file;
                            else $template = MECGSBABSPATH . DS . 'core' . DS . 'templates' . DS . 'single-mec-events.php';
                            return $template;
                        }
                    }
                    return $original;
                }
            }, 99999999999);
        }
        add_filter('mec_get_event_id_for_widget', [__CLASS__, 'filter_get_event_id_for_widget'], 10, 2);
    }

    public
    static function filter_get_event_id_for_widget($event_id, $is_editor_mode)
    {

        if (!$is_editor_mode) {

            if (!$event_id && wp_doing_ajax()) {

                return get_the_ID();
            }

            return $event_id;
        }

        $custom_event_id = (int)\MEC\Settings\Settings::getInstance()->get_settings('custom_event_for_set_settings');
        if ($custom_event_id) {

            return $custom_event_id;
        }

        return $event_id;
    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public
    function init()
    {
        if (!class_exists('\MEC_GSB\Autoloader')) {
            return;
        }
    }

} //MecGSB
