<?php
/**
 * Gutenberg.
 *
 * @package MEC_GSB
 */

namespace MEC_GSB\Core\Gutenberg;


if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * Class Gutenberg.
 */
class Gutenberg {

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 *
	 * @var     Gutenberg
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 *
	 * @return  object
	 */
	public static function get_instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	private function __construct() {
		$this->hooks();
	}

	/**
	 * Init hooks.
	 *
	 * @since 1.0.0
	 */
	private function hooks() {
		add_action( 'enqueue_block_editor_assets', array( $this, 'editor_assets' ) );
    }

	/**
	 * enqueue editor assets.
	 *
	 * @since 1.0.0
	 */
	public function editor_assets() {
		$script_dep_path = MECGSB_PATH . 'build/blocks.asset.php';
        $script_info     = file_exists( $script_dep_path )
            ? include $script_dep_path
            : array(
                'dependencies' => array(),
                'version'      => '1.0.0',
            );
        if ( version_compare( get_bloginfo( 'version' ), '5.8', '<' ) ) {
            $script_dep = array_merge( $script_info['dependencies'], array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-components', 'wp-editor', 'wp-api-fetch' ) );
        } else {
            $script_dep = $script_info['dependencies'];
        }

        wp_enqueue_script(
            'mec-gsb-block-editor-js',
            MECGSB_URL . 'build/blocks.js',
            $script_dep,
            $script_info['version'],
            true
        );

        wp_set_script_translations( 'mec-gsb-block-editor-js', 'mec_gsb' );

        wp_enqueue_style(
            'mec-gsb-block-editor-css',
            MECGSB_URL . 'build/blocks.css',
            array( 'wp-edit-blocks' ),
            '1.0.0'
        );

	}
}

Gutenberg::get_instance();
