module.exports = function (grunt) {
	// Project configuration.
	grunt.initConfig({
		sass: {
			dist: {
				options: {
					style: 'compressed',
					sourceMap: true,
				},
				files: {
					'../../../css/admin/gutenberg.css':
						'src/scss/admin/gutenberg.scss',
					'../../../css/editor.css':
						'src/scss/editor.scss',
				},
			},
		},
		watch: {
			scss: {
				files: '**/*.scss',
				tasks: ['sass'],
			},
		},
	});

	// Load the plugins.
	grunt.loadNpmTasks('grunt-contrib-sass');
	grunt.loadNpmTasks('grunt-contrib-watch');

	// Default task(s).
	grunt.registerTask('default', ['sass']);

	// Package task(s).
	grunt.registerTask('package', ['sass']);
};
