/**
 * Class InputControl
 */

import { BaseControl } from  './base-control';

const {
	ColorPalette,
	SelectControl,
	RangeControl
} = wp.components;

const { __ } = wp.i18n;

const {
	select
} = wp.data;

class BoxShadow extends BaseControl {

	constructor( args ) {
		super( args );
	}

	setDefaultArgs() {
		let settings = select('core/block-editor').getSettings();

		this.args = {
			class_name: 'webnus-st-shadow-control',
			label: '',
			separator: 'none',
			hide_label_from_vision: false,
			help: '',
			style: [
				{ label: __( 'None', 'webnus-styles-manager' ), value: 'none' },
				{ label: __( 'Outer', 'webnus-styles-manager' ), value: '' },
				{ label: __( 'Inset', 'webnus-styles-manager' ), value: 'inset' },
			],
			horizontal: 0,
			vertical: 0,
			blur: 0,
			spread: 0,
			colors: settings.colors,
			disable_custom_colors: false,
			clearable: true,
			disable_style:false,
			disable_color:false,
		};

		this.defaultValue = {
			style: 'none',
			horizontal: 0,
			vertical: 0,
			blur: 0,
			spread: 0,
			color: '',
		};
	}

	setDefaultAttribut(){
		this.attributes = {
			default: {
				value: {
					style: 'none',
					horizontal: 0,
					vertical: 0,
					blur: 0,
					spread: 0,
					color: '',
				}
			},
			type: 'object',
		}
	}

	beforeSetValue( value, id ) {
		for ( let key in value ) {
			switch( key ){
				case "width":
					for ( let option in value[ key ] ) {
						if( null === value[ key ][ option ] ){
							value[key][ option ] = '0px';
						}
					}
					break;
			}
		}

		return value;
	}

	renderControl(){
		let {
			style,
			colors,
			disable_custom_colors,
			clearable,
			disable_style,
			disable_color,
		} = this.args;

		let value = Object.assign( {}, this.defaultValue, this.getValue() );

		return (
			<div className={'webnus-st-shadow-options'} >
				{ ! disable_style &&
				<div key={ 'shadow-type' } className={'webnus-st-shadow-type'}>
					<SelectControl
						value = { value.style }
						onChange = { ( newValue ) => {
							this.setValue( { style: newValue } );
						} }
						options = { style }
						label = { __( 'Shadow Type', 'webnus-styles-manager' ) }
						labelPosition = { 'side' }
					/>
				</div>
				}
				{ 'none' !== value.style &&
				<div key={ 'text-shadow-horizontal' } className={'webnus-st-text-shadow-horizontal'}>
					<RangeControl
						label="Horizontal"
						help=""
						step={0.1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Horizontal Shadow" }
						value={ value.horizontal }
						onChange={  ( newValue ) => {
							this.setValue( { horizontal: newValue } );
						} }
						min={0}
					/>
				</div>
				}
				{ 'none' !== value.style &&
				<div key={ 'text-shadow-vertical' } className={'webnus-st-text-shadow-vertical'}>

					<RangeControl
						label="Vertical"
						help=""
						step={0.1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Vertical Shadow" }
						value={ value.vertical }
						onChange={  ( newValue ) => {
							this.setValue( { vertical: newValue } );
						} }
						min={ 0 }
					/>
				</div>
				}
				{ 'none' !== value.style &&
				<div key={ 'text-shadow-blur' } className={'webnus-st-text-shadow-blur'}>

					<RangeControl
						label="Blur"
						help=""
						step={0.1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Blur Shadow" }
						value={ value.blur }
						onChange={  ( newValue ) => {
							this.setValue( { blur: newValue } );
						} }
						min={ 0 }
					/>
				</div>
				}
				{ 'none' !== value.style &&
				<div key={ 'text-shadow-spread' } className={'webnus-st-text-shadow-spread'}>

					<RangeControl
						label="Spread"
						help=""
						step={0.1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Spread Shadow" }
						value={ value.spread }
						onChange={  ( newValue ) => {
							this.setValue( { spread: newValue } );
						} }
						min={ 0 }
					/>
				</div>
				}
				{ 'none' !== value.style && ! disable_color &&
				<div key={ 'shadow-color' } className={'webnus-st-shadow-color'}>
					<p className='component-box-control__label'>{ __( 'Shadow Color', 'webnus-styles-manager' ) }</p>
					<ColorPalette
						value={ value.color }
						colors={ colors }
						disableCustomColors={ disable_custom_colors }
						clearable={ clearable }
						onChange={ ( newValue ) => {
							this.setValue( { color: newValue } );
						} }
					/>
				</div>
				}
			</div>
		);
	}
}

export { BoxShadow };
