/**
 * Class InputControl
 */

import { BaseControl } from  './base-control';

const {
	SelectControl,
	RangeControl
} = wp.components;

const { __ } = wp.i18n;

const {
	select
} = wp.data;

class Position extends BaseControl {

	constructor( args ) {
		super( args );
	}

	setDefaultArgs() {
		let settings = select('core/block-editor').getSettings();

		this.args = {
			class_name: 'webnus-st-position-control',
			label: '',
			separator: 'none',
			hide_label_from_vision: false,
			help: '',
			colors: settings.colors,
			style: [
				{ label: __( 'None', 'webnus-styles-manager' ), value: null },
				{ label: __( 'Static', 'webnus-styles-manager' ), value: 'static' },
				{ label: __( 'Absolute', 'webnus-styles-manager' ), value: 'absolute' },
				{ label: __( 'Fixed', 'webnus-styles-manager' ), value: 'fixed' },
				{ label: __( 'Relative', 'webnus-styles-manager' ), value: 'relative' },
				{ label: __( 'Sticky', 'webnus-styles-manager' ), value: 'sticky' },
				{ label: __( 'Initial', 'webnus-styles-manager' ), value: 'initial' },
				{ label: __( 'Inherit', 'webnus-styles-manager' ), value: 'inherit' },
			],
		};
		this.defaultValue = {
			style: null,
			top: 0,
			left: 0,
			bottom: 0,
			right: 0,
			zindex: 0,
		};
	}

	setDefaultAttribut(){
		this.attributes = {
			default: {
				style: null,
				top: 0,
				left: 0,
				bottom: 0,
				right: 0,
				zindex: 0,
			},
			type: 'object',
		}
	}

	beforeSetValue( value, id ) {
		return value;
	}

	renderControl(){
		let {
			style,
			disable_style,
		} = this.args;

		let value = Object.assign( {}, this.defaultValue, this.getValue() );
		return (
			<div className={'webnus-st-position-options'} >
				{ ! disable_style &&
				<div key={ 'position-type' } className={'webnus-st-position-type'}>
					<SelectControl
						value = { value.style }
						onChange = { ( newValue ) => {
							this.setValue( { style: newValue } );
						} }
						options = { style }
						label = { __( 'Position Type', 'webnus-styles-manager' ) }
						labelPosition = { 'side' }
					/>
				</div>
				}
				{ null !== value.style &&
				<div key={ 'position-top' } className={'webnus-st-position-top'}>
					<RangeControl
						label="Top"
						help=""
						step={1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Position Top" }
						value={ value.top }
						onChange={  ( newValue ) => {
							this.setValue( { top: newValue } );
						} }
						min={ -2000 }
						max={ 2000 }
					/>
				</div>
				}
				{ null !== value.style &&
				<div key={ 'position-left' } className={'webnus-st-position-left'}>

					<RangeControl
						label="Left"
						help=""
						step={1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Position Left" }
						value={ value.left }
						onChange={  ( newValue ) => {
							this.setValue( { left: newValue } );
						} }
						min={ -2000 }
						max={ 2000 }
					/>
				</div>
				}
				{ null !== value.style &&
				<div key={ 'position-bottom' } className={'webnus-st-position-bottom'}>

					<RangeControl
						label="Bottom"
						help=""
						step={1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Position Bottom" }
						value={ value.bottom }
						onChange={  ( newValue ) => {
							this.setValue( { bottom: newValue} );
						} }
						min={ -2000 }
						max={ 2000 }
					/>
				</div>
				}
				{ null !== value.style &&
				<div key={ 'position-right' } className={'webnus-st-position-right'}>

					<RangeControl
						label="Right"
						help=""
						step={1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Position Right" }
						value={ value.right }
						onChange={  ( newValue ) => {
							this.setValue( { right: newValue} );
						} }
						min={ -2000 }
						max={ 2000 }
					/>
				</div>
				}
				{ null !== value.style &&
				<div key={ 'position-zindex' } className={'webnus-st-position-zindex'}>

					<RangeControl
						label="Z-Index"
						help=""
						step={1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Position Z-Index" }
						value={ value.zindex }
						onChange={  ( newValue ) => {
							this.setValue( { zindex: newValue} );
						} }
						min={ 0 }
						max={ 999999999 }
					/>
				</div>
				}
			</div>
		);
	}
}

export { Position };
