/**
 * Class InputControl
 */

import { BaseControl } from  './base-control';

const {
	ColorPalette,
	RangeControl
} = wp.components;

const { __ } = wp.i18n;

const {
	select
} = wp.data;

class TextShadow extends BaseControl {

	constructor( args ) {
		super( args );
	}

	setDefaultArgs() {
		let settings = select('core/block-editor').getSettings();

		this.args = {
			class_name: 'webnus-st-text-shadow-control',
			label: '',
			separator: 'none',
			hide_label_from_vision: false,
			help: '',
			colors: settings.colors,
			disable_custom_colors: false,
			clearable: true,
			disable_color:false,
		};

		this.defaultValue = {
			horizontal: 0,
			vertical: 0,
			blur: 0,
			color: '',
		};
	}

	setDefaultAttribut(){
		this.attributes = {
			default: {
				value: {
					horizontal: 0,
					vertical: 0,
					blur: 0,
					color: '',
				}
			},
			type: 'object',
		}
	}

	// beforeSetValue( value, id ) {
	// 	for ( let key in value ) {
	// 		switch( key ){
	// 			case "horizontal_unit":
	// 			case "vertical_unit":
	// 			case "blur_unit":
	// 				for ( let option in value[ key ] ) {
	// 					if( null === value[ key ][ option ] ){
	// 						value[key][ option ] = 0;
	// 					}
	// 				}
	// 				break;
	// 		}
	// 	}
	//
	// 	return value;
	// }

	renderControl(){
		let {
			colors,
			disable_custom_colors,
			clearable,
			disable_color,
		} = this.args;

		let value = Object.assign( {}, this.defaultValue, this.getValue() );

		return (
			<div className={'webnus-st-text-shadow-options'} >
				{ 'none' !== value.style &&
				<div key={ 'text-shadow-horizontal' } className={'webnus-st-text-shadow-horizontal'}>
					<RangeControl
						label="Horizontal"
						help=""
						step={0.1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Horizontal Shadow" }
						value={ value.horizontal }
						onChange={  ( newValue ) => {
							this.setValue( { horizontal: newValue } );
						} }
						min={0}
					/>
				</div>
				}
				{ 'none' !== value.style &&
				<div key={ 'text-shadow-vertical' } className={'webnus-st-text-shadow-vertical'}>

					<RangeControl
						label="Vertical"
						help=""
						step={0.1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Vertical Shadow" }
						value={ value.vertical }
						onChange={  ( newValue ) => {
							this.setValue( { vertical: newValue } );
						} }
						min={ 0 }
					/>
				</div>
				}
				{ 'none' !== value.style &&
				<div key={ 'text-shadow-blur' } className={'webnus-st-text-shadow-blur'}>

					<RangeControl
						label="Blur"
						help=""
						step={0.1}
						withInputField={true}
						separatorType="none"
						trackColor="#07BBE9"
						railColor="#E3E5E7"
						renderTooltipContent={ () => "Blur Shadow" }
						value={ value.blur }
						onChange={  ( newValue ) => {
							this.setValue( { blur: newValue } );
						} }
						min={ 0 }
					/>
				</div>
				}
				{ 'none' !== value.style && ! disable_color &&
				<div key={ 'text-shadow-color' } className={'webnus-st-text-shadow-color'}>
					<p className='component-box-control__label'>{ __( 'Text Shadow Color', 'webnus-styles-manager' ) }</p>
					<ColorPalette
						value={ value.color }
						colors={ colors }
						disableCustomColors={ disable_custom_colors }
						clearable={ clearable }
						onChange={ ( newValue ) => {
							this.setValue( { color: newValue } );
						} }
					/>
				</div>
				}
			</div>
		);
	}
}

export { TextShadow };
