var path = require('path');
var webpack = require('webpack');

module.exports = {
	entry: {
		webnus_sm_gb: './src/main.js',
	},
	output: {
		path: __dirname,
		filename: 'webnus-sm-gb.js',
	},
	watch: true,
	module: {
		rules: [{
			test: /\.(js|jsx|mjs)$/,
			exclude: /(node_modules|bower_components)/,
			use: {
				loader: 'babel-loader',
			},
		}
		],
	},
	resolve: {
		modules: [
			path.resolve(__dirname, 'src'),
			'node_modules'
		],
	}
};

if (process.env.NODE_ENV === 'production') {
	module.exports.plugins = (module.exports.plugins || []).concat([
		new webpack.DefinePlugin({
			'process.env': {
				NODE_ENV: '"production"'
			}
		}),
		new webpack.optimize.UglifyJsPlugin({
			sourceMap: false,
			compress: {
				warnings: false
			}
		}),
		new webpack.LoaderOptionsPlugin({
			minimize: true
		})
	])
}
