(function( $ ) {

	'use strict';

	window.WebnusSM = {
		modal: null,
		currentElement: null,
		init: function() {

			$( document )
				.on( 'click', '.webnus-sm-popup-close', WebnusSM.hidePopup )
				.on( 'click', '#webnus-sm-save-skin', WebnusSM.saveSkin )
				.on( 'click', '.webnus-sm-apply-skin', WebnusSM.applySkin )
				.on( 'click', '.webnus-sm-delete-skin', WebnusSM.deleteSkin );

			window.elementor.hooks.addFilter( 'elements/widget/contextMenuGroups', function( groups, element ) {

				try {

					if ( -1 !== element.options.model.attributes.widgetType.search('webnus-') ) {

						groups.push( {
							name: 'webnus_sm_skins',
							actions: [{
								name: 'webnus_sm_skins_save',
								icon: 'eicon-save',
								title: 'Save as Skin',
								isVisible: true,
								callback: WebnusSM.showSkinsPopup.bind( {
									element: element,
								} )
							}, {
								name: 'webnus_sm_skins_apply',
								icon: 'eicon-arrow-down',
								title: 'Apply Skin',
								isVisible: true,
								callback: WebnusSM.applySkinPopup.bind( { element: element } )
							}, {
								name: 'webnus_sm_skins_reset',
								icon: 'eicon-close',
								title: 'Reset Skin',
								isVisible: true,
								callback: WebnusSM.resetSkin.bind( { element: element } )
							}]
						} );

					}

				} catch (e) {
					console.log( e, element );
					return groups;
				}

				return groups;
			} );

			window.elementor.on( 'preview:loaded', function() {

				if ( ! window.WebnusSMRenderedSkins.length ) {
					return;
				}

				var $previewBody = window.elementor.$preview.contents();

				$.ajax({
					url: window.ajaxurl,
					type: 'POST',
					dataType: 'json',
					data: {
						action: 'webnus_sm_load_skins_css',
						skins: JSON.stringify( window.WebnusSMRenderedSkins ),
					},
				}).done( function( response ) {
					$previewBody.find( 'head' ).append( response.data.css );
				}).fail( function() {
					// TODO: show error
				});

				window.WebnusSMRenderedSkins.forEach( function( element ) {
					$previewBody.find( 'div[data-id="' + element.id + '"]' ).addClass( element.class_name );
				} );

			} );

		},
		removeSkinClass: function( $el ) {

			var classes = $el.attr( 'class' ).split( /\s+/ );

			classes.forEach( function( className ) {
				if ( className.includes( 'elementor-element-skin-' ) ) {
					$el.removeClass( className );
				}
			} );
		},
		resetSkin: function() {
			var editModel = this.element.getEditModel(),
				skin      = editModel.getSetting( 'webnus_sm_skin' );

			if ( ! skin ) {
				return;
			}

			WebnusSM.removeSkinClass( this.element.$el );
			window.elementor.saver.setFlagEditorChange( true );

		},
		getModal: function() {

			if ( ! this.modal ) {

				this.modal = window.elementor.dialogsManager.createWidget( 'lightbox', {
					id: 'webnus-sm-skins-modal',
					closeButton: true
				} );

				this.modal.setHeaderMessage( '<div class="webnus-sm-popup-close elementor-templates-modal__header__close elementor-templates-modal__header__close--normal elementor-templates-modal__header__item"><i class="eicon-close" aria-hidden="true" title="Close"></i><span class="elementor-screen-only">Close</span></div>' );
			}

			return this.modal;

		},
		saveSkin: function() {

			if ( ! WebnusSM.currentElement ) {
				// TODO: show error
				return;
			}

			var skinName = $( '#webnus-sm-skin-name' ).val(),
				settings = WebnusSM.currentElement.controlsCSSParser.getSettings(),
				values   = settings.settingsModel.attributes,
				widget   = WebnusSM.currentElement.model.attributes.widgetType;

			for ( var control in values ) {
				if ( values[ control ].model && values[ control ].models ) {
					delete( values[ control ] );
				}
			}

			$.ajax({
				url: window.ajaxurl,
				type: 'POST',
				dataType: 'json',
				data: {
					action: 'webnus_sm_save_skin',
					name: skinName,
					widget: widget,
					values: JSON.stringify( values ),
				},
			}).done( function() {
				WebnusSM.hidePopup();
			}).fail( function() {
				// TODO: show error
			});

		},
		deleteSkin: function() {

			if ( ! WebnusSM.currentElement ) {
				// TODO: show error
				return;
			}

			var $button  = $( this ),
				skinName = $button.attr( 'data-skin' );

			$.ajax({
				url: window.ajaxurl,
				type: 'POST',
				dataType: 'json',
				data: {
					action: 'webnus_sm_delete_skin',
					name: skinName,
					widget: WebnusSM.currentElement.model.attributes.widgetType,
				},
			}).done( function( response ) {
				if ( response.success ) {
					var modal = WebnusSM.getModal();

					if ( response.success ) {
						modal.setMessage( WebnusSM.getModalMessage( response.data.skins ) );
					}
				}
			}).fail( function() {
				// TODO: show error
			});

		},
		applySkin: function() {

			if ( ! WebnusSM.currentElement ) {
				// TODO: show error
				return;
			}

			var $button  = $( this ),
				skinName = $button.attr( 'data-skin' );

			$.ajax({
				url: window.ajaxurl,
				type: 'POST',
				dataType: 'json',
				data: {
					action: 'webnus_sm_apply_skin',
					name: skinName,
					widget: WebnusSM.currentElement.model.attributes.widgetType,
				},
			}).done( function( response ) {
				if ( response.success ) {

					var editModel = window.WebnusSM.currentElement.getEditModel();

					editModel.setSetting( {
						webnus_sm_skin: skinName,
					} );

					WebnusSM.removeSkinClass( WebnusSM.currentElement.$el );
					WebnusSM.currentElement.el.classList.add( response.data.class_name );

					window.elementor.$preview.contents().find( 'head' ).append( response.data.css );
					window.elementor.saver.setFlagEditorChange( true );

					WebnusSM.hidePopup();
				}
			}).fail( function() {
				// TODO: show error
			});

		},
		hidePopup: function() {
			WebnusSM.currentElement = null;
			WebnusSM.getModal().hide();
			WebnusSM.getModal().setMessage( '' );
		},
		showSkinsPopup: function() {

			var modal = WebnusSM.getModal();

			WebnusSM.currentElement = this.element;

			modal.setMessage( '<div class="webnus-sm-save-skin"><div class="webnus-sm-popup-actions"><div class="webnus-sm-popup-heading">Save current widget styling as skin</div><div class="webnus-sm-popup-sub-heading">You\'ll be able to apply this skin to any widget of the same type.</div></div><input type="text" id="webnus-sm-skin-name"><button id="webnus-sm-save-skin" class="elementor-button elementor-button-success"><span class="elementor-state-icon"><i class="eicon-loading eicon-animation-spin" aria-hidden="true"></i></span>Save</button></div>' );

			modal.show();

		},
		applySkinPopup: function() {

			var modal = WebnusSM.getModal();

			WebnusSM.currentElement = this.element;

			modal.setMessage( '<div class="webnus-sm-skins__loading">Loading skins...</div>' );
			modal.show();

			$.ajax({
				url: window.ajaxurl,
				type: 'GET',
				dataType: 'json',
				data: {
					action: 'webnus_sm_get_skins_for_widget',
					widget: WebnusSM.currentElement.model.attributes.widgetType,
				},
			}).done( function( response ) {
				if ( response.success ) {
					modal.setMessage( WebnusSM.getModalMessage( response.data.skins ) );
				}
				modal.refreshPosition();
			}).fail( function() {
				// TODO: show error
			});

		},
		getModalMessage: function( skins ) {

			var modalMessage = null;

			modalMessage = '<div class="webnus-sm-skins">';

			if ( skins.length ) {
				modalMessage += '<table class="webnus-sm-skins__table"><thead><tr><th>Name</th><th>Actions</th></tr></thead><tbody>';

				skins.forEach( function( skin ) {
					modalMessage += '<tr><td>' + skin.skin + '</td><td><button type="button" class="elementor-button elementor-button-success webnus-sm-apply-skin" data-skin="' + skin.skin + '">Apply</button><a href="#" class="webnus-sm-delete-skin" data-skin="' + skin.skin + '">Delete</a></td></tr>';
				});

				modalMessage += '</tbody></table>';
			} else {
				modalMessage += '<div class="webnus-sm-skins__not-found">No skins found for this widget</div>';
			}

			modalMessage += '</div>';

			return modalMessage;
		},
	};

	$( window ).on( 'elementor:init', WebnusSM.init );

})( jQuery );
