<?php

/**
 *    Plugin Name: Gutenberg Single Builder for MEC
 *    Plugin URI: http://webnus.net/modern-events-calendar/
 *    Description: Use this Add-on to build your single in Gutenberg Editor. It allows you to use many different type of fields and rearrange them by drag and drop and modify their styles.
 *    Version: 1.1.6
 *    Text Domain: mec-gsb
 *    Domain Path: /languages
 *    Author URI: http://webnus.net
 **/

namespace MEC_GSB;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * Base.
 *
 * @author     author
 * @package     package
 * @since     1.0.0
 */
class Base
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_GSB
     */
    public static $instance;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @return  object
     * @since   1.0.0
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        register_activation_hook(__FILE__, [$this, 'activate_gsb']);
        register_deactivation_hook(__FILE__, [$this, 'deactivate_gsb']);
        self::settingUp();
        self::preLoad();
        self::setHooks($this);
        add_filter('block_categories_all', [$this, 'mec_gsb_block_category'], 99, 1);
        do_action('MEC_GSB_init');
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        define('MECGSBVERSION', '1.1.6');
        define('MECGSBDIR', plugin_dir_path(__FILE__));
        define('MECGSBURL', plugin_dir_url(__FILE__));
        define('MECGSBDASSETS', MECGSBURL . 'assets/');
        define('MECGSBNAME', 'Gutenberg Single Builder');
        define('MECGSBSLUG', 'mec-gutenberg-single-builder');
        define('MECGSBOPTIONS', 'mec_gsb_options');
        define('MECGSBTEXTDOMAIN', 'mec-gsb');
        define('MECGSB_PATH', plugin_dir_path(__FILE__) . '/');
        define('MECGSB_URL', plugin_dir_url(__FILE__) . '/');
        define('MECGSBMAINFILEPATH', __FILE__);
        define('MECGSBABSPATH', dirname(__FILE__));

        if (!defined('DS')) {
            define('DS', DIRECTORY_SEPARATOR);
        }
    }

    /**
     * Set Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks($This)
    {
        add_action('plugins_loaded', [$This, 'addon_load_text_domain']);
    }

    /**
     * Add Block Category
     */
    public function mec_gsb_block_category($categories)
    {
        // setup category array
        $gsb_category = [
            'slug' => 'mec-gsb-blocks',
            'title' => 'MEC Event Blocks'
        ];

        // make a new category array and insert ours at position 1
        $new_categories = [];
        $new_categories[0] = $gsb_category;

        // rebuild cats array
        foreach ($categories as $category) {
            $new_categories[] = $category;
        }

        return $new_categories;
    }

    /**
     * Load plugin textdomain.
     */
    public function addon_load_text_domain()
    {
        load_plugin_textdomain('mec-gsb', false, dirname(plugin_basename(__FILE__)) . '/languages');
    }

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        require_once MECGSB_PATH . 'includes/webnus-style-manager/webnus-style-manager.php';
        include_once MECGSBDIR . DS . 'core' . DS . 'autoloader.php';
    }

    public function activate_gsb()
    {
        $options = get_option('mec_options');
        if (!$options) {
            return;
        }

        $options['tab-settings']['single_single_style'] = 'gsb-builder';

        $mainClass = new \MEC_main();
        $set = $mainClass->get_settings();
        $single_template_gsb = null;
        $post_id = (isset($set['single_single_default_gutenberg_builder']) && $set['single_single_default_gutenberg_builder']) ? $set['single_single_default_gutenberg_builder'] : 0;
        if ($post_id != null && $post_id != 0) {
        } else {
            $args = array(
                'numberposts' => '1',
                'orderby' => 'post_date',
                'order' => 'DESC',
                'post_type' => 'mec_gsb',
                'post_status' => 'publish'
            );
            $recent_posts = wp_get_recent_posts($args);
            foreach ($recent_posts as $recent) {
                $single_template_gsb = $recent;
            }
            $options['tab-settings']['single_single_default_gutenberg_builder'] = $single_template_gsb["ID"];
        }
        update_option('mec_options', $options);
        update_option('gsb_show_setup_popup', true);
    }

    public function deactivate_gsb()
    {
        $options = get_option('mec_options');
        if (!$options) {
            return;
        }

        $options['tab-settings']['single_single_style'] = 'default';
        update_option('mec_options', $options);
        update_option('gsb_show_setup_popup', false);
    }
} //Base

Base::instance();
