import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [attendees,setAttendees] = useState("");
	useEffect(() => {
		const getAttendees = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "attendees" },
			} ).then( ( res ) => {
				setAttendees(res.data);
			} );
		};
		getAttendees();
	}, []);

	if(attendees===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-attendees-gsb' dangerouslySetInnerHTML={{__html: attendees}}></div>
			</div>
		);
	}
}
