import { __ } from "@wordpress/i18n";
import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [banner,setBanner] = useState("");
	useEffect(() => {
		const getBanner = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "banner" },
			} ).then( ( res ) => {
				setBanner(res.data);
			} );
		};
		getBanner();
	}, []);

	if(banner===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={150} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-banner-gsb' dangerouslySetInnerHTML={{__html: banner}}></div>
			</div>
		);
	}
}
