import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [breadcrumbs,setBreadcrumbs] = useState("");
	useEffect(() => {
		const getBreadcrumbs = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "breadcrumbs" },
			} ).then( ( res ) => {
				setBreadcrumbs(res.data);
			} );
		};
		getBreadcrumbs();
	}, []);

	if(breadcrumbs===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={70} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-breadcrumbs-gsb' dangerouslySetInnerHTML={{__html: breadcrumbs}}></div>
			</div>
		);
	}
}
