import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [cancellation,setCancellation] = useState("");
	useEffect(() => {
		const getCancellation = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "cancellation" },
			} ).then( ( res ) => {
				setCancellation(res.data);
			} );
		};
		getCancellation();
	}, []);

	if(cancellation===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={70} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-cancellation-gsb' dangerouslySetInnerHTML={{__html: cancellation}}></div>
			</div>
		);
	}
}
