import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [category,setCategory] = useState("");
	useEffect(() => {
		const getCategory = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "category" },
			} ).then( ( res ) => {
				setCategory(res.data);
			} );
		};
		getCategory();
	}, []);

	if(category===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-category-gsb' dangerouslySetInnerHTML={{__html: category}}></div>
			</div>
		);
	}
}
