import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
    const [content,setContent] = useState("");
    useEffect(() => {
        const getContent = async () => {
            apiFetch( {
                path: "/gsb/v1/event",
                method: 'POST',
                data: { type: "content" },
            } ).then( ( res ) => {
                setContent(res.data);
            } );
        };
        getContent();
    }, []);

    if(content===""){
        return (
            <div className="contentLoading">
            <Skeleton variant="text" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={20} style={{margin: 'auto'}}/>
            <Skeleton variant="text" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={20} style={{margin: 'auto'}}/>
            <Skeleton variant="text" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={20} style={{margin: 'auto'}}/>
            <Skeleton variant="text" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={20} style={{margin: 'auto'}}/>
        </div>);
    } else{
        return (
            <div className="mec-wrap">
                <div className="event-content-gsb" dangerouslySetInnerHTML={{ __html: content }}></div>
            </div>
        );
    }

}
