import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect, render } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [countDown,setCountDown] = useState("");
	useEffect(() => {
		const getCountDown = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				evalScripts: true,
				data: { type: "countDown" },
			} ).then( ( res ) => {
				setCountDown(res.data);
			} );
		};
		getCountDown();
	}, []);

	if(countDown===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={220} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<h1 className='event-count-down-gsb' dangerouslySetInnerHTML={{__html: countDown}}></h1>
			</div>
		);
	}
}
