import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [data,setData] = useState("");
	useEffect(() => {
		const getData = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "data" },
			} ).then( ( res ) => {
				setData(res.data);
			} );
		};
		getData();
	}, []);

	if(data===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'30%'} height={20} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'30%'} height={20} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'30%'} height={20} style={{marginBottom:'10px'}} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-data-gsb' dangerouslySetInnerHTML={{__html: data}}></div>
			</div>
		);
	}
}
