import apiFetch from '@wordpress/api-fetch';
import {useState, useEffect} from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
    const [dateModule, setDateModule] = useState("");
    useEffect(() => {
        const getDateModule = async () => {
            apiFetch({
                path: "/gsb/v1/event",
                method: 'POST',
                data: {type: "dateModule"},
            }).then((res) => {
                setDateModule(res.data);
            });
        };
        getDateModule();
    }, []);

    if(dateModule===""){
        return (
            <div className="contentLoading">
                <Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={150} />
            </div>);
    } else {
        return (
            <div className="mec-wrap">
                <div className='event-date-module-gsb' dangerouslySetInnerHTML={{__html: dateModule}}></div>
            </div>
        );
    }
}
