import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [exportEvent,setExportEvent] = useState("");
	useEffect(() => {
		const getExportEvent = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "export" },
			} ).then( ( res ) => {
				setExportEvent(res.data);
			} );
		};
		getExportEvent();
	}, []);

	if(exportEvent===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-export-gsb' dangerouslySetInnerHTML={{__html: exportEvent}}></div>
			</div>
		);
	}
}
