import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [FAQ,setFAQ] = useState("");
	useEffect(() => {
		const getFAQ = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "faq" },
			} ).then( ( res ) => {
				setFAQ(res.data);
			} );
		};
		getFAQ();
	}, []);

	if(FAQ===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-faq-gsb' dangerouslySetInnerHTML={{__html: FAQ}}></div>
			</div>
		);
	}
}
