import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
    const [image,setImage] = useState("");
    useEffect(() => {
        const getImage = async () => {
            apiFetch( {
                path: "/gsb/v1/event",
                method: 'POST',
                data: { type: "image" },
            } ).then( ( res ) => {
                setImage(res.data);
            } );
        };
        getImage();
    }, []);

    if(image===""){
        return (
            <div className="contentLoading">
                <Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'50%'} height={400} />
            </div>);
    } else {
        return (
            <div className="mec-wrap">
                <div className="event-image-gsb" dangerouslySetInnerHTML={{__html: image}}></div>
            </div>
        );
    }
}
