import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
    const [gallery_html,setImage] = useState("");
    useEffect(() => {
        const getHTML = async () => {
            apiFetch( {
                path: "/gsb/v1/event",
                method: 'POST',
                data: { type: "event_gallery" },
            } ).then( ( res ) => {
                setImage(res.data);
            } );
        };
        getHTML();
    }, []);


    return (
        <div className="mec-wrap">
            <div className="event-gallery-gsb" dangerouslySetInnerHTML={{__html: gallery_html}}></div>
        </div>
    );
}
