import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [hourlySchedule,setHourlySchedule] = useState("");
	useEffect(() => {
		const getHourlySchedule = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "hourlySchedule" },
			} ).then( ( res ) => {
				setHourlySchedule(res.data);
			} );
		};
		getHourlySchedule();
	}, []);

	if(hourlySchedule===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={35} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={35} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} style={{marginBottom:'10px'}} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-hourly-schedule-gsb' dangerouslySetInnerHTML={{__html: hourlySchedule}}></div>
			</div>
		);
	}
}
