import { __ } from "@wordpress/i18n";
import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [labels,setLabels] = useState("");
	useEffect(() => {
		const getLabels = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "labels" },
			} ).then( ( res ) => {
				setLabels(res.data);
			} );
		};
		getLabels();
	}, []);

	if(labels===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={150} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-labels-gsb' dangerouslySetInnerHTML={{__html: labels}}></div>
			</div>
		);
	}
}
