import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [localTime,setLocalTime] = useState("");
	useEffect(() => {
		const getLocalTime = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "localTime" },
			} ).then( ( res ) => {
				setLocalTime(res.data);
			} );
		};
		getLocalTime();
	}, []);

	if(localTime===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={100} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-local-time-gsb' dangerouslySetInnerHTML={{__html: localTime}}></div>
			</div>
		);
	}
}
