import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [locations,setLocations] = useState("");
	useEffect(() => {
		const getLocations = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "locations" },
			} ).then( ( res ) => {
				setLocations(res.data);
			} );
		};
		getLocations();
	}, []);

	if(locations===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-locations-gsb' dangerouslySetInnerHTML={{__html: locations}}></div>
			</div>
		);
	}
}
