import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [map,setMap] = useState("");
	useEffect(() => {
		const getMap = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "map" },
			} ).then( ( res ) => {
				setMap(res.data);
			} );
		};
		getMap();
	}, []);

	if(map===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={400} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-map-gsb' dangerouslySetInnerHTML={{__html: map}}></div>
			</div>
		);
	}
}
