import { __ } from "@wordpress/i18n";
import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [moreInfo,setMoreInfo] = useState("");
	useEffect(() => {
		const getMoreInfo = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "moreInfo" },
			} ).then( ( res ) => {
				setMoreInfo(res.data);
			} );
		};
		getMoreInfo();
	}, []);

	if(moreInfo===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={80} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-more-info-gsb' dangerouslySetInnerHTML={{__html: moreInfo}}></div>
			</div>
		);
	}
}
