import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [nextPrevious,setNextPrevious] = useState("");
	useEffect(() => {
		const getNextPrevious = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "nextPrevious" },
			} ).then( ( res ) => {
				setNextPrevious(res.data);
			} );
		};
		getNextPrevious();
	}, []);

	if(nextPrevious===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={100} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-next-previous-gsb' dangerouslySetInnerHTML={{__html: nextPrevious}}></div>
			</div>
		);
	}
}
