import { __ } from "@wordpress/i18n";
import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [organizers,setOrganizers] = useState("");
	useEffect(() => {
		const getOrganizers = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "organizers" },
			} ).then( ( res ) => {
				setOrganizers(res.data);
			} );
		};
		getOrganizers();
	}, []);

	if(organizers===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={400} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} style={{marginBottom:'10px'}}  />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} style={{marginBottom:'10px'}} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-organizers-gsb' dangerouslySetInnerHTML={{__html: organizers}}></div>
			</div>
		);
	}
}
