import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [publicDownload,setPublicDownload] = useState("");
	useEffect(() => {
		const getPublicDownload = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "publicDownload" },
			} ).then( ( res ) => {
				setPublicDownload(res.data);
			} );
		};
		getPublicDownload();
	}, []);

	if(publicDownload===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-public-download-gsb' dangerouslySetInnerHTML={{__html: publicDownload}}></div>
			</div>
		);
	}
}
