import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [qrCode,setQrCode] = useState("");
	useEffect(() => {
		const getQrCode = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "qrCode" },
			} ).then( ( res ) => {
				setQrCode(res.data);
			} );
		};
		getQrCode();
	}, []);

	if(qrCode===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-qr-code-gsb' dangerouslySetInnerHTML={{__html: qrCode}}></div>
			</div>
		);
	}
}
