import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [registerButton,setRegisterButton] = useState("");
	useEffect(() => {
		const getRegisterButton = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "registerButton" },
			} ).then( ( res ) => {
				setRegisterButton(res.data);
			} );
		};
		getRegisterButton();
	}, []);

	if(registerButton===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'10%'} height={40} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-register-button-gsb' dangerouslySetInnerHTML={{__html: registerButton}}></div>
			</div>
		);
	}
}
