import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [related,setRelated] = useState("");
	useEffect(() => {
		const getRelated = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "related" },
			} ).then( ( res ) => {
				setRelated(res.data);
			} );
		};
		getRelated();
	}, []);

	if(related===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={35} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={300} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-related-gsb' dangerouslySetInnerHTML={{__html: related}}></div>
			</div>
		);
	}
}
