import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [socialShare,setSocialShare] = useState("");
	useEffect(() => {
		const getSocialShare = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "socialShare" },
			} ).then( ( res ) => {
				setSocialShare(res.data);
			} );
		};
		getSocialShare();
	}, []);

	if(socialShare===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={35} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'30%'} height={20} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'30%'} height={20} style={{marginBottom:'10px'}} />
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'30%'} height={20} style={{marginBottom:'10px'}} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-social-share-gsb' dangerouslySetInnerHTML={{__html: socialShare}}></div>
			</div>
		);
	}
}
