import { __ } from "@wordpress/i18n";
import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [speakers,setSpeakers] = useState("");
	useEffect(() => {
		const getSpeakers = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "speakers" },
			} ).then( ( res ) => {
				setSpeakers(res.data);
			} );
		};
		getSpeakers();
	}, []);

	if(speakers===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={500} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<h1 className='event-speakers-gsb' dangerouslySetInnerHTML={{__html: speakers}}></h1>
			</div>
		);
	}
}
