import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [sponsors,setSponsors] = useState("");
	useEffect(() => {
		const getSponsors = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "sponsors" },
			} ).then( ( res ) => {
				setSponsors(res.data);
			} );
		};
		getSponsors();
	}, []);

	if(sponsors===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-sponsors-gsb' dangerouslySetInnerHTML={{__html: sponsors}}></div>
			</div>
		);
	}
}
