import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [tags,setTags] = useState("");
	useEffect(() => {
		const getTags = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "tags" },
			} ).then( ( res ) => {
				setTags(res.data);
			} );
		};
		getTags();
	}, []);

	if(tags===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={40} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-tags-gsb' dangerouslySetInnerHTML={{__html: tags}}></div>
			</div>
		);
	}
}
