import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [timeModule,settimeModule] = useState("");
	useEffect(() => {
		const getTimeModule = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "timeModule" },
			} ).then( ( res ) => {
				settimeModule(res.data);
			} );
		};
		getTimeModule();
	}, []);

	if(timeModule===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={120} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-time-module-gsb' dangerouslySetInnerHTML={{__html: timeModule}}></div>
			</div>
		);
	}
}
