import { __ } from "@wordpress/i18n";
import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [title,setTitle] = useState("");
	useEffect(() => {
		const getTitle = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "title" },
			} ).then( ( res ) => {
				setTitle(res.data);
			} );
		};
		getTitle();
	}, []);

	if(title===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="text" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={100} style={{margin: 'auto'}}/>
			</div>);
	} else {
		return (
			<div className='mec-wrap event-title-gsb'>
				<h1 className="mec-single-title">{title}</h1>
			</div>
		);
	}
}
