import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [trailerUrl,setTrailerUrl] = useState("");
	useEffect(() => {
		const getTrailerUrl = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "trailerUrl" },
			} ).then( ( res ) => {
				setTrailerUrl(res.data);
			} );
		};
		getTrailerUrl();
	}, []);

	if(trailerUrl===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-trailer-url-gsb' dangerouslySetInnerHTML={{__html: trailerUrl}}></div>
			</div>
		);
	}
}
