import apiFetch from '@wordpress/api-fetch';
import { useState, useEffect } from '@wordpress/element';
import "./editor.scss";
import {Skeleton} from "@mui/material";

export default function Edit() {
	const [weather,setWeather] = useState("");
	useEffect(() => {
		const getWeather = async () => {
			apiFetch( {
				path: "/gsb/v1/event",
				method: 'POST',
				data: { type: "weather" },
			} ).then( ( res ) => {
				setWeather(res.data);
			} );
		};
		getWeather();
	}, []);

	if(weather===""){
		return (
			<div className="contentLoading">
				<Skeleton variant="rectangular" sx={{ bgcolor: '#f0f0f0' }} animation="wave" width={'100%'} height={200} />
			</div>);
	} else {
		return (
			<div className="mec-wrap">
				<div className='event-weather-gsb' dangerouslySetInnerHTML={{__html: weather}}></div>
			</div>
		);
	}
}
