jQuery(document).ready(function($){

    // Initialize WP Color Picker
    if($.fn.wpColorPicker) jQuery('.mec-color-picker').wpColorPicker();

    $('.mec-seat-area-tickets-wrapper .mec-select2, .mec-seat-ticket-wrapper .mec-select2, .mec-seat-area-tickets-popup-wrapper .mec-select2, .mec-seat-ticket-wrapper .mec-select2').select2({
        allowClear: true
    });

    $('.mec-seat-area-tickets-wrapper .select2-search__field, .mec-seat-ticket-wrapper .select2-search__field, .mec-seat-area-tickets-popup-wrapper .select2-search__field, .mec-seat-ticket-wrapper .select2-search__field').css('width','100%');

    $('.mec-seat-area-shape').on('change',function(e){

        var shape_type = $(this).val();
        switch( shape_type ) {
            case 'circle':

                $(this).closest('.mec-seats-sidebar-wrap , .mec-area-item-popup').find('.mec-seat-area-number-of-seats-in-shape-wrap').removeClass('hidden');
                break;
            default:

                $(this).closest('.mec-seats-sidebar-wrap , .mec-area-item-popup').find('.mec-seat-area-number-of-seats-in-shape-wrap').addClass('hidden');
                break;
        }
    }).trigger('change');

    var new_seat_layout_data;

    function mec_num_to_ss_column(num){
        let s = '', t;

        while (num > 0) {
          t = (num - 1) % 26;
          s = String.fromCharCode(65 + t) + s;
          num = (num - t)/26 | 0;
        }
        return s || undefined;
    }

    function mec_download_file(content, fileName, contentType) {

        const a = document.createElement("a");
        const file = new Blob([content], { type: contentType });
        a.href = URL.createObjectURL(file);
        a.download = fileName;
        a.click();
    }

    function mec_open_popup_settings( el ){

        var data = $(el).data('seatdefination');
        data = 'object' === typeof data ? data : {};
        var id = $(el).attr('id');
        var $seat = $('#' + id);
        var popup_form = $('#mec-seat-popup-backend-seat-data');

        popup_form.find('.mec-seat-html-id').val( id );
        if( 'undefined' !== typeof data.custom_row_id && data.custom_row_id.length ){
            popup_form.find('.mec-seat-row-id').val( data.custom_row_id );
        }

        if( ! $seat.hasClass('row-indicator') ){
            popup_form.find('.mec-seat-row-id').closest('.mec-form-row').css('display','none');
        }else{
            popup_form.find('.mec-seat-row-id').closest('.mec-form-row').css('display','block');
        }

        if( 'undefined' !== typeof data.mec_seat_status && 'no' == data.mec_seat_status ){
            popup_form.find('.mec-seat-status').prop('checked', false);
        }else{
            popup_form.find('.mec-seat-status').prop('checked', true);
        }
        popup_form.find('.mec-seat-status').change();

        if( 'undefined' !== typeof data.mec_seat_booked && 'yes' == data.mec_seat_booked ){
            popup_form.find('.mec-seat-booked').prop('checked', true);
        }else{
            popup_form.find('.mec-seat-booked').prop('checked', false);
        }

        if( 'undefined' !== typeof data.mec_seat_handicap_accessible && 'yes' == data.mec_seat_handicap_accessible ){
            popup_form.find('.mec-seat-handicap-accessible').prop('checked', true);
        }else{
            popup_form.find('.mec-seat-handicap-accessible').prop('checked', false);
        }

        if( 'undefined' !== typeof data.mec_seat_selected_color ){
            popup_form.find('.mec-seat-selected-color').val(data.mec_seat_selected_color);
        }else{
            popup_form.find('.mec-seat-selected-color').val('');
        }
        popup_form.find('.mec-seat-selected-color').change();
        popup_form.find('.mec-seat-not-selected-color').val(data.mec_seat_not_selected_color);

        if( 'undefined' !== typeof data.mec_seat_not_selected_color ){
        }else{
            popup_form.find('.mec-seat-not-selected-color').val('');
        }
        popup_form.find('.mec-seat-not-selected-color').change();

        if( 'undefined' !== typeof data.mec_seat_description ){
            popup_form.find('.mec-seat-description').text( data.mec_seat_description );
        }else{
            popup_form.find('.mec-seat-description').text( '' );
        }

        if( 'undefined' !== typeof data.mec_seat_ticket ){
            popup_form.find('.mec-seat-ticket').val( data.mec_seat_ticket );
        }else{
            popup_form.find('.mec-seat-ticket').val( popup_form.find('.mec-seat-ticket option').first().val() );
        }

        popup_form.find('.mec-seat-ticket').trigger('change');

        backend_lightbox_seat = lity('#mec-seat-popup-backend-seat-data');
        $('#mec-seat-popup-backend-seat-data').closest('.lity-container').find(' > button.lity-close').remove();
    }

    function mec_seat_get_areas_data( form ){

        var areas = [];
        $.each($('.mec-seat-areas .mec-area-item',form),function(i,element){

            var id = $(element).find('[data-key="id"]').val();

            if( id.length === 0 || '{{id}}' === id ){
                return;
            }

            areas.push({
                'id': id,
                'number_of_seats': $(element).find('[data-key="number_of_seats"]').val(),
                'rows': $(element).find('[data-key="rows"]').val(),
                'title': $(element).find('[data-key="title"]').val(),
                'shape_type': $(element).find('[data-key="shape_type"]').val(),
                'number_of_seats_in_shape': 'circle' === $(element).find('[data-key="shape_type"]').val() ? $(element).find('[data-key="number_of_seats_in_shape"]').val() : '',
                'ticket_ids': $(element).find('[data-key="ticket_ids"]').val(),
                'seat_booked': $(element).find('[data-key="seat_booked"]').val(),
                'seat_handicap_accessible': $(element).find('[data-key="seat_handicap_accessible"]').val(),
                'seat_description': $(element).find('[data-key="seat_description"]').text(),
                'seat_selected_color': $(element).find('[data-key="seat_selected_color"]').val(),
                'seat_not_selected_color': $(element).find('[data-key="seat_not_selected_color"]').val(),
            });
        });

        return areas;
    }

    function mec_seat_prepare_saved_object_area( areas ){

        var savedObjectArea = {};
        var objArea = {};

        if( 'undefined' !== typeof new_seat_layout_data ){

            mec_seat_layout_backend.seatLayoutData = new_seat_layout_data;
        }else{
            try{

                mec_seat_layout_backend.seatLayoutData = JSON.parse(mec_seat_layout_backend.seatLayoutData);
            }catch{

                mec_seat_layout_backend.seatLayoutData = mec_seat_layout_backend.seatLayoutData;
            }
        }

        if (
            'undefined' != typeof mec_seat_layout_backend.seatLayoutData
            &&
            'undefined' != typeof mec_seat_layout_backend.seatLayoutData.data
            &&
            'undefined' != typeof mec_seat_layout_backend.seatLayoutData.data.seatLayout
            &&
            'undefined' != typeof mec_seat_layout_backend.seatLayoutData.data.seatLayout.colAreas
            &&
            'undefined' != typeof mec_seat_layout_backend.seatLayoutData.data.seatLayout.colAreas.objArea
        ){
            savedObjectArea = mec_seat_layout_backend.seatLayoutData.data.seatLayout.colAreas.objArea;
        }

        $.each(areas, function(area_key, area_data){

            var id = parseInt(area_data.id);
            $.each(savedObjectArea, function(s_area_key, s_area_data){

                var s_id = parseInt(s_area_data.AreaCode);
                if( id === s_id ){

                    objArea[area_key] = s_area_data;
                }
            });
        });

        return objArea;
    }

    function mec_seat_add_areas( areas ){
        var all_seats = 0;
        var max_number_of_seats = 1;
        var number_of_seats,rows,seat_booked;

        var seatNumber = 1,GridRowId = 1,RowData = {};
        var colAreas = {};
        colAreas['objArea'] = [];


        var general_settings = {};

        var savedObjectArea = mec_seat_prepare_saved_object_area( areas );

        general_settings = 'undefined' != typeof mec_seat_layout_backend.seatLayoutData && 'undefined' != typeof mec_seat_layout_backend.seatLayoutData.general_settings ? mec_seat_layout_backend.seatLayoutData.general_settings : {};
        $('#mec-seat-set-general-settings').data('seatdefination', general_settings)

        var seat_number2 = 0;
        $.each( areas, function(area_key, area_data){

            id = parseInt(area_data.id);
            number_of_seats = parseInt(area_data.number_of_seats);
            rows = parseInt(area_data.rows);
            title = area_data.title;
            shape_type = 'undefined' !== typeof area_data.shape_type && area_data.shape_type.length ? area_data.shape_type : 'line';
            number_of_seats_in_shape = 'undefined' !== typeof area_data.number_of_seats_in_shape && area_data.number_of_seats_in_shape.length ? parseInt(area_data.number_of_seats_in_shape) : 0;

            seat_booked = 'undefined' !== typeof area_data.seat_booked && area_data.seat_booked.length ? area_data.seat_booked : '';
            seat_handicap_accessible = 'undefined' !== typeof area_data.seat_handicap_accessible && area_data.seat_handicap_accessible.length ? area_data.seat_handicap_accessible : '';
            seat_description = 'undefined' !== typeof area_data.seat_description && area_data.seat_description.length ? area_data.seat_description : '';
            seat_selected_color = 'undefined' !== typeof area_data.seat_selected_color && area_data.seat_selected_color.length ? area_data.seat_selected_color : '';
            seat_not_selected_color = 'undefined' !== typeof area_data.seat_not_selected_color && area_data.seat_not_selected_color.length ? area_data.seat_not_selected_color : '';

            all_seats += number_of_seats * rows;

            max_number_of_seats = Math.max(max_number_of_seats, number_of_seats);

            var objRows = [];
            for( var j = 1; j <= rows; j++ ){

                var objSeat =[];
                for( var i = 1; i <= number_of_seats; i++ ){

                    options = {
                        mec_seat_booked: seat_booked,
                        mec_seat_handicap_accessible: seat_handicap_accessible,
                        mec_seat_selected_color: seat_selected_color,
                        mec_seat_not_selected_color: seat_not_selected_color,
                        mec_seat_description: seat_description,
                    };
                    RowData = {};
                    if(
                        'undefined' != typeof savedObjectArea[area_key]
                        &&
                        'undefined' != typeof savedObjectArea[area_key].objRow
                        &&
                        'undefined' != typeof savedObjectArea[area_key].objRow[j-1]
                        &&
                        'undefined' != typeof savedObjectArea[area_key].objRow[j-1].objSeat
                        &&
                        'undefined' != typeof savedObjectArea[area_key].objRow[j-1].objSeat[i-1]
                        ){

                        options = savedObjectArea[area_key].objRow[j-1].objSeat[i-1];

                        if( 'undefined' != typeof savedObjectArea[area_key].objRow[j-1].RowData ){

                            RowData = savedObjectArea[area_key].objRow[j-1].RowData;
                        }
                    }

                    var options = $.extend(
                        options,
                        {
                            'GridSeatNum': i,
                            'SeatStatus': '0',
                            'seatNumber': i,
                            'mec_seat_number': seatNumber,
                            'seat_number2': '',
                        }
                    );

                    if( 'undefined' === typeof options.mec_seat_status || 'no' !== options.mec_seat_status ) {
                        options.seat_number2 = ++seat_number2;
                    }
                    objSeat.push( options );

                    seatNumber++;
                }
                var custom_row_id = 'undefined' !== typeof RowData.custom_row_id && RowData.custom_row_id.length ? RowData.custom_row_id : '';
                objRows.push({
                    'GridRowId': GridRowId,
                    'PhyRowId': custom_row_id ? custom_row_id : mec_num_to_ss_column(GridRowId),
                    'objSeat': objSeat,
                    'RowData': RowData,
                });

                GridRowId = ++GridRowId;
            }

            var row = {
                'AreaDesc': title,
                'AreaCode': id,
                'AreaNum': id,
                'HasCurrentOrder': true,
                'shapeType': shape_type,
                'numberOfSeatsInShape': number_of_seats_in_shape,
                'objRow': objRows,
            };

            colAreas['objArea'].push( row );
        });

        colAreas['intMinSeatId'] = 2;
        colAreas['intMaxSeatId'] = parseInt(max_number_of_seats);
        colAreas['Count'] = colAreas['objArea'].length;

        var seatData = {
            'product_id': 12345,
            'freeSeating': false,
            'tempTransId': '12345',
            'seatLayout': {
                'colAreas': colAreas
            },
            'areas': [],
            'groupedSeats': [],
        };

        if( all_seats ){

            $('.mec-seat-top-wrap').show();
        }else{

            $('.mec-seat-top-wrap').hide();
        }

        $('.mec-seat-layouts').seatLayout({
            data: seatData,
            showActionButtons: false,
            numberOfSeat: all_seats,
            callOnSeatSelect: function(e, dataToPass, el){

                mec_open_popup_settings( el );

                $(el).removeClass('current-selected');
            }
        });

        $(document).trigger('mec_seat_layout_init');
    }

    function mec_seat_export_areas_data( areas ){

        var row_html_id = '';
        var all_seats = 0;
        var max_number_of_seats = 1;
        var number_of_seats,rows,AreaCode,GridSeatNum;

        var occurrence = '';
        var GridRowId = 1;
        var seat_data;
        var colAreas = {};
        colAreas['objArea'] = [];
        $.each( areas, function(area_key, area_data){

            AreaCode = parseInt(area_data.id);
            number_of_seats = parseInt(area_data.number_of_seats);
            rows = parseInt(area_data.rows);
            title = area_data.title;
            shape_type = 'undefined' !== typeof area_data.shape_type && area_data.shape_type.length ? area_data.shape_type : 'line';
            number_of_seats_in_shape = 'undefined' !== typeof area_data.number_of_seats_in_shape && area_data.number_of_seats_in_shape.length ? parseInt(area_data.number_of_seats_in_shape) : 0;

            all_seats += number_of_seats * rows;

            max_number_of_seats = Math.max(max_number_of_seats, number_of_seats);

            var objRows = [];

            var seat_number2 = 0;
            for( var j = 1; j <= rows; j++ ){

                var objSeat = [];
                for( var i = 1; i <= number_of_seats; i++ ){

                    seat_data = {};

                    GridSeatNum = i;
                    seat_html_id = 'mec-seat-'+ occurrence + '-' + AreaCode + '-' + GridRowId + '-' + GridSeatNum;
                    seat_data = mec_seat_get_data(seat_html_id);

                    if( !seat_data ){
                        seat_data = {};
                    }
                    delete seat_data['GridSeatNum'];
                    delete seat_data['SeatStatus'];
                    delete seat_data['seatNumber'];
                    delete seat_data['mec_seat_number'];
                    delete seat_data['GridRowId'];
                    delete seat_data['PhyRowId'];
                    delete seat_data['AreaNum'];
                    delete seat_data['AreaCode'];
                    delete seat_data['AreaDesc'];
                    delete seat_data['html'];
                    delete seat_data['data_attributes'];
                    delete seat_data['styles'];
                    delete seat_data['classes'];

                    if( 'undefined' === typeof seat_data.mec_seat_status || 'no' !== seat_data.mec_seat_status ) {
                        seat_data.seat_number2 = ++seat_number2;
                    }
                    objSeat.push(seat_data);
                }

                row_html_id = 'mec-seat-' + AreaCode + '-' + GridRowId;
                RowData = $('#'+row_html_id).data('seatdefination');
                var custom_row_id = 'undefined' !== typeof RowData.custom_row_id && RowData.custom_row_id.length ? RowData.custom_row_id : '';
                objRows.push({
                    'GridRowId': GridRowId,
                    'PhyRowId': custom_row_id ? custom_row_id : mec_num_to_ss_column(GridRowId),
                    'objSeat': objSeat,
                    'RowData': 'undefined' !== typeof RowData ? RowData : {},
                });

                GridRowId = ++GridRowId;
            }

            var area = {
                'AreaDesc': title,
                'AreaCode': AreaCode,
                'AreaNum': AreaCode,
                'HasCurrentOrder': true,
                'shapeType': shape_type,
                'numberOfSeatsInShape': number_of_seats_in_shape,
                'objRow': objRows,
            };

            colAreas['objArea'].push( area );
        });

        colAreas['intMinSeatId'] = 2;
        colAreas['intMaxSeatId'] = parseInt(max_number_of_seats);
        colAreas['Count'] = colAreas['objArea'].length;

        var seatData = {
            'product_id': 12345,
            'freeSeating': false,
            'tempTransId': '12345',
            'seatLayout': {
                'colAreas': colAreas
            },
            'areas': [],
            'groupedSeats': [],
        };

        var seatLayout = {
            data: seatData,
            showActionButtons: false,
            numberOfSeat: all_seats,
        };

        new_seat_layout_data = seatLayout;

        new_seat_layout_data['general_settings'] = $('#mec-seat-set-general-settings').data('seatdefination');

        $('#mec-seat-layout-data').text(JSON.stringify(new_seat_layout_data));

        return seatLayout;
    }

    function mec_seat_rebuild_areas( form_area_html ){

        var areas = mec_seat_get_areas_data( form_area_html );
        mec_seat_add_areas( areas );
    }

    function mec_seat_change_areas_handler(el){

        var form = $(el).parents('.mec-seat-add-area-form');
        mec_seat_rebuild_areas( form );

        $(document).trigger('mec_seat_added_area');
    }

    function mec_seat_render_seat(id,data){

        if( !data ){
            return;
        }

        var element = $('#'+id);
        if( $(element).hasClass('row-indicator') ) {
            $(element).text(data.PhyRowId);
        }

        if( !element.hasClass('mec-seat') ){

            return;
        }

        var status = 'yes' === data.mec_seat_status;
        var booked = 'yes' === data.mec_seat_booked;
        var customized = 'undefined' != typeof data.mec_seat_status;
        if( customized ){
            element.addClass('mec-seat-customized');
        }

        element.removeClass('current-selected');

        if( 'no' === data.mec_seat_status ){
            element.addClass('mec-seat-disabled');
        }else{
            element.removeClass('mec-seat-disabled');
        }

        if( status && 'yes' === data.mec_seat_booked ){
            element.addClass('mec-seat-booked');
        }else{
            element.removeClass('mec-seat-booked');
        }
        var bg_color = data.mec_seat_not_selected_color;

        if( status && ! booked && data.mec_seat_not_selected_color ){
            element.css('background-color', bg_color);
            // bg_color = element.css('background-color').replace(')', ', 0.85)').replace('rgb', 'rgba');
            element.css('background-color', bg_color);
            element.css('--mec-seat-color-available', bg_color);
        }else{

            element.css('border-color', data.mec_seat_not_selected_color);
            element.css('background-color', '');
            element.css('border-color', '');
            element.css('--mec-seat-color-available', '');
        }

        data = mec_seat_prepare_data(data);

        if( 'undefined' !== typeof data.html ){

            if( element.find('.mec-seat-tooltiptext').length ){

                element.find('.mec-seat-tooltiptext').html( $(data.html).html() );
            }else{

                element.append( data.html );
            }
        }

        var is_handicap_accessible = 'undefined' !== typeof data.mec_seat_description && 'yes' == data.mec_seat_handicap_accessible ? true : false;
        if( is_handicap_accessible ) {

            element.addClass("mec-seat-handicap-accessible");
        }else{
            element.removeClass("mec-seat-handicap-accessible");
        }
    }

    $('.mec-seat-add-area-form #mec-seat-area-number-of-seats, .mec-seat-add-area-form #mec-seat-area-rows').on('change',function(e){

        if( $(this).val().length > 0 ){

            $(this).removeClass('mec-error');
        }
    });


    $('.mec-seat-add-area-form #mec-seat-add-area').on('click',function(e){

        e.preventDefault();
        var d = new Date();
        var form = $(this).parents('.mec-seat-add-area-form');
        var id = d.getTime();
        var number_of_seats = $('#mec-seat-area-number-of-seats', form).val();
        var rows = $('#mec-seat-area-rows', form).val();
        var title = $('#mec-seat-area-title', form).val();
        var description = $('#mec-seat-area-description', form).val();
        var ticket_ids = $('#mec-seat-area-tickets', form).val();
        ticket_ids = $.isArray(ticket_ids) ? ticket_ids : [];
        var shape_type = $('#mec-seat-area-shape', form).val();
        var number_of_seats_in_shape = $('#mec-seat-area-number-of-seats-in-shape', form).val();

        var seat_booked = form.find('.mec-area-seat-booked').is(':checked') ? 'yes' : 'no';
        var seat_handicap_accessible = form.find('.mec-area-seat-handicap-accessible').is(':checked') ? 'yes' : 'no';
        var seat_description = form.find('.mec-area-seat-description').val();
        var seat_selected_color = form.find('.mec-area-seat-selected-color').val();
        var seat_not_selected_color = form.find('.mec-area-seat-not-selected-color').val();

        if( number_of_seats.length == 0 ){

            $('#mec-seat-area-number-of-seats', form).addClass('mec-error');
            return;
        }

        if( rows.length == 0 ){

            $('#mec-seat-area-rows', form).addClass('mec-error');
            return;
        }

        html = $('#mec-seat-area-default', form).html();
        html = html.replaceAll('{{id}}',id);
        html = html.replaceAll('{{number_of_seats}}',number_of_seats);
        html = html.replaceAll('{{rows}}',rows);
        html = html.replaceAll('{{title}}',title);
        html = html.replaceAll('{{description}}',description);
        html = html.replaceAll('{{ticket_ids}}',ticket_ids.join(','));
        html = html.replaceAll('{{shape_type}}',shape_type);
        html = html.replaceAll('{{number_of_seats_in_shape}}',number_of_seats_in_shape);

        html = html.replaceAll('{{seat_booked}}',seat_booked);
        html = html.replaceAll('{{seat_handicap_accessible}}',seat_handicap_accessible);
        html = html.replaceAll('{{seat_description}}',seat_description);
        html = html.replaceAll('{{seat_selected_color}}',seat_selected_color);
        html = html.replaceAll('{{seat_not_selected_color}}',seat_not_selected_color);

        $('.mec-seat-areas',form).append('<div class="mec-form-row" >'+ html +'</div>');

        var items = $('.mec-seat-areas .mec-area-item', form);
        var item = $('.mec-seat-areas .mec-area-item:last',form );
        var area_number = items.length -1;
        mec_seat_render_setting_area_title( form, item, title, area_number );

        $('.mec-seat-areas .mec-area-item:last input',form).on('change',function(e){
            mec_seat_change_areas_handler(this);
        });

        mec_seat_rebuild_areas( form );

        $('.mec-seat-add-area-form .mec-seat-add-area-form-fields input, .mec-seat-add-area-form .mec-seat-add-area-form-fields textarea').val('').trigger('change');
        $('.mec-seat-add-area-form .mec-seat-add-area-form-fields input[type="checkbox"]').prop('checked',false).trigger('change');
        $('.mec-seat-add-area-form .mec-seat-add-area-form-fields select.mec-seat-area-ticket').val([]).trigger('change');

        $(document).trigger('mec_seat_changed_areas');
    });

    function mec_seat_get_data( id ){

        var default_data = $('#'+id).attr('data-seatdefination');
        default_data = 'undefined' !== typeof default_data && default_data.length ? JSON.parse(default_data) : {};

        var data = $('#'+id).data('seatdefination');
        data = 'undefined' !== typeof data ? data : "{}";
        data = typeof data == 'object' ? data : JSON.parse(data);

        var seat_data = $.extend(
            {},
            default_data,
            data
        );

        return seat_data;
    }

    function mec_seat_set_data( id, data ){

        $('#'+id).removeAttr('data-seatdefination');
        $('#'+id).attr('data-seatdefination',JSON.stringify(data));
        $('#'+id).data('seatdefination',data);
        $(document).trigger('mec_seat_data_is_changed', [id, data]);
    }

    $('#mec-seat-popup-backend-seat-data #mec-seat-update-seat').on('click',function(){

        var form = $(this).closest('#mec-seat-popup-backend-seat-data');

        var id = form.find('.mec-seat-html-id').val();
        var element = $('#'+id);
        var new_seat_data = {};
        var data = mec_seat_get_data( id );

        new_seat_data['mec_seat_status'] = form.find('.mec-seat-status').is(':checked') ? 'yes' : 'no';
        new_seat_data['mec_seat_booked'] = form.find('.mec-seat-booked').is(':checked') ? 'yes' : 'no';
        new_seat_data['mec_seat_handicap_accessible'] = form.find('.mec-seat-handicap-accessible').is(':checked') ? 'yes' : 'no';
        new_seat_data['custom_row_id'] = form.find('.mec-seat-row-id').val();

        new_seat_data['mec_seat_description'] = form.find('.mec-seat-description').val();
        new_seat_data['mec_seat_selected_color'] = form.find('.mec-seat-selected-color').val();
        new_seat_data['mec_seat_not_selected_color'] = form.find('.mec-seat-not-selected-color').val();
        new_seat_data['mec_seat_ticket'] = form.find('.mec-seat-ticket').val();
        new_seat_data['mec_seat_ticket'] = 'undefined' !== typeof new_seat_data['mec_seat_ticket'] ? new_seat_data['mec_seat_ticket'] : '';

        if( element.hasClass('row-indicator') || 'mec-seat-set-general-settings' === element.attr('id') ){

            var seats = [];
            if( element.hasClass('row-indicator') ){

                seats = element.closest('ul.seat-area-row').find('.mec-seat:not(.mec-seat-empty)');
                if( new_seat_data['custom_row_id'].length > 0 ) {
                    new_seat_data['PhyRowId'] = new_seat_data['custom_row_id'];
                }
            }else if( 'mec-seat-set-general-settings' === element.attr('id') ){

                id = 'mec-seat-set-general-settings';
                seats = $('.mec-seat-layouts').find('.mec-seat');
            }

            $.each( seats, function(i,v){

                if( $(v).html().length == 0 ){

                    return;
                }

                var seat_id = $(v).attr('id');
                var data = mec_seat_get_data( seat_id );
                if( new_seat_data['custom_row_id'].length == 0 ) {
                    new_seat_data['PhyRowId'] = mec_num_to_ss_column(data['GridRowId']);
                }
                var seat_data = $.extend(
                    {},
                    data,
                    new_seat_data
                );

                mec_seat_set_data(
                    seat_id,
                    seat_data
                );
            });
        }

        data = $.extend(
            {},
            data,
            new_seat_data
        );

        mec_seat_set_data( id, data );

        if( !$('#'+id).hasClass('mec-seat') ){

            $('#'+id).removeClass('mec-seat-customized');
            $('#'+id).removeClass('mec-seat-booked');
        }

        var form = $('.mec-seat-add-area-form');
        var areas = mec_seat_get_areas_data( form );
        mec_seat_export_areas_data( areas );

        backend_lightbox_seat.close();
    });

    $(document).on('click','#mec-seat-popup-backend-seat-data .mec-seat-close-lity',function(e){
        e.preventDefault();

        backend_lightbox_seat.close();

        return false;
    });

    $('#mec-seat-set-general-settings').on('click',function(e){
        e.preventDefault();

        mec_open_popup_settings( e.currentTarget );
    });

    $('#mec-seat-popup-backend-seat-data .mec-seat-status').on('change',function(){

        var form = $(this).parents('#mec-seat-popup-backend-seat-data');
        var status = $(this).is(':checked');
        if( status ){
            $('.mec-seat-options',form).show();
        }else{
            $('.mec-seat-options',form).hide();
        }
    });

    $('.mec-seat-update-layout').on('click',function(e){

        var btn = $(this);
        var form = $('.mec-seat-add-area-form');
        var areas = mec_seat_get_areas_data( form );
        var seat_layout_data = mec_seat_export_areas_data( areas );

        $(btn).prop('disabled',true);

        $.post(
            mec_seat_layout_backend.ajaxurl,
            {
                action: 'mec-seat-update-layout-data',
                event_id: mec_seat_layout_backend.event_id,
                nonce: $('#mec_seat_update_layout_nonce').val(),
                data: seat_layout_data,
                areas: areas,
            },
            function(r){

                $(btn).prop('disabled',false);
                form.find('.mec-seat-btn-wrap .mec-message').remove();

                if( r.success ){
                    form.find('.mec-seat-btn-wrap').prepend('<div class="mec-message mec-success">'+ r.data.message +'</div>')
                }else{
                    form.find('.mec-seat-btn-wrap').prepend('<div class="mec-message mec-error">'+ r.data.message +'</div>')
                }

                setTimeout(function(){
                    form.find('.mec-seat-btn-wrap .mec-message').remove();
                }, 5000);
            }
        );

        return false;
    });

    $('.mec-seat-export-layout').on('click',function(e){
        e.preventDefault();
        var btn = $(this);
        var form = $('#mec-seat-export-form');

        $(btn).prop('disabled',true);

        $.post(
            mec_seat_layout_backend.ajaxurl,
            {
                action: 'mec-seat-export-layout-data',
                event_id: mec_seat_layout_backend.event_id,
                nonce: $('#mec_seat_import_export_layout_nonce').val(),
            },
            function(r){

                $(btn).prop('disabled',false);
                form.find('.mec-seat-btn-wrap .mec-message').remove();
                if( 'undefined' === typeof r.success ){
                    return;
                }

                if( r.success ){

                    if( 'undefined' !== r.data.file_content ){

                        mec_download_file(r.data.file_content, r.data.filename, "text/plain");
                    }else{

                        form.find('.mec-seat-btn-wrap').prepend('<div class="mec-message mec-success">'+ r.data.message +'</div>')
                    }

                }else{
                    form.find('.mec-seat-btn-wrap').prepend('<div class="mec-message mec-error">'+ r.data.message +'</div>')
                }

                setTimeout(function(){
                    form.find('.mec-seat-btn-wrap .mec-message').remove();
                }, 5000);
            }
        );

        return false;
    });

    $('.mec-seat-import-layout').on('click',function(e){
        e.preventDefault();
        var btn = $(this);
        var form = $('#mec-seat-import-form');
        var import_data = $('#mec-seat-import-data',form).val();

        if( import_data.length === 0 ){

            return;
        }

        $(btn).prop('disabled',true);

        $.post(
            mec_seat_layout_backend.ajaxurl,
            {
                action: 'mec-seat-import-layout-data',
                event_id: mec_seat_layout_backend.event_id,
                import_data: JSON.stringify(JSON.parse(import_data)),
                nonce: $('#mec_seat_import_export_layout_nonce').val(),
            },
            function(r){

                $(btn).prop('disabled',false);
                form.find('.mec-seat-btn-wrap .mec-message').remove();
                if( 'undefined' === typeof r.success ){
                    return;
                }

                if( r.success ){

                    window.location.reload();
                }else{
                    form.find('.mec-seat-btn-wrap').prepend('<div class="mec-message mec-error">'+ r.data.message +'</div>')
                }

                setTimeout(function(){
                    form.find('.mec-seat-btn-wrap .mec-message').remove();
                }, 5000);
            }
        );

        return false;
    });


    $(document).on('mec_seat_data_is_changed',function(e,id,data){

        mec_seat_render_seat( id, data );
    });

    $(document).on('mec_seat_layout_init',function(){

        $('.row-indicator').on('click',function(e){

            mec_open_popup_settings( e.currentTarget );
        });

        $.each($('.mec-seat-layouts .mec-seat, .mec-seat-layouts .row-indicator'),function(i,seat){

            var id = $(seat).attr('id');
            var data = mec_seat_get_data(id);
            mec_seat_render_seat( id, data );

            if( !$('#'+id).hasClass('mec-seat') ){

                $('#'+id).removeClass('mec-seat-customized');
                $('#'+id).removeClass('mec-seat-booked');
            }
        });

        var form = $('.mec-seat-add-area-form');
        var areas = mec_seat_get_areas_data( form );
        mec_seat_export_areas_data( areas );

        if(typeof jQuery.fn.sortable !== 'undefined'){
            jQuery(".mec-seat-areas").sortable({
                handle: '.mec-move-row',
                update: function(e, ui){
                    $('.mec-seat-areas input:first').trigger('change');
                }
            });
        }

    });

    $(document).on('change', '.mec-seat-areas input, .mec-seat-areas textarea', function(e){
        mec_seat_change_areas_handler(this);
    });

    $(document).on('click', '.mec-seat-areas .mec-remove-row', function(e){

        var form = $(this).closest('.mec-seat-areas');
        $(this).closest('.mec-form-row').remove();
        form.find('[data-key="id"]').first().trigger('change');
    });

    function mec_seat_render_setting_area_title( $wrap_settings, $item, title = false, area_number = false ){

        if( !area_number ){

            area_number = $item.closest('.mec-area-item').data('area_number');
        }
        if( !title ){

            title = $wrap_settings.find('[data-key="title"]').val();
        }
        title = title.length > 0 ? title : '#' + area_number + ' ' + mec_seat.area_text;

        $item.find('.mec-area-row-title').html( title );
    }

    var lightbox_area;
    $(document).on('click', '.mec-seat-areas .mec-edit-row', function(e){

        var item = $(this).closest('.mec-area-item');
        var popup = $('#mec-area-item-popup');

        $.each(item.find('input, textarea, select'), function(i,v){

            var key = $(v).data('key');
            var value = $(v).val();
            if( 'ticket_ids' == key ){
                value = value.split(',');
            }

            if( 'seat_booked' == key || 'seat_handicap_accessible' == key ){
                if( value === 'yes' ) {
                    popup.find('[data-key="'+key+'"]').prop('checked',true).trigger('change');
                }else{
                    popup.find('[data-key="'+key+'"]').prop('checked',false).trigger('change');
                }
            }else{
                popup.find('[data-key="'+key+'"]').val( value ).trigger('change');
            }
        });

        popup.find('#mec-seat-update-area').data('item_id', item.find('[data-key="id"]').val() );

        lightbox_area = lity(popup);
        $(popup).closest('.lity-container').find(' > button.lity-close').remove();
    });


    $('.mec-area-item-popup #mec-seat-area-number-of-seats-popup, .mec-area-item-popup #mec-seat-area-rows-popup').on('change',function(e){

        if( $(this).val().length > 0 ){

            $(this).removeClass('mec-error');
        }
    });

    $('#mec-seat-update-area').on('click', function(e){

        var form = $('#mec-area-item-popup');
        var item_id = $(this).data('item_id');
        var item = $('#mec-area-item-'+item_id);
        var item_fields = item.find('.mec-seat-area-form-fields');

        var popup = $(this).closest('#mec-area-item-popup');

        var number_of_seats = $('#mec-seat-area-number-of-seats-popup', form).val();
        var rows = $('#mec-seat-area-rows-popup', form).val();

        if( number_of_seats.length == 0 ){

            $('#mec-seat-area-number-of-seats-popup', form).addClass('mec-error');
            return;
        }

        if( rows.length == 0 ){

            $('#mec-seat-area-rows-popup', form).addClass('mec-error');
            return;
        }

        mec_seat_render_setting_area_title( popup, item );

        $.each(popup.find('input, textarea, select'), function(i,v){

            var key = $(v).data('key');
            var value = $(v).val();
            if( $(v).is('SELECT') ) {

                value = $.isArray( value ) ? value.join(',') : value;
            }

            item_fields.find('[data-key="'+key+'"]').val( value );
        });

        item_fields.find('[data-key="id"]').trigger('change');

        $.each($('#mec-seat-area-'+item_id).find('li.mec-seat'), function(i,seat){

            var id = $(this).attr('id');
            var ticket_ids = item_fields.find('[data-key="ticket_ids"]').length ? item_fields.find('[data-key="ticket_ids"]').val() : '';
            var seat_data = mec_seat_get_data( id );

            seat_data['mec_seat_ticket'] = ticket_ids.length ? ticket_ids.split(',') : [];

            mec_seat_set_data(id,seat_data);
        });

        lightbox_area.close();
    });

    $(document).on('click','#mec-area-item-popup .mec-seat-close-lity',function(e){
        e.preventDefault();

        lightbox_area.close();

        return false;
    });

    var backend_lightbox_seat;
    var backend_lightbox_seats;
    var cache_seat_layout_data;
    var saved_data;
    var saved_area;
    var demo_settings;
    $(document).on('click', '#mec-seat-open-seats-settings',function(e){
        e.preventDefault();

        demo_settings = $('.mec-seat-demo-input').serializeArray();
        saved_data = $('#mec-seat-layout-data').val();
        cache_seat_layout_data = new_seat_layout_data;
        saved_area = mec_seat_get_areas_data( $('#mec-seat-seats-settings-wrap') );

        var options = {
            template: '<div class="lity mec-seat-seats-settings-lity-wrap" role="dialog" aria-label="Dialog Window (Press escape to close)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Loading...</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Close (Press escape to close)" data-lity-close>&times;</button></div></div></div>'
        };
        backend_lightbox_seats = lity('#mec-seat-seats-settings-wrap',options);
    });

    $(document).on('click','#mec-seat-seats-settings-wrap .mec-seat-close-lity',function(e){
        e.preventDefault();

        $.each(demo_settings,function(i,demo_setting){

            $('[name="'+demo_setting.name+'"]').val(demo_setting.value);
        });

        var form = $('#mec-seat-seats-settings-wrap .mec-seat-areas');

        var areas_data = {};
        var area_ids = [];
        $.each(saved_area,function(i,area){

            areas_data[area.id] = area;
            area_ids.push(parseInt(area.id));
        });


        $.each($('.mec-area-item', form),function(i,area){

            var item_fields = $(area).find('.mec-seat-area-form-fields');
            var item_id = item_fields.data('item_id');
            if( '{{id}}' === item_id ){

                return;
            }

            if( -1 === $.inArray( parseInt(item_id), area_ids ) ){

                $(area).remove();
                return;
            }

            var area_data = areas_data[ item_id ];

            mec_seat_render_setting_area_title( form, item_fields.closest('.mec-area-item'),  area_data.title );

            $.each(area_data, function( field_key, field_value ){

                item_fields.find('[data-key="'+field_key+'"]').val( field_value );
            });


            areas_data[ item_id ] = '';
        });

        var last_item_id;
        $.each(areas_data,function(item_id,area){

            if( 0 === area.length ){

                last_item_id = item_id;
                return;
            }

            var html = $('#mec-seat-area-default', form).html();
            html = html.replaceAll('{{id}}',area.id);
            html = html.replaceAll('{{number_of_seats}}',area.number_of_seats);
            html = html.replaceAll('{{rows}}',area.rows);
            html = html.replaceAll('{{title}}',area.title);
            html = html.replaceAll('{{description}}',area.description);
            html = html.replaceAll('{{shape_type}}',area.shape_type);
            html = html.replaceAll('{{number_of_seats_in_shape}}',area.number_of_seats_in_shape);

            html = html.replaceAll('{{seat_booked}}',area.seat_booked);
            html = html.replaceAll('{{seat_handicap_accessible}}',area.seat_handicap_accessible);
            html = html.replaceAll('{{seat_description}}',area.seat_description);
            html = html.replaceAll('{{seat_selected_color}}',area.seat_selected_color);
            html = html.replaceAll('{{seat_not_selected_color}}',area.seat_not_selected_color);

            if( $('mec-area-item-'+last_item_id).length ){

                $('mec-area-item-'+last_item_id).insertAfter(html);
            }else{

                $(form).append(html);
            }
        });

        new_seat_layout_data = cache_seat_layout_data;
        $('#mec-seat-layout-data').val( saved_data );
        $('.mec-seat-areas input:first').trigger('change');
        window.onbeforeunload = null;

        backend_lightbox_seats.close();

        return false;
    });

    $(document).on('click','#mec-seat-save-seats-settings',function(e){
        e.preventDefault();

        backend_lightbox_seats.close();

        return false;
    });


    $(document).on('click', '#mec-seat-seats-settings-wrap .mec-seat-demo label',function(e){
        e.preventDefault();

        var popup = $('#mec-seat-popup-demo-data');
        var target = $(this).data('target');

        $('.mec-seat-html-id').val(target);

        var color = $('[name="mec[settings][demo_settings]['+target+']"]').val();
        popup.find('.mec-seat-demo-color').val(color).trigger('change');

        var options = {
            template: '<div class="lity mec-seat-seats-settings-lity-wrap" role="dialog" aria-label="Dialog Window (Press escape to close)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Loading...</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Close (Press escape to close)" data-lity-close>&times;</button></div></div></div>'
        };
        lightbox_demo = lity(popup,options);
    });

    $(document).on('click','#mec-seat-popup-demo-data .mec-seat-close-lity',function(e){
        e.preventDefault();

        window.onbeforeunload = null;

        lightbox_demo.close();

        return false;
    });

    $(document).on('click','#mec-seat-update-demo',function(e){
        e.preventDefault();

        var form = $('#mec-seat-popup-demo-data');

        var target = form.find('.mec-seat-html-id').val();
        var color = form.find('.mec-seat-demo-color').val();
        $('[name="mec[settings][demo_settings]['+ target +']"]').val(
            color
        );

        $('body').append('<style>#mec-seat-seats-settings-wrap{--mec-seat-color-'+target+': '+color+';}</style>');

        window.onbeforeunload = true;

        lightbox_demo.close();

        return false;
    });


    $('.mec-seat-areas input:first').trigger('change');

    var onbeforeunload = function(){
        window.onbeforeunload = function () {

            return true;
        }
    }
    $(document).on('mec_seat_data_is_changed',onbeforeunload);
    $(document).on('mec_seat_changed_areas',onbeforeunload);
    $(document).on('mec_seat_added_area',onbeforeunload);

    $('.mec-fes-sub-button').on('click',function(){
        window.onbeforeunload = null;
    });

    $('form[name="post"]').on('submit',function(){
        window.onbeforeunload = null;
    });

    $('.mec-seat-ticket').select2();
});
