function mec_num_to_ss_column(num){
    let s = '', t;

    while (num > 0) {
      t = (num - 1) % 26;
      s = String.fromCharCode(65 + t) + s;
      num = (num - t)/26 | 0;
    }
    return s || undefined;
}

function mec_seat_get_areas_localize_data( occurrence ){
    var data = mec_seat_layout_frontend[occurrence];

    return data;
}

function mec_seat_can_select_seat( seatData, occurrence, selectedSeats = false, el = false, selected_ticket_id = '', display_error = true ){

    var data = mec_seat_get_areas_localize_data(occurrence);
    if( 'undefined' == typeof data ){
        return true;
    }

    var $wrap = el ? jQuery( el ).closest('.mec-seat-layout') : jQuery('body');

    var TicketsInfo = data['tickets_info'];
    var allowedTickets = data['allowed_tickets'];
    var notAllowedText = data['not_allowed_text'];
    var ticket_ids = 'undefined' !== typeof seatData.mec_seat_ticket && null !== seatData.mec_seat_ticket && seatData.mec_seat_ticket.length ? seatData.mec_seat_ticket : [];

    ticket_ids = jQuery.isArray(ticket_ids) ? ticket_ids : ticket_ids.split(',');

    var is_allowed_tickets = false;
    jQuery.each(ticket_ids,function(i,ticket_id){

        if( selected_ticket_id.length && ticket_id != selected_ticket_id ){

            return;
        }

        if( 'undefined' !== typeof allowedTickets[ticket_id] && 0 != allowedTickets[ticket_id] ){

            is_allowed_tickets = is_allowed_tickets || true;
        }
    });

    if( !is_allowed_tickets ) {

        return false;
    }

    var sum_tickets = {};
    if( selectedSeats.length > 0 ){

        jQuery.each(selectedSeats,function(i,seat){

            if( seat.occurrence != occurrence ) {

                return;
            }

            seat_html_id = '#mec-seat-' + occurrence + '-' + seat.AreaCode + '-' + seat.GridRowId + '-' + seat.GridSeatNum;+ seat.GridSeatNum;
            var s_selected_ticket_id = $wrap.find(seat_html_id).data('mec_seat_selected_ticket_id');
            if( s_selected_ticket_id ){
                sum_tickets[ s_selected_ticket_id ] = 'undefined' !== typeof sum_tickets[ s_selected_ticket_id ] ? ++sum_tickets[ s_selected_ticket_id ] : 1;
            }
        });

    }

    if( -1 == selected_ticket_id || ( selected_ticket_id.length && sum_tickets[ selected_ticket_id ] >= allowedTickets[ selected_ticket_id ] ) ){
        if( display_error ) {
            var message = notAllowedText;
            jQuery('body').append('<div id="mec-seat-alert-box"><div class="inner"><i class="mec-fa-warning"></i><span class="text">' + message + '</span></div></div>');
            setTimeout(function(){
                jQuery('#mec-seat-alert-box').fadeOut(300,function(){
                    jQuery('#mec-seat-alert-box').remove();
                });
            }, 3000);
        }

        return false;
    }

    return true;
}

function mec_seat_add_areas( data, element ){

    var occurrence = jQuery(element).data('occurrence');
    var seatLayoutData = data['layout'];
    var seatAreasData = data['areas'];
    var numberOfSeat = data['number_of_seats'];
    var allowedTickets = data['allowed_tickets'];
    var bookedSeatsNumbers = data['booked_seats_numbers'];
    var selected_seats = 'undefined' !== typeof data['selected_seats'][occurrence] ? data['selected_seats'][occurrence] : [];

    if( 'undefined' == typeof seatLayoutData || 'undefined' == typeof seatAreasData ){
        return;
    }

    var max_number_of_seats = 1;
    var number_of_seats,rows;

    var seatNumber = 1,GridRowId = 1;
    var colAreas = {};
    colAreas['objArea'] = [];
    var savedObjectArea = {};

    if (
        'undefined' != typeof seatLayoutData
        &&
        'undefined' != typeof seatLayoutData.data
        &&
        'undefined' != typeof seatLayoutData.data.seatLayout
        &&
        'undefined' != typeof seatLayoutData.data.seatLayout.colAreas
        &&
        'undefined' != typeof seatLayoutData.data.seatLayout.colAreas.objArea
    ){
        savedObjectArea = seatLayoutData.data.seatLayout.colAreas.objArea;
    }
    var seat_number2 = 0;
    jQuery.each( seatAreasData, function(area_key, area_data){

        id = parseInt(area_data.id);
        number_of_seats = parseInt(area_data.number_of_seats);
        rows = parseInt(area_data.rows);
        title = area_data.title;
        shape_type = 'undefined' !== typeof area_data.shape_type && area_data.shape_type.length ? area_data.shape_type : 'line';
        number_of_seats_in_shape = 'undefined' !== typeof area_data.number_of_seats_in_shape && area_data.number_of_seats_in_shape.length ? parseInt(area_data.number_of_seats_in_shape) : 0;

        max_number_of_seats = Math.max(max_number_of_seats, number_of_seats);

        var objRows = [];
        for( var j = 1; j <= rows; j++ ){

            var rowSeatNumber = 1;
            var objSeat =[];
            var RowData = {};
            if( 'undefined' != typeof savedObjectArea[area_key].objRow[j-1].RowData ){

                RowData = savedObjectArea[area_key].objRow[j-1].RowData;
            }
            var custom_row_id = 'undefined' !== typeof RowData.custom_row_id && RowData.custom_row_id.length ? RowData.custom_row_id : '';
            for( var i = 1; i <= number_of_seats; i++ ){

                options = {};
                if(
                    'undefined' != typeof savedObjectArea[area_key]
                    &&
                    'undefined' != typeof savedObjectArea[area_key].objRow
                    &&
                    'undefined' != typeof savedObjectArea[area_key].objRow[j-1]
                    &&
                    'undefined' != typeof savedObjectArea[area_key].objRow[j-1].objSeat
                    &&
                    'undefined' != typeof savedObjectArea[area_key].objRow[j-1].objSeat[i-1]
                    ){
                    options = savedObjectArea[area_key].objRow[j-1].objSeat[i-1];
                }

                if( 'undefined' == typeof options['mec_seat_ticket'] || 0 === Object.keys(options['mec_seat_ticket']).length ) {

                    options['mec_seat_ticket'] = Object.keys(mec_seat_event_tickets);
                }

                options = jQuery.extend(
                    options,
                    {
                        'GridSeatNum': rowSeatNumber,
                        'SeatStatus': '0',
                        'seatNumber': i,
                        'mec_seat_number': seatNumber,
                        'occurrence': occurrence,
                    }
                );

                rowSeatNumber++;

                var is_selected = 'undefined' !== typeof selected_seats[ seatNumber ] ? true : false;
                if( !is_selected ){

                    if('yes' === options.mec_seat_booked){

                        options['SeatStatus'] = '1';
                    }

                    if( -1 != jQuery.inArray(seatNumber + '',bookedSeatsNumbers) ){
                        options['SeatStatus'] = '1';
                    }

                    if( !mec_seat_can_select_seat( options, occurrence ) ){
                        options['SeatStatus'] = '1';
                    }
                }


                if( 'undefined' === typeof options.mec_seat_status || 'no' !== options.mec_seat_status ) {
                    options.seat_number2 = ++seat_number2;
                }

                objSeat.push( options );

                seatNumber++;

            }

            objRows.push({
                'GridRowId': GridRowId,
                'PhyRowId': custom_row_id ? custom_row_id : mec_num_to_ss_column(GridRowId),
                'objSeat': objSeat,
            });

            GridRowId = ++GridRowId;
        }

        var row = {
            'AreaDesc': title,
            'AreaCode': id,
            'AreaNum': id,
            'HasCurrentOrder': true,
            'shapeType': shape_type,
            'numberOfSeatsInShape': number_of_seats_in_shape,
            'objRow': objRows,
        };

        colAreas['objArea'].push( row );
    });

    colAreas['intMinSeatId'] = 2;
    colAreas['intMaxSeatId'] = parseInt(max_number_of_seats);
    colAreas['Count'] = colAreas['objArea'].length;

    var seatData = {
        'product_id': occurrence,
        'freeSeating': false,
        'tempTransId': occurrence,
        'seatLayout': {
            'colAreas': colAreas
        },
        'areas': [],
        'groupedSeats': [],
    };

    jQuery( element ).seatLayout({
        data: seatData,
        showActionButtons: false,
        numberOfSeat: parseInt(numberOfSeat),
        demo_screen_text: mec_seat.demo_screen_text,
        demo_booked_text: mec_seat.demo_booked_text,
        demo_available_text: mec_seat.demo_available_text,
        demo_selected_text: mec_seat.demo_selected_text,
        demo_number_of_seats_text: mec_seat.demo_number_of_seats_text,
        demo_available_seats_text: mec_seat.demo_available_seats_text,
        handicap_accessible_text: mec_seat.handicap_accessible_text,
        callOnSeatSelect: function(e, dataToPass, el){


        },
        callOnSeatRender: function(_obj){

            _obj.seat_status = 'no' !== _obj.mec_seat_status;

            return _obj;
        },
        callCanSeatSelect: function(e, seatData, selectedSeats, selected_ticket_id = '', display_error = true ){

            var li = 'undefined' !== typeof e.currentTarget ? e.currentTarget : e;
            var occurrence = jQuery(li).closest('.mec-seat-layout').data('occurrence');
            if( !mec_seat_can_select_seat( seatData, occurrence, selectedSeats, e, selected_ticket_id, display_error ) ){
                return false;
            }

            return true;
        },
    });

    jQuery.each(selected_seats,function(seat_number,ticket_id){

        var $seat = jQuery('[data-seat-number="'+seat_number+'"]', element);

        $seat.trigger('click',[ticket_id]);
    });

    jQuery(document).trigger('mec_seat_layout_init');
}

function mec_seat_module_init($){

    if( 0 == $('.mec-seat-layout').length ){
        return;
    }

    $('.mec-seat-layouts-wrap .mec-seat-dates').on('change',function(e){

        var target = $(this).find('option:selected').data('target');

        $('.mec-seat-layouts-wrap .mec-seat-layouts-tabs-contents > div').removeClass('active');

        $('.mec-seat-layouts-wrap .mec-seat-layouts-tabs-contents').find(target).addClass('active');
        $('.mec-seat-layouts-wrap .mec-seat-layouts-tabs-contents').find(target+"-info").addClass('active');


        return false;
    }).trigger('change');

    $.each($('.mec-seat-layout'), function(i,v){

        var occurrence  = $(v).data('occurrence');
        var data = mec_seat_get_areas_localize_data(occurrence);
        if( 'undefined' == typeof data ){
            return;
        }

        mec_seat_add_areas( data, v );
    });

    $(document).on('mec_changed_seats', function(e, element, selectedSeats){

        var layout = $(element).parents('.mec-seat-layout');
        var occurrence = layout.data('occurrence');
        var seatsNumbers = {};
        jQuery.each(selectedSeats,function(i,seat){

            if( seat.occurrence != occurrence ) {

                return;
            }

            seat_html_id = '#mec-seat-' + occurrence + '-' + seat.AreaCode + '-' + seat.GridRowId + '-' + seat.GridSeatNum;

            seatsNumbers[seat.mec_seat_number] = layout.find(seat_html_id).data('mec_seat_selected_ticket_id');
        });

        $(".mec-seat-layout-data-"+occurrence).val( JSON.stringify(seatsNumbers) );
    });

    $(document).on('mec_changed_seats', function(e, element, selectedSeats){

        var layout = $(element).closest('.mec-seat-layout');
        var occurrence = layout.data('occurrence');
        var seats = [];
        jQuery.each(selectedSeats,function(i,seat){

            if( seat.occurrence != occurrence ) {

                return;
            }

            if( 'seat_number' == mec_seat_get_display_seat_type() ) {
                var seat_id = seat.seat_number2;
            }else{
                var seat_id = seat.PhyRowId + "" + seat.GridSeatNum;
            }

            seats.push( seat_id );
        });

        $(".mec-seat-selected-seats-"+occurrence + " .seats").html( seats.join(' - ') );
    });

    $(document).on('mec_changed_seats', function(e, element, selectedSeats){

        var pattern = mec_seat_event_pattern_price;
        var total_price = 0;
        $.each( $('.mec-seat-layout'), function( i, layout_wrap ){

            $.each( $('.mec-seat.current-selected',layout_wrap),function(i,seat){

                var id = $(seat).attr('id');
                if( 'undefined' !== typeof id && 0 === id.length ){

                    return;
                }

                var ticket_prices = $(seat,layout_wrap).data('mec_seat_ticket_price');
                if( 'undefined' !== typeof ticket_prices ){

                    var selected_ticket_id = jQuery('#'+id,layout_wrap).data('mec_seat_selected_ticket_id');
                    var ticket_price = 'undefined' !== typeof ticket_prices[selected_ticket_id] ? parseFloat( ticket_prices[selected_ticket_id] ) : 0;
                    total_price += parseFloat( ticket_price );
                }
            });
        });

        total_price = pattern.replace('{{PRICE}}', parseFloat( total_price ).toFixed(2) );
        $('#mec-seat-layouts-wrap .mec-seat-price .price').html( total_price );
    });
}

jQuery(document).ready(function ($) {
    mec_seat_module_init($);

    var selected_seats;
    var lightbox_seats;
    $(document).on('click','#mec-seat-open-seats',function(e){
        e.preventDefault();


        selected_seats = $('.mec-seat-selected-seats-input').serializeArray();

        var options = {
            template: '<div class="lity mec-seat-seats-settings-lity-wrap" role="dialog" aria-label="Dialog Window (Press escape to close)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Loading...</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Close (Press escape to close)" data-lity-close>&times;</button></div></div></div>'
        };
        lightbox_seats = lity('#mec-seat-layouts-wrap',options);

        return false;
    });

    $(document).on('click','.mec-seat-back-lity',function(e){
        e.preventDefault();

        $.each(selected_seats,function(i,input){
            var occurrence = $('[name="'+input.name+'"]').attr('id').replace('mec-seat-layout-data-','');
            var seat_layout_wrap = $('[data-occurrence="'+ occurrence +'"]');
            seat_layout_wrap.find('.seat-selection .current-selected').trigger('click');

            if( input.value.length ) {

                $.each(JSON.parse(input.value),function(seat_number,ticket_id){

                    seat_layout_wrap.find('.mec-seat[data-seat-number="'+seat_number+'"]').trigger('click',[ticket_id]);;
                });
            }
        });

        lightbox_seats.close();

        return false;
    });

    $(document).on('click','#mec-seat-save-seats',function(e){
        e.preventDefault();

        lightbox_seats.close();

        return false;
    });
});