/*!
* Seat Layout Library v0.01
* Copyright (c) 2017 Sachin Kurkute
* MIT License : https://github.com/SachinKurkute/movie-seat-layout/blob/master/LICENSE
*/

var handicap_svg = '<svg xmlns="http://www.w3.org/2000/svg" width="15.619" height="19.997" viewBox="0 0 15.619 19.997"><path id="mec-handicap-icon" d="M-9368.22,1063.545a6.072,6.072,0,0,1-.489-8.038l1.552,1.552a3.9,3.9,0,0,0-.221,4.024,3.9,3.9,0,0,0,3.452,2.077,3.892,3.892,0,0,0,2.191-.675l1.553,1.552a6.054,6.054,0,0,1-3.739,1.289A6.066,6.066,0,0,1-9368.22,1063.545Zm7.187-1.667a3.91,3.91,0,0,0-.12-5.4,3.907,3.907,0,0,0-5.4-.12l-1.535-1.536a6.055,6.055,0,0,1,3.177-1.571l2.942-3.349-1.667-.969-2.014,1.8a1.189,1.189,0,0,1-1.679-.1,1.188,1.188,0,0,1,.1-1.679l2.658-2.37a1.187,1.187,0,0,1,1.387-.141s5.442,3.161,5.452,3.168a1.173,1.173,0,0,1,.528.753,1.387,1.387,0,0,1-.291,1.3l-2.279,2.6,4.142-.23a1.184,1.184,0,0,1,.917.357,1.177,1.177,0,0,1,.332.924l-.5,6.143a1.186,1.186,0,0,1-1.181,1.091h-.1a1.187,1.187,0,0,1-1.089-1.279l.391-4.786-1.6.089a6.073,6.073,0,0,1-1.033,6.834Zm2.126-14.559a1.99,1.99,0,0,1,1.989-1.99,1.991,1.991,0,0,1,1.99,1.99,1.991,1.991,0,0,1-1.99,1.99A1.99,1.99,0,0,1-9358.907,1047.318Z" transform="translate(9370 -1045.328)" fill="#3f4244"/></svg>';

function mec_seat_get_display_seat_type(){

    return mec_seat.display_seat_id_type;
}

function mec_seat_prepare_data(_seatObj){

    if( 'undefined' === typeof _seatObj.classes ){
        _seatObj.classes = '';
    }

    if( 'undefined' === typeof _seatObj.html ){
        _seatObj.html = '';
    }

    if( 'undefined' === typeof _seatObj.data_attributes ){
        _seatObj.data_attributes = '';
    }

    if( 'undefined' === typeof _seatObj.styles ){
        _seatObj.styles = '';
    }

    var description = 'undefined' !== typeof _seatObj.mec_seat_description && _seatObj.mec_seat_description ? _seatObj.mec_seat_description : '';
    var is_handicap_accessible = 'undefined' !== typeof _seatObj.mec_seat_description && 'yes' == _seatObj.mec_seat_handicap_accessible ? true : false;

    if( 'undefined' === typeof _seatObj.mec_seat_ticket || _seatObj.mec_seat_ticket.length == 0 ){

        _seatObj.mec_seat_ticket = 'undefined' !== typeof mec_seat_event_tickets && 'undefined' !== typeof Object.keys(mec_seat_event_tickets)[0] ? Object.keys(mec_seat_event_tickets) : [];
    }

    var ticket_ids = 'undefined' !== typeof _seatObj.mec_seat_ticket ? _seatObj.mec_seat_ticket : event_ticket_ids;
    ticket_ids = jQuery.isArray( ticket_ids ) ? ticket_ids : ( ticket_ids.length ? [ ticket_ids ] : [] );

    var _ticket_prices = {};
    var ticket_prices = {};
    var ticket_names = {};
    jQuery.each(ticket_ids, function(i,ticket_id){

        var _ticket_price = 'undefined' !== typeof mec_seat_event_tickets[ticket_id] && 'undefined' !== typeof mec_seat_event_tickets[ticket_id]['_price'] ? mec_seat_event_tickets[ticket_id]['_price'] : 0;
        var ticket_price = 'undefined' !== typeof mec_seat_event_tickets[ticket_id] && 'undefined' !== typeof mec_seat_event_tickets[ticket_id]['price'] ? mec_seat_event_tickets[ticket_id]['price'] : 0;
        var ticket_name = 'undefined' !== typeof mec_seat_event_tickets[ticket_id] && 'undefined' !== typeof mec_seat_event_tickets[ticket_id]['name'] ? mec_seat_event_tickets[ticket_id]['name'] : '';

        _ticket_prices[ ticket_id ] = _ticket_price;
        ticket_prices[ ticket_id ] = ticket_price;
        ticket_names[ ticket_id ] = ticket_name;
    });

    if( 'seat_number' == mec_seat_get_display_seat_type() ) {

        var description_html = '<dl class="seat_number_wrap">'
                + '<dl class="seat_number"><dt>' + mec_seat.seat_number_text2 + '</dt><dd>' + _seatObj.seat_number2
                + '</dd></dl>'
            + '</dl>';
    }else{
        var description_html = '<dl class="seat_number_wrap">'
            + '<dl class="row_number"><dt>' + mec_seat.row_number_text + '</dt><dd>' + _seatObj.PhyRowId + '</dd></dl>'
            + '<dd class="separator"></dd>'
            + '<dl class="seat_number"><dt>' + mec_seat.seat_number_text + '</dt><dd>' + _seatObj.GridSeatNum + '</dd></dl>'
        + '</dl>';
    }

    if( Object.keys(ticket_names).length ){

        description_html += '<dd class="ticket">' + Object.values(ticket_names).join(' | ') + '</dd>';
    }

    if( Object.keys(ticket_prices).length ){

        _seatObj.data_attributes += ' data-mec_seat_ticket_price = \'' + JSON.stringify(_ticket_prices) + '\' ';
        description_html += '<dl class="ticket-price"><dt>'+ mec_seat.ticket_price_text +'</dt><dd>' + Object.values(ticket_prices).join(' | ') + '</dd></dl>';
    }

    if( is_handicap_accessible && undefined !== typeof mec_seat.handicap_accessible_text &&  mec_seat.handicap_accessible_text.length ){

        description_html += '<dd class="mec-is-handicap-accessible">' + handicap_svg + mec_seat.handicap_accessible_text + '</dd>';
        _seatObj.classes += 'mec-seat-handicap-accessible ';
    }

    if( description.length ){

        description_html += '<p class="description">' + description + '</p>';
    }

    if( 'undefined' !== typeof _seatObj.mec_seat_selected_color && _seatObj.mec_seat_selected_color ){
        _seatObj.data_attributes += 'data-mec_seat_selected_color = "' + _seatObj.mec_seat_selected_color + '"';
        _seatObj.styles += '--mec-seat-color-selected: ' + _seatObj.mec_seat_selected_color + ';';
        _seatObj.classes += 'mec-selected-custom-background ';
    }

    if( 'undefined' !== typeof _seatObj.mec_seat_not_selected_color && _seatObj.mec_seat_not_selected_color ){
        _seatObj.data_attributes += 'data-mec_seat_not_selected_color = "' + _seatObj.mec_seat_not_selected_color + '"';
        _seatObj.styles += '--mec-seat-color-available: ' + _seatObj.mec_seat_not_selected_color + ';'
        _seatObj.classes += 'mec-not-selected-custom-background ';
    }

    if( description ){
        _seatObj.data_attributes += 'data-mec_seat_description = "' + description + '"';
    }

    _seatObj.classes += 'mec-seat-tooltip ';
    _seatObj.html = ' <div class="mec-seat-tooltiptext">'+ description_html +'</div> ';

    if( ticket_ids ){
        _seatObj.data_attributes += ' data-mec_seat_ticket = "' + ticket_ids.join(',') + '" ';
    }

    if( ticket_ids.length > 1 ) {

        _seatObj.classes += 'mec-seat-multi-ticket ';
    }

    return _seatObj;
}

(function ($) {

    var lightbox_seat;

    $(document).on('click','#mec-seat-popup-seat-data .mec-seat-close-lity',function(e){
        e.preventDefault();

        lightbox_seat.close();

        return false;
    });

    function Movieseat(_paramObject) {
        var maxSeat, minSeat, pluginOptions = $.extend({},_paramObject.options);
        var getMainLayoutFunc = function (_obj) {
            maxSeat = _obj.intMaxSeatId;
            minSeat = _obj.intMinSeatId;
            var _html = "<div class='seat-selection' style='width:" + (maxSeat + 1) * 25.5 + "px'>";
            if( _obj.objArea.length ){

                _html += "<div class='movie-screen "+ pluginOptions.classes.screen +"'>"+ pluginOptions.demo_screen_text +"</div>"

                _html += '<div data-seat-area="0" class="mec-seat-area seat-area "><ul class="seat-area-row seat-col-numbers">';
                for (var col = 0; col <= maxSeat+1; col++) {

                    _html += '<li class="seat-row-seat">'+ (col && col != maxSeat+1 ? col : '') +'</li>';
                }
                _html += '</ul></div>';
            }

            for (var i = 0; i < _obj.objArea.length; i++) {
                _html += getAreaLayoutFunc(_obj.objArea[i]);
            }
            var actionPanel = pluginOptions.showActionButtons?"<div class='seat-proccess-panel'> <button  type='button' class='layout-action-btn layout-btn-cancel  "+ pluginOptions.classes.cancelBtn +"'> Cancel </button> <button type='button' class='layout-action-btn layout-btn-done "+ pluginOptions.classes.doneBtn +"'> Done </button> </div>":"";
            _html += actionPanel +"</div>";
            _html += "<div class='mes-seats-footer'>";
            if( undefined !== typeof pluginOptions.demo_booked_text &&  pluginOptions.demo_booked_text.length ){

                _html += '<div class="mec-seat-demo"><ul>'
                        +'<li class="mec-seat"><span style="background-color: #ecf0f1 !important;"></span></li><label>' + pluginOptions.demo_available_text + '</label>'
                        +'<li class="mec-seat mec-seat-customized mec-seat-booked"><span style=""></span></li><label>' + pluginOptions.demo_booked_text + '</label>'
                        +'<li class="mec-seat mec-seat-selected current-selected"><span style=""></span></li><label>' + pluginOptions.demo_selected_text + '</label>'
                    +'</ul></div>';
            }

            var numberOfSeat = jQuery('.mec-seat-area ul li.mec-seat:not(.mec-seat-empty)', $(_html)).length;
            var availableSeat = jQuery('.mec-seat-area ul li.can-select', $(_html)).length;
            if( undefined !== typeof pluginOptions.demo_number_of_seats_text &&  pluginOptions.demo_number_of_seats_text.length ){

                _html += '<div class="mec-seat-number-of-seat">' + pluginOptions.demo_number_of_seats_text + ': ' + numberOfSeat + '&nbsp;&nbsp;&nbsp;&nbsp;' + pluginOptions.demo_available_seats_text + ': ' + availableSeat + '</div>'
            }

            _html += "</div>";
            return _html;
        }
        var getAreaLayoutFunc = function (_obj) {
            id = _obj.AreaCode;
            var custom_view = 'undefined' !== typeof _obj.shapeType ? _obj.shapeType : 'line';
            var _html = "<div id='mec-seat-area-"+ id +"' data-seat-area='"+ id +"' class='mec-seat-area seat-area "+ pluginOptions.classes.area +" mec-seat-area-"+ custom_view +"-wrap'>";
            _html += "<div class='seat-area-desc'>" + _obj.AreaDesc + "</div>";
            for (var i = 0; i < _obj.objRow.length; i++) {
                _html += getRowLayoutFunc(_obj.objRow[i], _obj);
            }
            _html += "</div>";
            return _html;
        }
        var getRowLayoutFunc = function (_obj, _area) {

            var dataString = JSON.stringify(_obj.RowData);
            var id = 'mec-seat-' + _area.AreaCode + '-' + _obj.GridRowId;
            var _html = "<ul class='seat-area-row "+ pluginOptions.classes.row +"'> <li id='" + id + "'class='seat-row-seat row-indicator' data-seatdefination='" + dataString + "'>" + _obj.PhyRowId + "</li>";
            var custom_view = 'undefined' !== typeof _area.shapeType ? _area.shapeType : 'line';
            var custom_view_count = 'undefined' !== typeof _area.numberOfSeatsInShape ? _area.numberOfSeatsInShape : 0;
            var totalSpace = 0;
            for (var i = 0; i < _obj.objSeat.length; i++) {
                if (i == 0) {
                    var startSpace = _obj.objSeat[i].GridSeatNum - minSeat - (_obj.objSeat[i].GridSeatNum - _obj.objSeat[i].seatNumber);
                    if (startSpace > 0) {
                        for (var k = 0; k < startSpace; k++) {
                            _html += getSeatLayoutFunc({}, false, _obj, _area);
                        }
                    }
                }
                var extraSpace = parseInt(_obj.objSeat[i].GridSeatNum - (_obj.objSeat[i].seatNumber + totalSpace));
                if (extraSpace > 0) {
                    totalSpace += extraSpace;
                    for (var j = 0; j < extraSpace; j++) {
                        _html += getSeatLayoutFunc({}, false, _obj, _area);
                    }
                }

                var sn = i + 1;
                if( custom_view && 1 == sn ){

                    _html += "<ul class='mec-seat-"+ custom_view +"'>";
                }

                _html += getSeatLayoutFunc(_obj.objSeat[i], true, _obj, _area);

                if( custom_view && 0 < sn && ( 0 === ( sn % custom_view_count ) || sn === _obj.objSeat.length ) ) {

                    _html += "</ul>";

                    if( sn < _obj.objSeat.length ) {

                        _html += "<ul class='mec-seat-"+ custom_view +"'>";
                    }
                }
            }
            var endSpace = maxSeat - (_obj.objSeat.length + startSpace + totalSpace)
            if (endSpace > 0) {
                for (var l = 0; l < endSpace; l++) {
                    _html += getSeatLayoutFunc({}, false, _obj, _area);
                }
            }
            _html += "</ul>";
            return _html;
        }
        getSeatLayoutFunc = function (_obj, isSeat, _row, _area) {
            _obj.data_attributes = '';
            _obj.styles = '';
            _obj.classes = '';
            _obj.html = '';
            _obj.seat_status = true;

            _obj.GridRowId = _row.GridRowId;
            _obj.PhyRowId = _row.PhyRowId;
            _obj.AreaNum = _area.AreaNum;
            _obj.AreaCode = _area.AreaCode;
            _obj.AreaDesc = _area.AreaDesc;
            _obj = _paramObject.callSeatRender(_obj);
            if (_obj) {
                var data_attributes = _obj.data_attributes;
                var styles = _obj.styles;
                var classes = pluginOptions.classes.seat + " " + _obj.classes;
                var html = _obj.html;
                var seat_status = _obj.seat_status;

                var occurrence = 'undefined' !== typeof _obj.occurrence ? parseInt(_obj.occurrence) : '';

                delete _obj.data_attributes;
                delete _obj.styles;
                delete _obj.classes;
                delete _obj.html;

                var dataString = JSON.stringify(_obj);

                var id = '';
                if( 'undefined' !== typeof _obj.GridSeatNum ){

                    id = 'mec-seat-' + occurrence + '-' + _obj.AreaCode + '-' + _obj.GridRowId + '-' + _obj.GridSeatNum;
                }
                if ( seat_status && id.length ) {
                    if (_obj && _obj.SeatStatus == "0") {
                        classes += " can-select";
                    }else{
                        classes += " mec-seat-booked";
                    }

                    var content = '';
                    var is_handicap_accessible = 'undefined' !== typeof _obj.mec_seat_description && 'yes' == _obj.mec_seat_handicap_accessible ? true : false;
                    if( is_handicap_accessible ) {
                        content = handicap_svg;
                    }
                    var seat_number = 'undefined' !== typeof _obj.mec_seat_number ? _obj.mec_seat_number : '';
                    return "<li id='" + id +"' data-seatdefination='" + dataString + "' data-seat-number='" + seat_number + "' class='mec-seat seat-row-seat seat-yes " + classes + " ' "+ data_attributes +" style='"+ styles +"'><span>" + content + "</span>"+ html +"</li>";
                } else {
                    return "<li id='" + id +"' class='seat-row-seat mec-seat mec-seat-empty" + classes + "'></li>";
                }
            }
        }
        return {
            getAreaLayout: getAreaLayoutFunc,
            getRowLayout: getRowLayoutFunc,
            getSeatLayout: getSeatLayoutFunc,
            getMainLayout: getMainLayoutFunc
        }
    }
    $.fn.seatLayout = function (_options) {
        var _optionsObj = $.extend(true,{},{
            type:'movie',
            showActionButtons:true,
            classes : {
                doneBtn : '',
                cancelBtn : '',
                seat:'',
                row:'',
                area:'',
                screen:''
            },
            numberOfSeat:1,
            callCanSeatSelect: function(e, seatData, selectedSeats, selected_ticket_id = '', display_error = true){return true;},
            callDoSeatSelect: function(li, selectedSeats, ticket_id = ''){

                var seatData = getObjData($(li));

                var can_select = _optionsObj.callCanSeatSelect(li, seatData, selectedSeats, ticket_id);
                if( true === can_select ){

                    selectedSeats.push(seatData);

                    $(li).addClass('current-selected');

                    _el.find('.layout-btn-done').prop('disabled', !(nuberOfSeat == selectedSeats.length));
                    var dataToPass = $.extend({}, getObjData($(li)));
                    dataToPass.selected = selectedSeats;
                    _optionsObj.callOnSeatSelect(li, dataToPass, li);

                    $(li).data('mec_seat_selected_ticket_id',ticket_id);
                }

                seatData = getObjData($(li));
                $(document).trigger('mec_changed_seats', [ li, selectedSeats ] );
            },
            callPopupDoSeatSelect: function(e){

                var selectedSeats = _optionsObj.callGetSeatsSelect($(e.currentTarget));

                var form = $(e.currentTarget).closest('#mec-seat-popup-seat-data');
                var id = form.find('.mec-seat-html-id',form).val();
                var element = $('#'+id);
                var ticket_id = $('#mec-seat-tickets',form).val();

                var data = {
                    'ticket_id': ticket_id,
                };

                _optionsObj.callDoSeatSelect( $(element), selectedSeats, ticket_id );

                lightbox_seat.close();
            },
            callGetSeatsSelect: function(li){

                var selectedSeats = [];
                var layout = $(li).closest('.mec-seat-layout');
                var occurrence = layout.data('occurrence');
                $.each( $('.seat-selection .mec-seat.current-selected',layout), function( i, seat ){

                    var seatData = getObjData($(seat));

                    selectedSeats.push(seatData);
                });

                return selectedSeats;
            },
            demo_screen_text: 'Scene',
            demo_booked_text: '',
            demo_available_text: '',
            demo_number_of_seats_text: '',
            handicap_accessible_text: 'Handicap accessible',
            demo_guid_text: ''
        },_options);
        var nuberOfSeat = _optionsObj.numberOfSeat;
        var tempSelected = 0;
        var _el = this;
        var _html = "";
        var seatInstance = new Movieseat({
            callSeatRender: function (_seatObj) {

                mec_seat_prepare_data(_seatObj);

                if (_optionsObj.callOnSeatRender) {
                    return _optionsObj.callOnSeatRender(_seatObj);
                }
                return _seatObj;
            },
            options : _optionsObj
        });
        _html = seatInstance.getMainLayout(_optionsObj.data.seatLayout.colAreas);
        _el.html(_html);
        function getObjData(_ele) {
            return _ele.data('seatdefination');
        }
        _el.find('li').click(function (e,selected_ticket_id = false) {

            var seatData = getObjData($(e.currentTarget));
            var selectedSeats = _optionsObj.callGetSeatsSelect($(e.currentTarget));
            var seatTickets = 'undefined' !== typeof seatData.mec_seat_ticket && seatData.mec_seat_ticket.length > 0 ? Array.from(seatData.mec_seat_ticket) : [];
            var is_seat_multi_ticket = seatTickets.length > 1 ? true : false;

            if( $(e.currentTarget).hasClass('current-selected') ){

                $(e.currentTarget).removeClass('current-selected');
                $(e.currentTarget).data('mec_seat_selected_ticket_id','');

                selectedSeats = _optionsObj.callGetSeatsSelect($(e.currentTarget));

                $(document).trigger('mec_changed_seats', [ this, selectedSeats ] );
            }else{

                if (selectedSeats.length == nuberOfSeat) {

                    return;
                }

                if ( $(e.currentTarget).hasClass('can-select') ) {

                    var allowed_tickets = [];
                    if( seatTickets.length > 0 ){
                        $.each( seatTickets,function(i,ticket_id){
                            var can_select = _optionsObj.callCanSeatSelect(e.currentTarget, seatData, selectedSeats, ticket_id, false);
                            if( true === can_select ) {

                                allowed_tickets.push(ticket_id);
                            }
                        });
                    }

                    var is_builder = $(e.currentTarget).closest('#mec-seat-layouts-builder-wrap').length > 0 ? true : false;
                    if( allowed_tickets.length > 1 && !selected_ticket_id && !is_builder ) {

                        $('#mec-seat-popup-seat-data select#mec-seat-tickets').html('');

                        $.each( allowed_tickets,function(i,ticket_id){
                            var ticket_name = 'undefined' !== typeof mec_seat_event_tickets[ticket_id] && 'undefined' !== typeof mec_seat_event_tickets[ticket_id]['name'] ? mec_seat_event_tickets[ticket_id]['name'] : '';

                            $('#mec-seat-popup-seat-data select#mec-seat-tickets').append('<option value="' + ticket_id + '">' + ticket_name + '</option>');
                        });

                        var options = {
                            template: '<div class="lity mec-seat-layouts-select-seat-ticket-lity-wrap" role="dialog" aria-label="Dialog Window (Press escape to close)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Loading...</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Close (Press escape to close)" data-lity-close>&times;</button></div></div></div>'
                        };

                        $('#mec-seat-popup-seat-data .mec-seat-html-id').val($(e.currentTarget).attr('id'));

                        lightbox_seat = lity('#mec-seat-popup-seat-data',options);
                    }else{

                        if( !selected_ticket_id ) {

                            selected_ticket_id = allowed_tickets.length == 1 ? allowed_tickets.pop() : -1;
                        }

                        _optionsObj.callDoSeatSelect($(e.currentTarget), selectedSeats, selected_ticket_id);
                    }
                }
            }
        });

        _el.find('.layout-btn-done').prop('disabled', true);
        _el.find('.layout-btn-done').click(function (e) {
            if (_optionsObj.selectionDone) {
                _optionsObj.selectionDone({ "selected": selectedSeats });
            }
        });
        _el.find('.layout-btn-cancel').click(function (e) {
            returnFlag = true;
            if (_optionsObj.cancel) {
                returnFlag = _optionsObj.cancel(e) == false ? false : true;
            }
            if (returnFlag) {
                $(_el).remove();
                seatInstance = null;
                _optionsObj = null;
            }
        });

        $(document).off('click', '#mec-seat-popup-seat-data #mec-seat-update-seat');
        $(document).on('click', '#mec-seat-popup-seat-data #mec-seat-update-seat', _optionsObj.callPopupDoSeatSelect);

        $.each($('.mec-seat-circle'),function(i,v){

            var length = $(v).find('li').length;
            var wrap_width = $(v).width();
            var deg = 360 / length;

            var li_deg = -90;
            $.each($(v).find('li'),function(j,li){

                $(li).css('transform', 'rotate('+ li_deg +'deg) translate('+ ( ( wrap_width / 2 ) + 1 ) +'px) rotate('+ li_deg * -1 +'deg)');

                li_deg = ( li_deg + deg ) % 360;
            });
        });

        return this;
    };
})(jQuery);
