<?php
/**
 *Plugin Name: MEC Seat
 *Plugin URI: http://webnus.net/modern-events-calendar/
 *Description: This plugin will enable you to sell seats in any spot and create a layout plan for them.
 *Author: Webnus
 *Version: 1.3.0
 *Text Domain: mec-seat
 *Domain Path: /languages
 *Author URI: http://webnus.net
 **/

use MEC_Seat\CheckPlugins;

// don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

if ( ! defined( 'MEC_SEAT_FILE' ) ) {
	define( 'MEC_SEAT_FILE', __FILE__ );
}

define('MECSEATVERSION' , '1.3.0');
define('MECSEATDIR' , plugin_dir_path(__FILE__));
define('MECSEATURL' , plugin_dir_url(__FILE__));
define('MECSEATDASSETS' , MECSEATURL . '/assets/' );
define('MECSEATNAME' , 'Seat');
define('MECSEATSLUG' , 'mec-seat');
define('MECSEATOPTIONS' , 'mec_seat_integration_options');
define('MECSEATTEXTDOMAIN' , 'mec-seat');
define('MECSEATMAINFILEPATH' ,__FILE__);
define('MECSEATABSPATH', dirname(__FILE__));

if(!function_exists('mec_seat_init')){

	function mec_seat_init(){

		\MEC_Seat\Base::instance()->init();
		add_action( 'admin_init', 'mec_seat_license' );
	}

}

function mec_seat_license() {
	require_once plugin_dir_path( __FILE__ ) . 'src/checkLicense/update-activation.php';
	new \MEC_Seat\SeatAddonUpdateActivation();
}

/**
 * Include Primary Class Plugin
 */
require plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';

add_action( 'mec_init', 'mec_seat_init' );
add_action( 'admin_init', array( CheckPlugins::class, 'check_plugins') );
