<?php

namespace MEC_Seat;

use MEC\Singleton;
use MEC_Seat\Seat\BookSeat;
use MEC_Seat\Seat\BookMetaBox;
use MEC_Seat\Seat\EventMetaBox;
use MEC_Seat\Settings\SettingsPage;

/**
 * @since 1.0.0
 */
class Admin extends Singleton{

    /**
     * Init
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function init(){

        add_action('admin_menu',[$this,'add_menu']);

        if(mec_seat_is_enabled()){


            add_action('add_meta_boxes',[$this,'add_meta_boxes']);
            // add_action('mec_occurrences_fields', [ $this, 'add_custom_attendees_count_for_each_occurrences' ], 20, 3 );
            EventMetaBox::getInstance()->init();
            BookMetaBox::getInstance()->init();


            if(wp_doing_ajax()){

                $this->ajax_handler();
            }

            $is_settings_page = isset($_GET['page']) && 'MEC-settings' === $_GET['page'];
            $is_create_or_edit_page_events = ('mec-events' == get_post_type()) || (isset($_GET['post_type']) && 'mec-events' === $_GET['post_type']);
            global $pagenow;
            if( $is_settings_page || $is_create_or_edit_page_events || 'post.php' === $pagenow ){


            }

            add_action( 'admin_enqueue_scripts', [ __CLASS__, 'enqueue' ] );


            add_action( 'mec_extra_field_notifications', array( __CLASS__, 'add_seats_detail_placeholder_to_mec_field_notifications' ) );

            add_action( 'mec-settings-page-fes-form-sections-end', array( __CLASS__, 'add_seat_options_to_settings_fes_form_sections' ) );

            add_filter( 'mec_csv_export_columns', array( __CLASS__, 'filter_bookings_export_columns' ) );
            add_filter( 'mec_csv_export_booking', array( __CLASS__, 'filter_booking_export_row' ), 10, 4 );

            add_filter( 'mec_bbf_edit_event_options_response', array( __CLASS__, 'bbf_edit_event_options_response' ), 10, 4 );
            add_filter( 'mec_bbf_add_event_options_response', array( __CLASS__, 'bbf_add_event_options_response' ), 10, 5 );

		}

        SettingsPage::getInstance()->init();
    }

    /**
     * Add menu
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function add_menu(){

    }

    /**
     * Ajax Handler
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function ajax_handler(){

        add_action( 'wp_ajax_mec-seat-update-layout-data', array( '\MEC_Seat\Seat\SeatLayoutBuilder', 'update_event_layout_data_by_ajax' ) );
        add_action( 'wp_ajax_mec-seat-export-layout-data', array( '\MEC_Seat\Seat\SeatLayoutBuilder', 'export_event_layout_data_by_ajax' ) );
        add_action( 'wp_ajax_mec-seat-import-layout-data', array( '\MEC_Seat\Seat\SeatLayoutBuilder', 'import_event_layout_data_by_ajax' ) );

        add_action( 'wp_ajax_mec-seat-admin-get-seat-layout', array( __CLASS__, 'ajax_get_seat_layout' ) );

    }

    /**
     * Add meta boxes
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function add_meta_boxes(){

        $post_type = get_post_type();
        $post_type = empty($post_type) && isset($_GET['post_type']) ? $_GET['post_type'] : $post_type;

        if( 'mec-events' === $post_type ){
            add_meta_box(
                'mec-seat-options',
                __('Seat Options','mec-seat'),
                [EventMetaBox::getInstance(),'render'],
                null,
                'normal',
                'high'
            );
        }
    }

    /**
     * Enqueue scripts
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function enqueue(){

        wp_enqueue_style( 'mec-font-icons' );
        wp_enqueue_style( 'mec-seat-backend-style' );

        wp_enqueue_script( 'mec-seat-backend-script' );
    }

    /**
	 * Add seats detail placeholder to mec notifications
     *
     * @param string $section_id
	 *
	 * @hooked mec_extra_field_notifications
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public static function add_seats_detail_placeholder_to_mec_field_notifications( $section_id = '' ){

        if( 'new_event' === $section_id || 'user_event_publishing' === $section_id ){

            return;
        }

		?>
		<li><span>%%seat_numbers%%</span>: <?php esc_html_e( 'Seat Numbers', MECSEATTEXTDOMAIN ); ?></li>
		<?php
	}

    /**
	 * Add seat options to settings fes form sections
     *
     * @param array $settings
	 *
	 * @hooked mec-settings-page-fes-form-sections-end
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public static function add_seat_options_to_settings_fes_form_sections( $settings ){

        $display_seat_options = isset($settings['fes_section_seat_tbl']) and '1' == $settings['fes_section_seat_tbl'] ? true : false;
        ?>
		<div class="mec-form-row">
            <label>
                <input type="hidden" name="mec[settings][fes_section_seat_tbl]" value="0" />
                <input value="1" type="checkbox" name="mec[settings][fes_section_seat_tbl]" <?php checked($display_seat_options, true); ?> /> <?php esc_html_e('Seat Options', MECSEATTEXTDOMAIN); ?>
            </label>
        </div>
		<?php
	}

    /**
	 * Filter export columns
     *
     * @param array $columns
	 *
	 * @hooked mec_csv_export_columns
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public static function filter_bookings_export_columns( $columns ){

        $columns['seat_numbers'] = esc_html__( 'Seat Numbers', MECSEATTEXTDOMAIN );

        return $columns;
	}

    /**
     * Filter export columns
     *
     * @param array $book
     * @param int $book_id
     * @param int $event_id
     * @param array $attendee
     *
     * @hooked mec_csv_export_booking
	 *
	 * @since 1.0.0
     *
     * @return array
     */
	public static function filter_booking_export_row( $book, $book_id, $event_id, $attendee ){

        $seats_numbers = BookSeat::getInstance()->get_rendered_book_seats_numbers( $book_id );

        $seats_numbers_html = '';
        foreach( $seats_numbers as $timestamp => $numbers ){

            $numbers = is_array( $numbers ) ? implode( ', ', $numbers ) : $numbers;

            $seats_numbers_html .= (count( $seats_numbers ) > 1 ? date_i18n( 'Y-m-d H:i', $timestamp ) . ' : ' : '' ) . $numbers . PHP_EOL;
        }

        $book['seat_numbers'] = !empty( $seats_numbers_html ) ? $seats_numbers_html : '-';

        return $book;
	}


    /**
     * Return seats html
     *
     * @param array $response
     * @param int $event_id
     * @param string $date
     * @param array $tickets
     *
     * @since 1.0.0
     *
     * @return array
     */
    public static function bbf_edit_event_options_response( $response, $event_id, $date, $tickets ){

        $success = $response['success'] ?? 0;
        if( $success ){

            ob_start();
                BookMetaBox::display_edit_seats( $event_id, $date, $tickets );
            $response['seats_html'] = ob_get_clean();
        }

        return $response;
    }

    /**
     * Return seats html
     *
     * @param array $response
     * @param int $event_id
     * @param int $attendees_count
     * @param array $tickets
     * @param array $dates
     *
     * @return array
     */
    public static function bbf_add_event_options_response( $response, $event_id, $attendees_count, $tickets, $dates ){

        $all_dates = array();
        foreach( $dates as $date ){

            $start_timestamp = $date['start']['timestamp'] ?? '';
            $end_timestamp = $date['end']['timestamp'] ?? '';
            $all_dates[] = "$start_timestamp:$end_timestamp";
        }
        $all_dates = array_slice( $all_dates, 0, 1 );
        $date = current( $all_dates );


        $allowed_tickets = array();
        foreach( $tickets as $ticket ){

            $ticket_id = $ticket['id'] ?? false;
            if( false === $ticket_id ){

                continue;
            }

            $allowed_tickets[ $ticket_id ] = $attendees_count;
        }

        $success = $response['success'] ?? 0;
        if( $success ){

            ob_start();
                BookMetaBox::display_edit_seats( $event_id, $date, $allowed_tickets, $all_dates );
            $html = ob_get_clean();


            ob_start();
                if( !empty( $html ) ):
                    ?>
                        <div id="mec-edit-book-seats">
                        <hr>
                        <h3><?php esc_html_e( 'Seat Numbers', MECSEATTEXTDOMAIN ); ?></h3>
                        <?php echo $html; ?>
                    <?php
                endif;
            $response['output'] .= ob_get_clean();

        }

        return $response;
    }

    /**
     * Return seat layout by ajax
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function ajax_get_seat_layout(){

        $event_id = $_POST['event_id'] ?? false;
        $book_id = $_POST['booking_id'] ?? false;
        $all_dates = $_POST['dates'] ?? false;

        if( !$event_id || !$book_id || !$all_dates ){

            return;
        }

        $html = BookMetaBox::ajax_meta_box_seat_options( $event_id, $book_id, $all_dates, $tickets );

        wp_send_json( $html );
    }

}
