<?php


namespace MEC_Seat\Seat;

use MEC\Singleton;
use MEC\Events\Event;

/**
 * @since 1.0.0
 */
class DisplayForm extends Singleton {

	/**
	 * @var int
	 */
	private $event_id;

	/**
	 * @var \MEC\Events\Event
	 */
	private $event;

	/**
	 * @var bool
	 */
	public $enqueue;

	/**
	 * Enqueue Scripts
	 * @used: Base
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function enqueue() {

		wp_enqueue_style( 'mec-seat-frontend' );
		wp_enqueue_script( 'mec-seat-frontend' );
	}

	/**
	 * @param int $event_id
	 * @param array $tickets
	 * @param array $all_dates
	 * @param array $selected
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function output( $event_id, $tickets, $all_dates, $selected_seats = array() ) {

		$this->event_id = $event_id;
		$this->event    = new Event( $event_id );
		$event_title 	= $this->event->get_title();
		$single         = new \MEC_skin_single();

		$price_pattern = str_replace( 999.99, '{{PRICE}}', \MEC\Base::get_main()->render_price( 999.99 , $this->event_id) );
		$event_tickets  = $this->event->get_tickets();
		foreach( $event_tickets as $ticket_id => $ticket){

			$t_price = (isset($event_tickets[$ticket_id]) and isset($event_tickets[$ticket_id]['price'])) ? (new \MEC_book())->get_ticket_price($event_tickets[$ticket_id], current_time('Y-m-d'), $event_id) : 0;
            $r_price = (is_numeric($t_price) ? \MEC\Base::get_main()->render_price($t_price, $this->event_id) : $t_price);


			$event_tickets[ $ticket_id ] = array(
				'name' => $ticket['name'],
				'price' => $r_price,
				'_price' => $t_price,
			);
		}

		$css = '';
		$demo_colors = SeatLayoutBuilder::get_demo_settings_settings( $event_id );
		foreach( $demo_colors as $type => $color ){

			if( empty( $color) ){
			  continue;
			}
			$css .= '.mec-seat-layout{--mec-seat-color-' . $type .': '. $color .';}';
		  }

		  ob_start();

			echo '<script>var mec_seat_event_tickets = '. json_encode( $event_tickets ) .'</script>';
			echo '<script>var mec_seat_event_pattern_price = '. json_encode( $price_pattern ) .'</script>';
			echo '<style>'. $css .'</style>';

			$i = 0;
			$js = $contents = $sidebar_contents = $date_options = '';
			foreach( $all_dates as $date ){

				$ex = explode( ':', $date );
				$start_timestamp = $ex[0];
				$active_class = 0 == $i ? 'active' : '';

				$_GET['occurrence'] = $start_timestamp;
				$events = $single->get_event_mec( $event_id );
				$event_detail = current( $events );

				$selected = 0 == $i ? 'selected="selected"' : '';
				$date_options .= '<option value="'. esc_attr( $start_timestamp ) .'" '. $selected .' data-target="#mec-seat-layout-'. esc_attr( $start_timestamp ) .'">'.date_i18n( 'Y-m-d', $start_timestamp ).'</option>';

				$time = '';
				if (isset($event_detail->data->meta['mec_date']['start']) and !empty($event_detail->data->meta['mec_date']['start'])) {
					if (isset($event_detail->data->meta['mec_hide_time']) and $event_detail->data->meta['mec_hide_time'] == '0') {
						$time_comment = isset($event_detail->data->meta['mec_comment']) ? $event_detail->data->meta['mec_comment'] : '';
						$allday = isset($event_detail->data->meta['mec_allday']) ? $event_detail->data->meta['mec_allday'] : 0;

						if ($allday == '0' and isset($event_detail->data->time) and trim($event_detail->data->time['start'])) {

							$time = $event_detail->data->time['start'] . ' ' . (trim($event_detail->data->time['end']) ? esc_html( ' - ' . $event_detail->data->time['end'] ) : '');
						}else{

							$time = \MEC\Base::get_main()->m( 'all_day', esc_html__('All Day' , MECSEATTEXTDOMAIN) );
						}
					}
				}


				$sidebar_contents .= '<div id="mec-seat-layout-'. esc_attr( $start_timestamp ) .'-info" data-occurrence="'. esc_attr( $start_timestamp ) .'" class="'. esc_attr( $active_class ) .'">';

				$sidebar_contents .= '<div class="mec-seat-event-date mec-seat-event-detail">
								<i class="mec-sl-calendar"></i>
								<div class="mec-seat-event-bar-inner">
									<h3 class="mec-date">'. esc_html__( 'Date', MECSEATTEXTDOMAIN ) .'</h3>
									<dd><abbr class="mec-events-abbr"><span class="mec-start-date-label">'. date_i18n( 'Y-m-d', $start_timestamp ) .'</span></abbr></dd>
								</div>
							</div>';

				if( !empty( $time ) ){

					$sidebar_contents .= '<div class="mec-seat-event-time mec-seat-event-detail">
									<i class="mec-sl-clock"></i>
									<div class="mec-seat-event-bar-inner">
										<h3 class="mec-time">'. esc_html__( 'Time', MECSEATMAINFILEPATH ) .'<span></span></h3>
										<dd><abbr class="mec-events-abbr">'. $time .'</abbr></dd>
									</div>
								</div>';
				}


				$location_address = '';
				$location_id = $event_detail->data->meta['mec_location_id'] ?? 0;
				if( $location_id ){

					$location_address = get_term_meta( $location_id, 'address', true );
				}

				if( !empty( $location_address ) ){

					$sidebar_contents .= '<div class="mec-seat-event-location mec-seat-event-detail">
										<i class="mec-sl-location-pin"></i>
										<div class="mec-seat-event-bar-inner">
											<h3 class="mec-location">'. esc_html__( 'Location', MECSEATMAINFILEPATH ) .'<span></span></h3>
											<dd><abbr class="mec-events-abbr">'. $location_address .'</abbr></dd>
										</div>
									</div>';
				}

				$sidebar_contents .= '<div class="mec-seat-event-selected-seats mec-seat-event-detail">
										<svg xmlns="http://www.w3.org/2000/svg" width="14.6" height="14.6" viewBox="0 0 14.6 14.6">
											<path id="Path_42" data-name="Path 42" d="M139.823,62.083h-1.431V59.748A3.813,3.813,0,0,0,134.528,56h-3.059a3.813,3.813,0,0,0-3.864,3.752v2.335h-1.431a.175.175,0,0,0-.175.175V69.82a.175.175,0,0,0,.175.175h1.934a.175.175,0,0,0,.175-.175V67.444h9.432V69.82a.175.175,0,0,0,.175.175h1.934A.175.175,0,0,0,140,69.82V62.258a.175.175,0,0,0-.175-.175ZM138,67.094H128a.487.487,0,0,1-.486-.486V65.533a.487.487,0,0,1,.486-.487h10a.487.487,0,0,1,.486.487v1.075a.487.487,0,0,1-.487.486Zm-10.043-7.346a3.463,3.463,0,0,1,3.514-3.4h3.059a3.463,3.463,0,0,1,3.514,3.4v2.335h-.153a.175.175,0,0,0-.175.175V64.7h-9.432V62.258a.175.175,0,0,0-.175-.175h-.153Zm-1.606,9.9V62.433h1.584V64.7a.835.835,0,0,0-.77.83v1.075a.835.835,0,0,0,.77.83v2.208Zm13.3,0h-1.584V67.437a.835.835,0,0,0,.77-.83V65.533a.835.835,0,0,0-.77-.83v-2.27h1.584Z" transform="translate(-125.698 -55.696)" fill="#c1c7ce" stroke="#c1c7ce" stroke-width="0.6"/>
										</svg>
										<div class="mec-seat-event-bar-inner">
											<h3 class="mec-seats">'. esc_html__( 'Selected Seat', MECSEATMAINFILEPATH ) .'<span></span></h3>
											<dd><abbr class="mec-events-abbr mec-seat-selected-seats"><div class="mec-seat-selected-seats-' . esc_attr( $start_timestamp ) . '"><span class="seats"></span></div></abbr></dd>
										</div>
									</div>';

				$sidebar_contents .= '</div>';


				$contents .= '<div id="mec-seat-layout-'. esc_attr( $start_timestamp ) .'" data-occurrence="'. esc_attr( $start_timestamp ) .'" class="mec-seat-layout '. esc_attr( $active_class ) .'"></div>';
				$contents .= '<input type="hidden" style="display:none" class="mec-seat-selected-seats-input mec-seat-layout-data-'. esc_attr( $start_timestamp ) .'" id="mec-seat-layout-data-'. esc_attr( $start_timestamp ) .'" name="book[seats]['. esc_attr( $start_timestamp ) .']" value=""/>';

				$data = EventSeat::getInstance()->get_seat_layout_data_for_render( $event_id, $start_timestamp );
				$areas = EventSeat::getInstance()->get_seat_areas_data_for_render( $event_id, $start_timestamp );

				$booked_seats_numbers = EventSeat::get_disabled_seats_numbers( $event_id, $start_timestamp );
				$tickets = is_array( $tickets ) ? $tickets : [];
				$js .= 'mec_seat_layout_frontend["'.$start_timestamp.'"] = {
					"layout": '. wp_unslash( $data ) .',
					"areas": '. json_encode( array_values( $areas ) ).',
					"booked_seats_numbers": '. json_encode( $booked_seats_numbers ).',
					"allowed_tickets": '. json_encode( $tickets ).',
					"number_of_seats": '. (int)array_sum( $tickets ).',
					"selected_seats": '. json_encode( $selected_seats ).',
					"not_allowed_text": '. json_encode( __( 'You can not select this seat.', MECSEATTEXTDOMAIN ) ) .'
				};';

				$i++;
			}

			?>
			<div class="mec-form-row mec-seat-select-wrap">
				<button id="mec-seat-open-seats" class="button">
					<svg xmlns="http://www.w3.org/2000/svg" width="18.6" height="18.599" viewBox="0 0 18.6 18.599"><path id="Path_48" data-name="Path 48" d="M143.773,63.822h-1.84v-3A4.9,4.9,0,0,0,136.965,56h-3.933a4.9,4.9,0,0,0-4.968,4.823v3h-1.84a.225.225,0,0,0-.225.225V73.77a.225.225,0,0,0,.225.225h2.487a.225.225,0,0,0,.225-.225V70.715h12.127V73.77a.225.225,0,0,0,.225.225h2.487A.225.225,0,0,0,144,73.77V64.047a.225.225,0,0,0-.225-.225Zm-2.347,6.443H128.571a.626.626,0,0,1-.625-.625V68.258a.626.626,0,0,1,.625-.626h12.855a.626.626,0,0,1,.625.626V69.64a.626.626,0,0,1-.626.625ZM128.514,60.82a4.453,4.453,0,0,1,4.518-4.374h3.934a4.453,4.453,0,0,1,4.518,4.374v3h-.2a.225.225,0,0,0-.225.225v3.135H128.935V64.047a.225.225,0,0,0-.225-.225h-.2Zm-2.065,12.726V64.272h2.037v2.918a1.073,1.073,0,0,0-.99,1.067V69.64a1.073,1.073,0,0,0,.99,1.067v2.839Zm17.1,0h-2.037V70.707a1.073,1.073,0,0,0,.99-1.067V68.258a1.074,1.074,0,0,0-.99-1.067V64.273h2.037Z" transform="translate(-125.698 -55.696)" fill="#40d9f1" stroke="#40d9f1" stroke-width="0.6"/></svg>
					<?php esc_html_e( 'Select Seats', MECSEATTEXTDOMAIN ); ?>
				</button>

				<?php
				foreach( $all_dates as $date ){

					$ex = explode( ':', $date );
					$start_timestamp = $ex[0];
					echo '<div class="mec-seat-event-selected-seats mec-seat-event-detail">
						<svg xmlns="http://www.w3.org/2000/svg" width="14.6" height="14.6" viewBox="0 0 14.6 14.6">
							<path id="Path_42" data-name="Path 42" d="M139.823,62.083h-1.431V59.748A3.813,3.813,0,0,0,134.528,56h-3.059a3.813,3.813,0,0,0-3.864,3.752v2.335h-1.431a.175.175,0,0,0-.175.175V69.82a.175.175,0,0,0,.175.175h1.934a.175.175,0,0,0,.175-.175V67.444h9.432V69.82a.175.175,0,0,0,.175.175h1.934A.175.175,0,0,0,140,69.82V62.258a.175.175,0,0,0-.175-.175ZM138,67.094H128a.487.487,0,0,1-.486-.486V65.533a.487.487,0,0,1,.486-.487h10a.487.487,0,0,1,.486.487v1.075a.487.487,0,0,1-.487.486Zm-10.043-7.346a3.463,3.463,0,0,1,3.514-3.4h3.059a3.463,3.463,0,0,1,3.514,3.4v2.335h-.153a.175.175,0,0,0-.175.175V64.7h-9.432V62.258a.175.175,0,0,0-.175-.175h-.153Zm-1.606,9.9V62.433h1.584V64.7a.835.835,0,0,0-.77.83v1.075a.835.835,0,0,0,.77.83v2.208Zm13.3,0h-1.584V67.437a.835.835,0,0,0,.77-.83V65.533a.835.835,0,0,0-.77-.83v-2.27h1.584Z" transform="translate(-125.698 -55.696)" fill="#c1c7ce" stroke="#c1c7ce" stroke-width="0.6"/>
						</svg>
						<div class="mec-seat-event-bar-inner">
							<h3 class="mec-seats">'. esc_html__( 'Selected Seat', MECSEATMAINFILEPATH ) . ' '. date_i18n( 'Y-m-d', $start_timestamp ) .'<span></span></h3>
							<dd><abbr class="mec-events-abbr mec-seat-selected-seats"><div class="mec-seat-selected-seats-' . esc_attr( $start_timestamp ) . '"><span class="seats"></span></div></abbr></dd>
						</div>
					</div>';
				}
				?>
			</div>

			<div id="mec-seat-layouts-wrap" class="mec-seat-layouts-wrap">
				<div class="mec-seat-topbar">
					<div class="mec-seat-back-lity">
						<i class=" mec-sl-angle-left"></i>
						<?php esc_html_e( 'Back', MECSEATTEXTDOMAIN ); ?>
					</div>
					<div class="">
						<select id="mec-seat-dates" class="mec-seat-dates">
							<?php echo $date_options; ?>
						</select>
					</div>
				</div>
				<div class="mec-seats-wrap">

					<div class="mec-seats-sidebar-wrap">
						<h3 class="mec-seat-event-title"><?php echo esc_html( $event_title ) ?></h3>
						<div class="mec-seat-layouts-tabs-contents">
							<?php echo $sidebar_contents; ?>
						</div>

						<div class="mec-form-row mec-seat-total">
							<div class="mec-seat-price">
								<label><?php esc_html_e( 'Total:', MECSEATTEXTDOMAIN ); ?></label>
								<span class="price"></span>
							</div>
							<button id="mec-seat-save-seats" class="mec-col-12 button"><?php esc_html_e( 'Confirm', MECSEATTEXTDOMAIN ); ?></button>
						</div>
					</div>
					<div class="mec-seats-content-wrap">
						<div class="mec-seat-layouts-tabs-contents">
							<?php echo $contents ?>
						</div>
					</div>
				</div>
			</div>

			<div id="mec-seat-popup-seat-data" class="mec-seat-popup-seat-data mec-seat-popup-frontend lity-hide">
				<div class="mec-seat-topbar">
					<div class="title"><?php esc_html_e( 'Seat', MECSEATTEXTDOMAIN ); ?></div>
					<div class="mec-seat-close-lity">
					<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 12 12">
						<path id="close" d="M11.748.252a.86.86,0,0,1,0,1.217l-4.6,4.6,4.462,4.462a.86.86,0,0,1-1.217,1.217L5.93,7.286,1.608,11.609A.86.86,0,0,1,.391,10.392L4.713,6.069.252,1.608A.86.86,0,0,1,1.469.391L5.93,4.852l4.6-4.6A.86.86,0,0,1,11.748.252Z" fill="#939b9e"/>
					</svg>
					</div>
				</div>
				<div class="mec-seat-form-fields">
					<input type="hidden" class="mec-seat-html-id" value="">
					<div class="mec-form-row">
						<select id="mec-seat-tickets" class="mec-seat-tickets"></select>
					</div>
					<div class="mec-form-row">
						<button id="mec-seat-update-seat" class="mec-seat-update-seat button mec-col-12"><?php esc_html_e( 'Select', MECSEATTEXTDOMAIN ); ?></button>
					</div>
				</div>
			</div>

			<script> var mec_seat_layout_frontend = {};<?php echo $js ?></script>
			<script>(function($){mec_seat_module_init($);})(jQuery)</script>
			<?php
		return ob_get_clean();
	}
}