<?php

namespace MEC_Seat\Seat;

use MEC\Events\Event;
use MEC\Settings\Settings;
use MEC\Singleton;

/**
 * @since 1.0.0
 */
class EventMetaBox extends Singleton {

    /**
     * Init
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function init() {

		add_action( 'mec_event_seat_options_metabox', [$this,'meta_box_seat_options'] );

        add_action( 'save_post_mec-events', [$this,'save_event'] );
        add_action( 'edit_post_mec-events', [$this,'save_event'] );

		if(wp_doing_ajax()){

			$this->ajax_handler();
		}
	}

    /**
     * Enqueue scripts
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function enqueue(){

        ?>
        <style>
            .mec-add-seat-tabs-wrap,.mec-add-event-tabs-wrap,.mec-create-shortcode-tabs-wrap {
                display: flex;
                display: -webkit-box;
                display: -webkit-flex;
                display: -ms-flexbox;
            }

            .mec-add-seat-tabs-left,.mec-add-event-tabs-left {
                min-width: 200px;
            }

            @media(max-width: 1366px) {
                .mec-add-seat-tabs-left,.mec-add-event-tabs-left {
                    min-width:137px;
                }
            }

            .mec-add-seat-tabs-left,.mec-add-event-tabs-left,.mec-create-shortcode-tabs-left {
                flex: 1;
            }

            .mec-add-seat-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                flex: 6;
            }

            a.mec-add-seat-tabs-link,a.mec-add-event-tabs-link,a.mec-create-shortcode-tabs-link {
                display: block;
            }

            .mec-seat-tab-content,.mec-create-shortcode-tab-content,.mec-event-tab-content {
                display: none;
                transition: all .3s ease;
            }

            .mec-seat-tab-content.mec-tab-active,.mec-create-shortcode-tab-content.mec-tab-active,.mec-event-tab-content.mec-tab-active {
                display: block;
            }

            .mec-add-seat-tabs-wrap,.mec-add-event-tabs-wrap {
                background: #fff;
                margin: -6px -12px -12px;
            }

            .mec-create-shortcode-tabs-wrap {
                margin: -30px -22px -42px;
            }

            .mec-add-seat-tabs-left,.mec-add-event-tabs-left,.mec-create-shortcode-tabs-left {
                background: #f7f8f9;
            }

            .mec-add-seat-tabs-left a,.mec-add-event-tabs-left a,.mec-create-shortcode-tabs-left a {
                display: block;
                position: relative;
                outline: 0;
                padding: 13px 4px 13px 20px;
                background: #e3e5e7;
                background: 0 0;
                border: solid;
                border-width: 1px 0 1px 0;
                border-color: transparent;
                color: #3f454a;
                font-size: 13px;
                font-weight: 600;
                text-decoration: none;
                border-radius: 0;
                transition: all 0.2s ease;
            }

            .mec-add-seat-tabs-left a:first-of-type,.mec-add-event-tabs-left a:first-of-type,.mec-create-shortcode-tabs-left a:first-of-type {
                border-top: none;
            }

            .mec-add-seat-tabs-left a:hover,.mec-add-event-tabs-left a:hover,.mec-create-shortcode-tabs-left a:hover {
                background: #fff;
                color: #07bbe9;
            }

            .mec-add-seat-tabs-left a:focus,.mec-add-event-tabs-left a:focus,.mec-create-shortcode-tabs-left a:focus {
                box-shadow: none;
                outline: unset;
            }

            .mec-add-seat-tabs-left a.mec-tab-active,.mec-add-event-tabs-left a.mec-tab-active,.mec-create-shortcode-tabs-left a.mec-tab-active {
                background: #ecf9fd;
                color: #07bbe9;
                border-color: #ccecf4;
                position: relative;
                padding-left: 22px;
            }

            .inside div div > a.mec-tab-active:after,.inside div div > a.mec-tab-active:before {
                position: absolute;
                z-index: 9999;
                content: " ";
                height: 0;
                width: 0;
                border: 8px solid transparent;
                border-right-color: #fff;
                right: -1px;
                top: 13px;
            }

            .inside div div > a.mec-tab-active:before {
                border-right-color: #d7d8d9;
                right: 0;
            }

            .mec-add-seat-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                padding: 0 30px 40px;
                border-left: 1px solid #e2e2e2;
            }

            .mec-seat-tab-content.mec-tab-active,.mec-create-shortcode-tab-content.mec-tab-active,.mec-event-tab-content.mec-tab-active {
                animation: fadeEffect2 .31s;
            }

            @media(max-width: 1366px) {
                .mec-add-seat-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding:0 15px 20px;
                }

                .mec-form-row select {
                    min-width: 60px;
                }
            }

            @media (min-width: 1199px) and (max-width:1280px) {
                .mec-add-seat-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding:0 0 0 10px;
                }

                #mec_meta_box_hourly_schedule_days {
                    padding: 0 40px 0 0;
                }

                #mec_meta_box_hourly_schedule_days .mec-form-row.mec-box {
                    margin-right: -40px;
                }

                #mec_comment,#mec_cost,#mec_countdown_method,#mec_event_timezone,#mec_public,#mec_repeat_type {
                    min-width: 220px;
                    width: 220px;
                }

                #mec_meta_box_hourly_schedule_days .mec-box.mec-form-row input[type=text] {
                    max-width: 120px;
                }

                .mec-form-row .mec-time-picker select {
                    min-width: 60px;
                }

                #mec_countdown_method,#mec_repeat_type {
                    min-width: 220px;
                    width: 220px;
                }

                #mec_exceptions_in_days_container .mec-col-4 {
                    width: 25%;
                }

                #mec_exceptions_in_days_container .mec-col-3 {
                    width: 50%;
                }

                #mec_exceptions_in_days_container .mec-col-5 {
                    width: 20%;
                }

                #mec_exceptions_in_days_container input[type=text] {
                    width: 95%;
                }

                #mec_repeat_certain_weekdays_container label:not(.mec-col-3) {
                    display: block;
                    padding-left: 25%;
                }
            }

            @media (max-width: 1023px) {
                .post-type-mec-events h4 {
                    margin-top:20px
                }

                .post-type-mec-events .mec-form-row {
                    padding-bottom: 20px
                }

                .post-type-mec-events .mec-form-row .mec-form-row {
                    padding: 0
                }

                .post-type-mec-events .mec-form-row .mec-col-1,.post-type-mec-events .mec-form-row .mec-col-10,.post-type-mec-events .mec-form-row .mec-col-11,.post-type-mec-events .mec-form-row .mec-col-12,.post-type-mec-events .mec-form-row .mec-col-2,.post-type-mec-events .mec-form-row .mec-col-3,.post-type-mec-events .mec-form-row .mec-col-4,.post-type-mec-events .mec-form-row .mec-col-5,.post-type-mec-events .mec-form-row .mec-col-6,.post-type-mec-events .mec-form-row .mec-col-7,.post-type-mec-events .mec-form-row .mec-col-8,.post-type-mec-events .mec-form-row .mec-col-9 {
                    display: block;
                    width: 100%;
                    margin: 20px 0 0 0;
                    max-width: 285px
                }

                .post-type-mec-events .mec-add-seat-tabs-left,.post-type-mec-events .mec-add-event-tabs-left {
                    min-width: 180px
                }

                .post-type-mec-events .mec-add-seat-tabs-left a,.post-type-mec-events .mec-add-event-tabs-left a,.post-type-mec-events .mec-create-shortcode-tabs-left a {
                    padding-left: 10px
                }

                #mec_repeat_type,.post-type-mec-events #mec_settings_fes_thankyou_page_url,.post-type-mec-events .mec-form-row .mec-col-4 input[type=number],.post-type-mec-events .mec-form-row .mec-col-4 input[type=text],.post-type-mec-events .mec-form-row .mec-col-4 select,.post-type-mec-events .mec-form-row .mec-col-4 textarea {
                    width: 100%;
                    max-width: 255px
                }

                #mec-exceptional-days .mec-certain-day>div,#mec_exceptions_in_days_container .mec-certain-day>div {
                    width: 100%;
                    max-width: 255px;
                    padding: 12px;
                    margin: 20px 10px 0 0;
                    border-radius: 8px
                }

                .mec-certain-day .mec-in-days-day,.mec-certain-day>div .mec-not-in-days-day {
                    line-height: 21px;
                    font-size: 10px
                }

                #mec_repeat_certain_weekdays_container label {
                    display: block;
                    margin: 20px 0 20px 0
                }
            }

            @media (max-width: 640px) {
                .mec-add-seat-tabs-wrap,.mec-add-event-tabs-wrap,.mec-create-shortcode-tabs-wrap {
                    display:block
                }

                .post-type-mec-events .mec-add-seat-tabs-left,.post-type-mec-events .mec-add-event-tabs-left {
                    min-width: 100%;
                    width: 100%!important;
                    display: block!important;
                    float: unset;
                    margin: 0;
                    flex: unset;
                    height: auto
                }

                .post-type-mec-events .mec-add-seat-tabs-right,.post-type-mec-events .mec-add-event-tabs-right,.post-type-mec-events .mec-create-shortcode-tabs-right {
                    display: block;
                    min-width: 100%;
                    width: 100%;
                    margin: 0;
                    flex: unset
                }

                .post-type-mec-events .mec-add-seat-tabs-left a,.post-type-mec-events .mec-add-event-tabs-left a,.post-type-mec-events .mec-create-shortcode-tabs-left a {
                    font-size: 14px;
                    padding: 14px 10px 14px 15px;
                    line-height: 1.2;
                    letter-spacing: 0
                }

                .mec-add-seat-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding-left: 10px;
                    padding-right: 10px
                }

                #mec_tickets .mec-box {
                    max-width: 290px
                }
            }
        </style>

        <script>
            jQuery(document).ready(function($){

                function mec_seat_status_change(status){

                    if(true === status){

                        $('.mec-add-seat-tabs-left .mec-add-seat-tabs-link').show();
                        $('#mec-seat .mec-seat-option-container').show();
                    }else{

                        $('.mec-add-seat-tabs-left .mec-add-seat-tabs-link:not(:first-child)').hide();
                        $('#mec-seat .mec-seat-option-container').hide();
                    }

                }

                jQuery(".mec-add-seat-tabs-link").on("click", function(e){

                    e.preventDefault();
                    var href = jQuery(this).attr("data-href");
                    jQuery(".mec-seat-tab-content,.mec-add-seat-tabs-link").removeClass("mec-tab-active");
                    jQuery(this).addClass("mec-tab-active");
                    jQuery("#" + href ).addClass("mec-tab-active");
                });

                $('.mec_seat_status').on('change',function(e){

                    var seat_status = $(this).is(':checked');
                    mec_seat_status_change(seat_status);

                    $("input[type=checkbox].seat_form_fields_global_inheritance").trigger('change');
                });
                var seat_status = $('.mec_seat_status').is(':checked');
                mec_seat_status_change(seat_status);


                $("input[type=checkbox].seat_form_fields_global_inheritance").on('change',function(){

                    var status = $(this).is(":checked");
                    var seat_status = $('.mec_seat_status').is(':checked');

                    if(true !== status && true === seat_status){
                        $('.mec-seat-forms').show();
                    }else{
                        $('.mec-seat-forms').hide();
                    }
                });

                $("input[type=checkbox].seat_form_fields_global_inheritance").trigger('change');
            });
        </script>
        <?php
    }

    /**
     * Render meta boxes
     *
     * @param \WP_Post $event
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function render($event) {

        $this->init();

        $this->enqueue();
        ?>
        <div class="mec-add-seat-tabs-wrap">
            <div class="mec-add-seat-tabs-left">
                <a class="mec-add-seat-tabs-link mec-tab-active" data-href="mec_meta_box_seat_options_form_1" href="#"><?php echo esc_html__('Seat Options',MECSEATTEXTDOMAIN); ?></a>
                <?php if( 'auto-draft' !== $event->post_status ): ?>
                    <a class="mec-add-seat-tabs-link" data-href="mec_meta_box_seat_import_export_seats" href="#"><?php echo esc_html__('Import/Export',MECSEATTEXTDOMAIN); ?></a>
                <?php endif; ?>

                <?php do_action('add_event_seat_sections_left_menu'); ?>
            </div>
            <div class="mec-add-seat-tabs-right">
                <?php do_action('mec_event_seat_options_metabox', $event); ?>
            </div>
        </div>
        <?php
    }

    /**
     * Ajax handler
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function ajax_handler(){

    }

    /**
     * FES form enqueue scripts
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function fes_enqueue(){

        ?>
        <script>
            jQuery(document).ready(function($){
                function mec_seat_status_change(status){

                    if(true === status){
                        $('#mec-seat .mec-seat-tab-content:nth-child(n+2)').show();
                        $('#mec-seat .mec-seat-option-container').show();
                    }else{

                        $('#mec-seat .mec-seat-tab-content:nth-child(n+2)').hide();
                        $('#mec-seat .mec-seat-option-container').hide();
                    }
                }

                $('.mec_seat_status').on('change',function(e){

                    var seat_status = $(this).is(':checked');
                    mec_seat_status_change(seat_status);

                    $("input[type=checkbox].seat_form_fields_global_inheritance").trigger('change');
                });
                var seat_status = $('.mec_seat_status').is(':checked');
                mec_seat_status_change(seat_status);
            });
        </script>
        <?php
    }

    /**
     * Fes form meta boxes int
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function fes_init(){

        add_action( 'mec_fes_metabox_details', [$this,'fes_enqueue'], 99 );
        add_action( 'mec_fes_metabox_details', [$this,'meta_box_seat_options'], 99 );

        add_action( 'mec_custom_fes_form_metabox_details', [$this,'fes_enqueue'], 99 );
        add_action( 'mec_custom_fes_form_metabox_details', [$this,'meta_box_seat_options'], 99 );
    }

    /**
     * Save options
     *
     * @param int $event_id
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function save_event($event_id){

        if(!isset($_POST['mec_seat_nonce'])) return;
        if(!wp_verify_nonce(sanitize_text_field($_POST['mec_seat_nonce']), 'mec_seat_data')) return;
        if(defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return;

        $_mec = isset($_POST['mec']) ? $_POST['mec'] : [];

        $seat_status_for_this_event = isset($_POST['mec_seat_status']) ? $_POST['mec_seat_status'] : "0";
        update_post_meta($event_id,'mec_seat_status',$seat_status_for_this_event);

        $custom_seat_layout_status = isset($_POST['mec_seat_custom_seat_layout_status']) ? $_POST['mec_seat_custom_seat_layout_status'] : "0";
        update_post_meta($event_id,'mec_seat_custom_seat_layout_status',$custom_seat_layout_status);

        $data = isset( $_mec['settings']['seat_layout_data'] ) ? $_mec['settings']['seat_layout_data'] : '';
        $areas = isset( $_mec['settings']['seat_areas_data'] ) && is_array( $_mec['settings']['seat_areas_data'] ) ? $_mec['settings']['seat_areas_data'] : array();
        $demo_settings = isset( $_mec['settings']['demo_settings'] ) && is_array( $_mec['settings']['demo_settings'] ) ? $_mec['settings']['demo_settings'] : array();

        $seat_options = isset( $_mec['seat'] ) ? $_mec['seat'] : '';
        update_post_meta( $event_id, 'mec_seat', $seat_options );

        SeatLayoutBuilder::update_event_layout_data( $event_id, $data, $areas );
        SeatLayoutBuilder::update_demo_settings_settings( $event_id, $demo_settings );
    }

    /**
     * Render seat options
     *
     * @param \WP_Post $post
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function meta_box_seat_options($post){

        $action = $_REQUEST['action'] ?? false;
        $FES = (boolean) !is_admin() || ( 'elementor_ajax' === $action || 'elementor' === $action );


        $event = new Event($post);
        $event_id = $post->ID;
        $settings = Settings::getInstance()->get_settings();

        if( !(!$FES or ($FES and (!isset($settings['fes_section_seat_tbl']) or (isset($settings['fes_section_seat_tbl']) and $settings['fes_section_seat_tbl']))))){

            return;
        }

        $seat_status_for_this_event = (bool)get_post_meta($event->ID,'mec_seat_status',true);
        $custom_seat_layout_status = get_post_meta($event->ID,'mec_seat_custom_seat_layout_status',true);
        $custom_seat_layout_status = !empty( $custom_seat_layout_status ) || '0' === $custom_seat_layout_status ? (bool)$custom_seat_layout_status : true;
        $seat_options = get_post_meta($post->ID, 'mec_seat', true);
        if(!is_array($seat_options)) {
            $seat_options = array();
        }

        $seat_pending_time_global_status = $seat_options['seat_pending_time_global_status'] ?? true;
        $seat_pending_time = $seat_options['seat_pending_time'] ?? '';
        $display_seat_id   = $seat_options['display_seat_id'] ?? 'global';

        wp_nonce_field('mec_seat_data', 'mec_seat_nonce');
        ?>
        <div id="mec-seat">
            <div class="mec-meta-box-fields mec-seat-tab-content mec-tab-active" id="mec_meta_box_seat_options_form_1">

                <h4 class="mec-form-title"><?php esc_html_e('Seat Status', MECSEATTEXTDOMAIN); ?></h4>
                <div class="mec-form-row mec-seat-primary-option">
                    <label class="label-checkbox" for="mec_seat_status">
                        <input id="mec_seat_status" class="mec_seat_status" value="1" type="checkbox" name="mec_seat_status" <?php checked(true,$seat_status_for_this_event) ?> /> <?php esc_html_e( 'Enable Seat module', MECSEATTEXTDOMAIN ); ?>
                    </label>
                </div>

                <div class="mec-seat-option-container">
                    <div class="mec-meta-box-fields" id="mec_meta_box_seat_options_form_seats">
                        <h4 class="mec-title"><label for="mec_seat_custom_seat_pending_time"><?php esc_html_e('Seat Pending Time (seconds)', 'mec'); ?></label></h4>
                        <div class="mec-form-row">
                            <label class="mec-col-4" for="mec_seat_custom_seat_pending_time" id="mec_seat_custom_seat_pending_time_label">
                                <input type="hidden" name="mec[seat][seat_pending_time_global_status]" value="0"/>
                                <input id="mec_seat_custom_seat_pending_time"
                                    <?php
                                    if ($seat_pending_time_global_status == 1) {
                                        echo 'checked="checked"';
                                    }
                                    ?>
                                        type="checkbox" value="1" name="mec[seat][seat_pending_time_global_status]" onchange="jQuery(this).parent().parent().find('input[type=text]').toggle().val('');"/>
                                <?php esc_html_e('Inherit from global options', 'mec'); ?>
                            </label>
                            <input class="mec-col-4" <?php echo ($seat_pending_time_global_status == 1) ? 'style="display: none;"' : ''; ?> type="text" name="mec[seat][seat_pending_time]" id="mec_seat_pending_time"
                                    value="<?php echo esc_attr($seat_pending_time); ?>" placeholder="<?php esc_html_e('Duration', 'mec'); ?>"/>
                        </div>

                        <h4 class="title"><?php esc_html_e( 'Seats Options', MECSEATTEXTDOMAIN ); ?></h4>
                        <div class="mec-form-row">
                            <label class="mec-col-4" for="mec_seat_display_seat_id"><?php esc_html_e('Seat ID', MECSEATTEXTDOMAIN); ?></label>
                            <select class="mec-col-4" type="number" name="mec[seat][display_seat_id]" id="mec_display_seat_id">
                            <option value="seat_number" <?php selected( $display_seat_id, 'global' ); ?>><?php esc_html_e( 'Global', MECSEATTEXTDOMAIN ); ?></option>
                                <option value="seat_number" <?php selected( $display_seat_id, 'seat_number' ); ?>><?php esc_html_e( 'Seat Number', MECSEATTEXTDOMAIN ); ?></option>
                                <option value="row_number" <?php selected( $display_seat_id, 'row_number' ); ?>><?php esc_html_e( 'Row ID and Row Number', MECSEATTEXTDOMAIN ); ?></option>
                            </select>
                        </div>
                        <div class="mec-form-row">
                            <label class="label-checkbox" for="mec_seat_custom_seat_layout_status">
                                <input id="mec_seat_custom_seat_layout_status" class="mec_seat_custom_seat_layout_status" onchange="jQuery(this).parent().parent().parent().find('#mec-seat-custom-seat-layout').toggle();" value="1" type="checkbox" name="mec_seat_custom_seat_layout_status" <?php checked(true,$custom_seat_layout_status) ?> /> <?php esc_html_e( 'Inherit from global options', MECSEATTEXTDOMAIN ); ?>
                            </label>
                        </div>
                        <div id="mec-seat-custom-seat-layout" <?php echo $custom_seat_layout_status ? 'style="display: none;' : ''; ?>">
                            <?php SeatLayoutBuilder::getInstance()->output( $event_id, $FES ); ?>
                        </div>
                    </div>
                </div>

            </div>

        <?php if( !( -1 === $event_id && $FES ) ): ?>
            <div class="mec-meta-box-fields mec-seat-tab-content" id="mec_meta_box_seat_import_export_seats">
                <?php SeatLayoutBuilder::getInstance()->import_export_html( $event_id, $FES ); ?>
            </div>
        <?php endif; ?>

        </div>
        <?php
    }
}